/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.xjc;

import com.sun.tools.xjc.Options;
import com.sun.tools.xjc.Plugin;
import com.sun.tools.xjc.model.CClass;
import com.sun.tools.xjc.model.CClassInfo;
import com.sun.tools.xjc.model.CClassRef;
import com.sun.tools.xjc.model.CCustomizable;
import com.sun.tools.xjc.model.CPluginCustomization;
import com.sun.tools.xjc.model.Model;
import com.sun.tools.xjc.outline.ClassOutline;
import com.sun.tools.xjc.outline.Outline;
import com.sun.tools.xjc.reader.xmlschema.bindinfo.BIClass;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jpmml.xjc.PluginUtil;
import org.jvnet.jaxb2_commons.plugin.AbstractParameterizablePlugin;
import org.xml.sax.ErrorHandler;

public class SuperClassPlugin
extends AbstractParameterizablePlugin {
    private String defaultName = null;
    private static final String JAVA_URI = "http://java.sun.com/java";

    public String getOptionName() {
        return "XsuperClass";
    }

    public String getUsage() {
        return null;
    }

    public List<String> getCustomizationURIs() {
        return Collections.singletonList(JAVA_URI);
    }

    public boolean isCustomizationTagName(String nsUri, String localName) {
        return nsUri.equals(JAVA_URI) && localName.equals("superClass");
    }

    public void postProcessModel(Model model, ErrorHandler errorHandler) {
        super.postProcessModel(model, errorHandler);
        CClassRef defaultSuperClass = null;
        String defaultName = this.getDefaultName();
        if (defaultName != null) {
            defaultSuperClass = new CClassRef(model, null, SuperClassPlugin.createBIClass(defaultName), null);
        }
        Collection classInfos = model.beans().values();
        for (CClassInfo classInfo : classInfos) {
            CPluginCustomization customization = PluginUtil.getCustomization((CCustomizable)classInfo, (Plugin)this);
            if (customization != null) {
                String name = customization.element.getAttribute("name");
                if (name != null) {
                    CClassRef superClass = new CClassRef(model, null, SuperClassPlugin.createBIClass(name), null);
                    classInfo.setBaseClass((CClass)superClass);
                }
                customization.markAsAcknowledged();
                continue;
            }
            if (defaultSuperClass == null) continue;
            classInfo.setBaseClass((CClass)defaultSuperClass);
        }
    }

    public boolean run(Outline outline, Options options, ErrorHandler errorHandler) {
        Collection clazzes = outline.getClasses();
        for (ClassOutline clazz : clazzes) {
            List<CPluginCustomization> customizations = PluginUtil.getAllCustomizations((CCustomizable)clazz.target, (Plugin)this);
            for (CPluginCustomization customization : customizations) {
                customization.markAsAcknowledged();
            }
        }
        return true;
    }

    public String getDefaultName() {
        return this.defaultName;
    }

    public void setDefaultName(String defaultName) {
        this.defaultName = defaultName;
    }

    private static BIClass createBIClass(String name) {
        try {
            Constructor constructor = BIClass.class.getDeclaredConstructor(new Class[0]);
            if (!constructor.isAccessible()) {
                constructor.setAccessible(true);
            }
            BIClass biClass = (BIClass)constructor.newInstance(new Object[0]);
            Field field = BIClass.class.getDeclaredField("ref");
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            field.set(biClass, name);
            return biClass;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

