/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.xjc;

import com.sun.codemodel.JClass;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JCommentPart;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JDocComment;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldRef;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JJavaName;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JMods;
import com.sun.codemodel.JStatement;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import com.sun.tools.xjc.Options;
import com.sun.tools.xjc.Plugin;
import com.sun.tools.xjc.model.CAttributePropertyInfo;
import com.sun.tools.xjc.model.CClassInfo;
import com.sun.tools.xjc.model.CPropertyInfo;
import com.sun.tools.xjc.model.Model;
import com.sun.tools.xjc.outline.ClassOutline;
import com.sun.tools.xjc.outline.FieldOutline;
import com.sun.tools.xjc.outline.Outline;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.jpmml.xjc.CodeModelUtil;
import org.xml.sax.ErrorHandler;

public class PMMLPlugin
extends Plugin {
    public String getOptionName() {
        return "Xpmml";
    }

    public String getUsage() {
        return null;
    }

    public void postProcessModel(Model model, ErrorHandler errorHandler) {
        super.postProcessModel(model, errorHandler);
        Comparator<CPropertyInfo> comparator = new Comparator<CPropertyInfo>(){

            @Override
            public int compare(CPropertyInfo left, CPropertyInfo right) {
                boolean leftAttribute = left instanceof CAttributePropertyInfo;
                boolean rightAttribute = right instanceof CAttributePropertyInfo;
                if (leftAttribute && !rightAttribute) {
                    return -1;
                }
                if (!leftAttribute && rightAttribute) {
                    return 1;
                }
                return 0;
            }
        };
        Collection classInfos = model.beans().values();
        for (CClassInfo classInfo : classInfos) {
            List propertyInfos = classInfo.getProperties();
            Collections.sort(propertyInfos, comparator);
            for (CPropertyInfo propertyInfo : propertyInfos) {
                String publicName = propertyInfo.getName(true);
                String privateName = propertyInfo.getName(false);
                if (propertyInfo.isCollection()) {
                    if (privateName.contains("And") || privateName.contains("Or") || privateName.equalsIgnoreCase("content")) {
                        propertyInfo.setName(true, "Content");
                        propertyInfo.setName(false, "content");
                        continue;
                    }
                    if (privateName.endsWith("array") || privateName.endsWith("Array")) {
                        publicName = publicName + "s";
                        privateName = privateName + "s";
                    } else if (privateName.endsWith("ref") || privateName.endsWith("Ref")) {
                        publicName = publicName + "s";
                        privateName = privateName + "s";
                    } else {
                        publicName = JJavaName.getPluralForm((String)publicName);
                        privateName = JJavaName.getPluralForm((String)privateName);
                    }
                    propertyInfo.setName(true, publicName);
                    propertyInfo.setName(false, privateName);
                    continue;
                }
                if (!privateName.equals("isScorable")) continue;
                propertyInfo.setName(true, "Scorable");
                propertyInfo.setName(false, "scorable");
            }
        }
    }

    public boolean run(Outline outline, Options options, ErrorHandler errorHandler) {
        Model model = outline.getModel();
        JCodeModel codeModel = model.codeModel;
        JClass hasIdInterface = codeModel.ref("org.dmg.pmml.HasId");
        JClass hasExtensionsInterface = codeModel.ref("org.dmg.pmml.HasExtensions");
        JClass iterableInterface = codeModel.ref("java.lang.Iterable");
        JClass iteratorInterface = codeModel.ref("java.util.Iterator");
        JClass arraysClass = codeModel.ref("java.util.Arrays");
        Collection clazzes = outline.getClasses();
        for (ClassOutline clazz : clazzes) {
            FieldOutline[] fields;
            FieldOutline contentField;
            FieldOutline extensionsField;
            JClass superClazz;
            JDefinedClass beanClazz = clazz.implClass;
            Map fieldVars = beanClazz.fields();
            String fullName = beanClazz.fullName();
            if ("org.dmg.pmml.IntSparseArray".equals(fullName)) {
                superClazz = beanClazz._extends();
                beanClazz._extends(superClazz.narrow(Integer.class));
            } else if ("org.dmg.pmml.RealSparseArray".equals(fullName)) {
                superClazz = beanClazz._extends();
                beanClazz._extends(superClazz.narrow(Double.class));
            }
            FieldOutline idField = PMMLPlugin.getIdField(clazz);
            if (idField != null) {
                beanClazz._implements(hasIdInterface);
            }
            if ((extensionsField = PMMLPlugin.getExtensionsField(clazz)) != null) {
                beanClazz._implements(hasExtensionsInterface);
            }
            if ((contentField = PMMLPlugin.getContentField(clazz)) != null) {
                CPropertyInfo propertyInfo = contentField.getPropertyInfo();
                JFieldVar fieldVar = (JFieldVar)fieldVars.get(propertyInfo.getName(false));
                JType elementType = CodeModelUtil.getElementType(fieldVar.type());
                beanClazz._implements(iterableInterface.narrow(elementType));
                JMethod iteratorMethod = beanClazz.method(1, (JType)iteratorInterface.narrow(elementType), "iterator");
                iteratorMethod.body()._return((JExpression)JExpr.invoke((String)("get" + propertyInfo.getName(true))).invoke("iterator"));
            }
            for (FieldOutline field : fields = clazz.getDeclaredFields()) {
                CPropertyInfo propertyInfo = field.getPropertyInfo();
                JFieldVar fieldVar = (JFieldVar)fieldVars.get(propertyInfo.getName(false));
                JMods modifiers = fieldVar.mods();
                if ((modifiers.getValue() & 4) != 4) {
                    modifiers.setPrivate();
                }
                JType type = fieldVar.type();
                JMethod getterMethod = beanClazz.getMethod("get" + propertyInfo.getName(true), new JType[0]);
                JMethod setterMethod = beanClazz.getMethod("set" + propertyInfo.getName(true), new JType[]{type});
                if (setterMethod != null) {
                    setterMethod.type((JType)beanClazz);
                    JVar param = (JVar)setterMethod.params().get(0);
                    String paramName = param.name();
                    param.name(fieldVar.name());
                    JDocComment javadoc = setterMethod.javadoc();
                    try {
                        Map atParams;
                        JCommentPart paramComment;
                        Field atParamsField = JDocComment.class.getDeclaredField("atParams");
                        if (!atParamsField.isAccessible()) {
                            atParamsField.setAccessible(true);
                        }
                        if ((paramComment = (JCommentPart)(atParams = (Map)atParamsField.get(javadoc)).remove(paramName)) != null) {
                            atParams.put(fieldVar.name(), paramComment);
                        }
                    }
                    catch (ReflectiveOperationException roe) {
                        throw new RuntimeException(roe);
                    }
                    setterMethod.body()._return(JExpr._this());
                }
                if (!propertyInfo.isCollection()) continue;
                JType elementType = CodeModelUtil.getElementType(type);
                JFieldRef fieldRef = JExpr.refthis((String)fieldVar.name());
                JMethod hasElementsMethod = beanClazz.method(1, Boolean.TYPE, "has" + propertyInfo.getName(true));
                hasElementsMethod.body()._return(fieldRef.ne(JExpr._null()).cand(fieldRef.invoke("size").gt(JExpr.lit((int)0))));
                JMethod addElementsMethod = beanClazz.method(1, (JType)beanClazz, "add" + propertyInfo.getName(true));
                JVar param = addElementsMethod.varParam(elementType, fieldVar.name());
                addElementsMethod.body().add((JStatement)JExpr.invoke((JMethod)getterMethod).invoke("addAll").arg((JExpression)arraysClass.staticInvoke("asList").arg((JExpression)param)));
                addElementsMethod.body()._return(JExpr._this());
            }
        }
        return true;
    }

    private static FieldOutline getIdField(ClassOutline clazz) {
        FieldFilter filter = new FieldFilter(){

            @Override
            public boolean accept(CPropertyInfo propertyInfo, JType type) {
                return "id".equals(propertyInfo.getName(false)) && "java.lang.String".equals(type.fullName());
            }
        };
        return PMMLPlugin.find(clazz, filter);
    }

    private static FieldOutline getExtensionsField(ClassOutline clazz) {
        FieldFilter filter = new FieldFilter(){

            @Override
            public boolean accept(CPropertyInfo propertyInfo, JType type) {
                if ("extensions".equals(propertyInfo.getName(false)) && propertyInfo.isCollection()) {
                    JType elementType = CodeModelUtil.getElementType(type);
                    return "org.dmg.pmml.Extension".equals(elementType.fullName());
                }
                return false;
            }
        };
        return PMMLPlugin.find(clazz, filter);
    }

    private static FieldOutline getContentField(final ClassOutline clazz) {
        FieldFilter filter = new FieldFilter(){
            private String name;
            {
                this.name = clazz.implClass.name();
            }

            @Override
            public boolean accept(CPropertyInfo propertyInfo, JType type) {
                if (propertyInfo.isCollection()) {
                    JType elementType = CodeModelUtil.getElementType(type);
                    String name = elementType.name();
                    return this.name.equals(name + "s") || this.name.equals(JJavaName.getPluralForm((String)name));
                }
                return false;
            }
        };
        return PMMLPlugin.find(clazz, filter);
    }

    private static FieldOutline find(ClassOutline clazz, FieldFilter filter) {
        FieldOutline[] fields;
        for (FieldOutline field : fields = clazz.getDeclaredFields()) {
            JType type;
            CPropertyInfo propertyInfo = field.getPropertyInfo();
            if (!filter.accept(propertyInfo, type = field.getRawType())) continue;
            return field;
        }
        return null;
    }

    private static interface FieldFilter {
        public boolean accept(CPropertyInfo var1, JType var2);
    }
}

