/*
 * Decompiled with CFR 0.152.
 */
package org.dmg.pmml;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.PMMLAttributes;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.ScoreDistribution;
import org.dmg.pmml.Version;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.NumberAdapter;
import org.dmg.pmml.adapters.ObjectAdapter;
import org.dmg.pmml.adapters.ProbabilityNumberAdapter;
import org.jpmml.model.MissingAttributeException;
import org.jpmml.model.annotations.Added;
import org.jpmml.model.annotations.CopyConstructor;
import org.jpmml.model.annotations.Optional;
import org.jpmml.model.annotations.Property;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name="ScoreDistribution", namespace="http://www.dmg.org/PMML-4_4")
@XmlType(name="", propOrder={"extensions"})
@JsonRootName(value="ScoreDistribution")
@JsonPropertyOrder(value={"value", "recordCount", "confidence", "probability", "extensions"})
public class ComplexScoreDistribution
extends ScoreDistribution
implements HasExtensions<ComplexScoreDistribution> {
    @XmlAttribute(name="value", required=true)
    @XmlJavaTypeAdapter(value=ObjectAdapter.class)
    @XmlSchemaType(name="anySimpleType")
    @JsonProperty(value="value")
    private Object value;
    @XmlAttribute(name="recordCount")
    @XmlJavaTypeAdapter(value=NumberAdapter.class)
    @JsonProperty(value="recordCount")
    @Optional(value=Version.XPMML)
    private Number recordCount;
    @XmlAttribute(name="confidence")
    @XmlJavaTypeAdapter(value=NumberAdapter.class)
    @JsonProperty(value="confidence")
    @Added(value=Version.PMML_3_1)
    private Number confidence;
    @XmlAttribute(name="probability")
    @XmlJavaTypeAdapter(value=ProbabilityNumberAdapter.class)
    @JsonProperty(value="probability")
    @Added(value=Version.PMML_4_1)
    private Number probability;
    @XmlElement(name="Extension", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="Extension")
    private List<Extension> extensions;
    private static final long serialVersionUID = 67371270L;

    public ComplexScoreDistribution() {
    }

    @CopyConstructor
    public ComplexScoreDistribution(ScoreDistribution scoreDistribution) {
        this.setValue(scoreDistribution.getValue());
        this.setRecordCount(scoreDistribution.getRecordCount());
        this.setConfidence(scoreDistribution.getConfidence());
        this.setProbability(scoreDistribution.getProbability());
        if (scoreDistribution.hasExtensions()) {
            this.getExtensions().addAll(scoreDistribution.getExtensions());
        }
    }

    @ValueConstructor
    public ComplexScoreDistribution(@Property(value="value") Object value, @Property(value="recordCount") Number recordCount) {
        this.value = value;
        this.recordCount = recordCount;
    }

    @Override
    public Object requireValue() {
        if (this.value == null) {
            throw new MissingAttributeException(this, PMMLAttributes.COMPLEXSCOREDISTRIBUTION_VALUE);
        }
        return this.value;
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public ComplexScoreDistribution setValue(@Property(value="value") Object value) {
        this.value = value;
        return this;
    }

    @Override
    public Number requireRecordCount() {
        if (this.recordCount == null) {
            throw new MissingAttributeException(this, PMMLAttributes.COMPLEXSCOREDISTRIBUTION_RECORDCOUNT);
        }
        return this.recordCount;
    }

    @Override
    public Number getRecordCount() {
        return this.recordCount;
    }

    @Override
    public ComplexScoreDistribution setRecordCount(@Property(value="recordCount") Number recordCount) {
        this.recordCount = recordCount;
        return this;
    }

    @Override
    public Number getConfidence() {
        return this.confidence;
    }

    @Override
    public ComplexScoreDistribution setConfidence(@Property(value="confidence") Number confidence) {
        this.confidence = confidence;
        return this;
    }

    @Override
    public Number requireProbability() {
        if (this.probability == null) {
            throw new MissingAttributeException(this, PMMLAttributes.COMPLEXSCOREDISTRIBUTION_PROBABILITY);
        }
        return this.probability;
    }

    @Override
    public Number getProbability() {
        return this.probability;
    }

    @Override
    public ComplexScoreDistribution setProbability(@Property(value="probability") Number probability) {
        this.probability = probability;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return this.extensions != null && !this.extensions.isEmpty();
    }

    @Override
    public List<Extension> getExtensions() {
        if (this.extensions == null) {
            this.extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public ComplexScoreDistribution addExtensions(Extension ... extensions) {
        this.getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public ComplexScoreDistribution toComplexScoreDistribution() {
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if (status == VisitorAction.CONTINUE && this.hasExtensions()) {
                status = PMMLObject.traverse(visitor, this.getExtensions());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }
}

