/*
 * Decompiled with CFR 0.152.
 */
package org.dmg.pmml.naive_bayes;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.HasTargetFieldReference;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Version;
import org.dmg.pmml.Visitable;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.FieldNameAdapter;
import org.dmg.pmml.naive_bayes.PMMLElements;
import org.dmg.pmml.naive_bayes.TargetValueCounts;
import org.jpmml.model.MissingElementException;
import org.jpmml.model.annotations.Optional;
import org.jpmml.model.annotations.Property;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name="BayesOutput", namespace="http://www.dmg.org/PMML-4_4")
@XmlType(name="", propOrder={"extensions", "targetValueCounts"})
@JsonRootName(value="BayesOutput")
@JsonPropertyOrder(value={"field", "extensions", "targetValueCounts"})
public class BayesOutput
extends PMMLObject
implements HasExtensions<BayesOutput>,
HasTargetFieldReference<BayesOutput> {
    @XmlAttribute(name="fieldName")
    @XmlJavaTypeAdapter(value=FieldNameAdapter.class)
    @Optional(value=Version.XPMML)
    @JsonProperty(value="fieldName")
    private String field;
    @XmlElement(name="Extension", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="Extension")
    private List<Extension> extensions;
    @XmlElement(name="TargetValueCounts", namespace="http://www.dmg.org/PMML-4_4", required=true)
    @JsonProperty(value="TargetValueCounts")
    private TargetValueCounts targetValueCounts;
    private static final long serialVersionUID = 67371269L;

    public BayesOutput() {
    }

    @ValueConstructor
    public BayesOutput(@Property(value="targetValueCounts") TargetValueCounts targetValueCounts) {
        this.targetValueCounts = targetValueCounts;
    }

    @Override
    public String getTargetField() {
        return this.getField();
    }

    @Override
    public BayesOutput setTargetField(String targetField) {
        return this.setField(targetField);
    }

    public String getField() {
        return this.field;
    }

    public BayesOutput setField(@Property(value="field") String field) {
        this.field = field;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return this.extensions != null && !this.extensions.isEmpty();
    }

    @Override
    public List<Extension> getExtensions() {
        if (this.extensions == null) {
            this.extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public BayesOutput addExtensions(Extension ... extensions) {
        this.getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public TargetValueCounts requireTargetValueCounts() {
        if (this.targetValueCounts == null) {
            throw new MissingElementException(this, PMMLElements.BAYESOUTPUT_TARGETVALUECOUNTS);
        }
        return this.targetValueCounts;
    }

    public TargetValueCounts getTargetValueCounts() {
        return this.targetValueCounts;
    }

    public BayesOutput setTargetValueCounts(@Property(value="targetValueCounts") TargetValueCounts targetValueCounts) {
        this.targetValueCounts = targetValueCounts;
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if (status == VisitorAction.CONTINUE && this.hasExtensions()) {
                status = PMMLObject.traverse(visitor, this.getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = PMMLObject.traverse(visitor, (Visitable)this.getTargetValueCounts());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }
}

