/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.model.visitors;

import org.dmg.pmml.MathContext;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.tree.DecisionTree;
import org.dmg.pmml.tree.Node;
import org.dmg.pmml.tree.TreeModel;
import org.jpmml.model.visitors.AbstractVisitor;
import org.jpmml.model.visitors.Resettable;

public class NodeScoreOptimizer
extends AbstractVisitor
implements Resettable {
    private MathContext mathContext = null;

    @Override
    public void reset() {
        this.mathContext = null;
    }

    @Override
    public VisitorAction visit(DecisionTree decisionTree) {
        throw new UnsupportedOperationException();
    }

    @Override
    public VisitorAction visit(TreeModel treeModel) {
        MiningFunction miningFunction = treeModel.getMiningFunction();
        if (miningFunction != null) {
            switch (miningFunction) {
                case REGRESSION: {
                    this.mathContext = treeModel.getMathContext();
                    break;
                }
                default: {
                    this.mathContext = null;
                }
            }
        }
        if (this.mathContext == null) {
            return VisitorAction.SKIP;
        }
        return super.visit(treeModel);
    }

    @Override
    public VisitorAction visit(Node node) {
        Object score;
        MathContext mathContext = this.mathContext;
        if (mathContext != null && node.hasScore() && (score = node.getScore()) instanceof String) {
            String stringScore = (String)score;
            try {
                switch (mathContext) {
                    case DOUBLE: {
                        node.setScore(Double.parseDouble(stringScore));
                        break;
                    }
                    case FLOAT: {
                        node.setScore(Float.valueOf(Float.parseFloat(stringScore)));
                        break;
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return super.visit(node);
    }
}

