/*
 * Decompiled with CFR 0.152.
 */
package org.dmg.pmml.clustering;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.CompareFunction;
import org.dmg.pmml.ComparisonField;
import org.dmg.pmml.Extension;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Version;
import org.dmg.pmml.Visitable;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.FieldNameAdapter;
import org.dmg.pmml.clustering.Comparisons;
import org.jpmml.model.annotations.Added;
import org.jpmml.model.annotations.Property;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="", propOrder={"extensions", "comparisons"})
@XmlRootElement(name="ClusteringField", namespace="http://www.dmg.org/PMML-4_3")
public class ClusteringField
extends ComparisonField<ClusteringField>
implements HasExtensions<ClusteringField> {
    @XmlAttribute(name="field", required=true)
    @XmlJavaTypeAdapter(value=FieldNameAdapter.class)
    private FieldName field;
    @XmlAttribute(name="isCenterField")
    @Added(value=Version.PMML_3_2)
    private CenterField centerField;
    @XmlAttribute(name="fieldWeight")
    private Double fieldWeight;
    @XmlAttribute(name="similarityScale")
    private Double similarityScale;
    @XmlAttribute(name="compareFunction")
    private CompareFunction compareFunction;
    @XmlElement(name="Extension", namespace="http://www.dmg.org/PMML-4_3")
    private List<Extension> extensions;
    @XmlElement(name="Comparisons", namespace="http://www.dmg.org/PMML-4_3")
    private Comparisons comparisons;
    private static final Double DEFAULT_FIELD_WEIGHT = 1.0;
    private static final long serialVersionUID = 67305481L;

    public ClusteringField() {
    }

    public ClusteringField(@Property(value="field") FieldName field) {
        this.field = field;
    }

    @Override
    public FieldName getField() {
        return this.field;
    }

    @Override
    public ClusteringField setField(@Property(value="field") FieldName field) {
        this.field = field;
        return this;
    }

    public CenterField getCenterField() {
        if (this.centerField == null) {
            return CenterField.TRUE;
        }
        return this.centerField;
    }

    public ClusteringField setCenterField(@Property(value="centerField") CenterField centerField) {
        this.centerField = centerField;
        return this;
    }

    @Override
    public Double getFieldWeight() {
        if (this.fieldWeight == null) {
            return DEFAULT_FIELD_WEIGHT;
        }
        return this.fieldWeight;
    }

    @Override
    public ClusteringField setFieldWeight(@Property(value="fieldWeight") Double fieldWeight) {
        this.fieldWeight = fieldWeight;
        return this;
    }

    @Override
    public Double getSimilarityScale() {
        return this.similarityScale;
    }

    @Override
    public ClusteringField setSimilarityScale(@Property(value="similarityScale") Double similarityScale) {
        this.similarityScale = similarityScale;
        return this;
    }

    @Override
    public CompareFunction getCompareFunction() {
        return this.compareFunction;
    }

    @Override
    public ClusteringField setCompareFunction(@Property(value="compareFunction") CompareFunction compareFunction) {
        this.compareFunction = compareFunction;
        return this;
    }

    @Override
    public List<Extension> getExtensions() {
        if (this.extensions == null) {
            this.extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    public Comparisons getComparisons() {
        return this.comparisons;
    }

    public ClusteringField setComparisons(@Property(value="comparisons") Comparisons comparisons) {
        this.comparisons = comparisons;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return this.extensions != null && this.extensions.size() > 0;
    }

    @Override
    public ClusteringField addExtensions(Extension ... extensions) {
        this.getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if (status == VisitorAction.CONTINUE && this.hasExtensions()) {
                status = PMMLObject.traverse(visitor, this.getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = PMMLObject.traverse(visitor, (Visitable)this.getComparisons());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

    @XmlType(name="")
    @XmlEnum
    public static enum CenterField {
        TRUE("true"),
        FALSE("false");

        private final String value;

        private CenterField(String v) {
            this.value = v;
        }

        public String value() {
            return this.value;
        }

        public static CenterField fromValue(String v) {
            for (CenterField c : CenterField.values()) {
                if (!c.value.equals(v)) continue;
                return c;
            }
            throw new IllegalArgumentException(v);
        }
    }
}

