/*
 * Decompiled with CFR 0.152.
 */
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.dmg.pmml.Array;
import org.dmg.pmml.MatCell;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.jpmml.model.annotations.Property;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="", propOrder={"arrays", "matCells"})
@XmlRootElement(name="Matrix", namespace="http://www.dmg.org/PMML-4_3")
public class Matrix
extends PMMLObject {
    @XmlAttribute(name="kind")
    private Kind kind;
    @XmlAttribute(name="nbRows")
    private Integer nbRows;
    @XmlAttribute(name="nbCols")
    private Integer nbCols;
    @XmlAttribute(name="diagDefault")
    private Double diagDefault;
    @XmlAttribute(name="offDiagDefault")
    private Double offDiagDefault;
    @XmlElement(name="Array", namespace="http://www.dmg.org/PMML-4_3")
    private List<Array> arrays;
    @XmlElement(name="MatCell", namespace="http://www.dmg.org/PMML-4_3")
    private List<MatCell> matCells;
    private static final long serialVersionUID = 67305481L;

    public Kind getKind() {
        if (this.kind == null) {
            return Kind.ANY;
        }
        return this.kind;
    }

    public Matrix setKind(@Property(value="kind") Kind kind) {
        this.kind = kind;
        return this;
    }

    public Integer getNbRows() {
        return this.nbRows;
    }

    public Matrix setNbRows(@Property(value="nbRows") Integer nbRows) {
        this.nbRows = nbRows;
        return this;
    }

    public Integer getNbCols() {
        return this.nbCols;
    }

    public Matrix setNbCols(@Property(value="nbCols") Integer nbCols) {
        this.nbCols = nbCols;
        return this;
    }

    public Double getDiagDefault() {
        return this.diagDefault;
    }

    public Matrix setDiagDefault(@Property(value="diagDefault") Double diagDefault) {
        this.diagDefault = diagDefault;
        return this;
    }

    public Double getOffDiagDefault() {
        return this.offDiagDefault;
    }

    public Matrix setOffDiagDefault(@Property(value="offDiagDefault") Double offDiagDefault) {
        this.offDiagDefault = offDiagDefault;
        return this;
    }

    public List<Array> getArrays() {
        if (this.arrays == null) {
            this.arrays = new ArrayList<Array>();
        }
        return this.arrays;
    }

    public List<MatCell> getMatCells() {
        if (this.matCells == null) {
            this.matCells = new ArrayList<MatCell>();
        }
        return this.matCells;
    }

    public boolean hasArrays() {
        return this.arrays != null && this.arrays.size() > 0;
    }

    public Matrix addArrays(Array ... arrays) {
        this.getArrays().addAll(Arrays.asList(arrays));
        return this;
    }

    public boolean hasMatCells() {
        return this.matCells != null && this.matCells.size() > 0;
    }

    public Matrix addMatCells(MatCell ... matCells) {
        this.getMatCells().addAll(Arrays.asList(matCells));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if (status == VisitorAction.CONTINUE && this.hasArrays()) {
                status = PMMLObject.traverse(visitor, this.getArrays());
            }
            if (status == VisitorAction.CONTINUE && this.hasMatCells()) {
                status = PMMLObject.traverse(visitor, this.getMatCells());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

    @XmlType(name="")
    @XmlEnum
    public static enum Kind {
        DIAGONAL("diagonal"),
        SYMMETRIC("symmetric"),
        ANY("any");

        private final String value;

        private Kind(String v) {
            this.value = v;
        }

        public String value() {
            return this.value;
        }

        public static Kind fromValue(String v) {
            for (Kind c : Kind.values()) {
                if (!c.value.equals(v)) continue;
                return c;
            }
            throw new IllegalArgumentException(v);
        }
    }
}

