/*
 * Decompiled with CFR 0.152.
 */
package org.dmg.pmml.support_vector_machine;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.support_vector_machine.Kernel;
import org.jpmml.model.Property;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="", propOrder={"extensions"})
public class SigmoidKernel
extends Kernel
implements HasExtensions<SigmoidKernel> {
    @XmlAttribute(name="description")
    private String description;
    @XmlAttribute(name="gamma")
    private Double gamma;
    @XmlAttribute(name="coef0")
    private Double coef0;
    @XmlElement(name="Extension", namespace="http://www.dmg.org/PMML-4_3")
    private List<Extension> extensions;
    private static final Double DEFAULT_GAMMA = 1.0;
    private static final Double DEFAULT_COEF0 = 1.0;
    private static final long serialVersionUID = 0x4030003L;

    public String getDescription() {
        return this.description;
    }

    public SigmoidKernel setDescription(@Property(value="description") String description) {
        this.description = description;
        return this;
    }

    public Double getGamma() {
        if (this.gamma == null) {
            return DEFAULT_GAMMA;
        }
        return this.gamma;
    }

    public SigmoidKernel setGamma(@Property(value="gamma") Double gamma) {
        this.gamma = gamma;
        return this;
    }

    public Double getCoef0() {
        if (this.coef0 == null) {
            return DEFAULT_COEF0;
        }
        return this.coef0;
    }

    public SigmoidKernel setCoef0(@Property(value="coef0") Double coef0) {
        this.coef0 = coef0;
        return this;
    }

    @Override
    public List<Extension> getExtensions() {
        if (this.extensions == null) {
            this.extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public boolean hasExtensions() {
        return this.extensions != null && this.extensions.size() > 0;
    }

    @Override
    public SigmoidKernel addExtensions(Extension ... extensions) {
        this.getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if (status == VisitorAction.CONTINUE && this.hasExtensions()) {
                status = PMMLObject.traverse(visitor, this.getExtensions());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }
}

