/*
 * Decompiled with CFR 0.152.
 */
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.dmg.pmml.DataField;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Taxonomy;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.jpmml.model.Property;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="", propOrder={"extensions", "dataFields", "taxonomies"})
@XmlRootElement(name="DataDictionary", namespace="http://www.dmg.org/PMML-4_3")
public class DataDictionary
extends PMMLObject
implements HasExtensions<DataDictionary> {
    @XmlAttribute(name="numberOfFields")
    private Integer numberOfFields;
    @XmlElement(name="Extension", namespace="http://www.dmg.org/PMML-4_3")
    private List<Extension> extensions;
    @XmlElement(name="DataField", namespace="http://www.dmg.org/PMML-4_3", required=true)
    private List<DataField> dataFields;
    @XmlElement(name="Taxonomy", namespace="http://www.dmg.org/PMML-4_3")
    private List<Taxonomy> taxonomies;
    private static final long serialVersionUID = 0x4030003L;

    public DataDictionary() {
    }

    public DataDictionary(@Property(value="dataFields") List<DataField> dataFields) {
        this.dataFields = dataFields;
    }

    public Integer getNumberOfFields() {
        return this.numberOfFields;
    }

    public DataDictionary setNumberOfFields(@Property(value="numberOfFields") Integer numberOfFields) {
        this.numberOfFields = numberOfFields;
        return this;
    }

    @Override
    public List<Extension> getExtensions() {
        if (this.extensions == null) {
            this.extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    public List<DataField> getDataFields() {
        if (this.dataFields == null) {
            this.dataFields = new ArrayList<DataField>();
        }
        return this.dataFields;
    }

    public List<Taxonomy> getTaxonomies() {
        if (this.taxonomies == null) {
            this.taxonomies = new ArrayList<Taxonomy>();
        }
        return this.taxonomies;
    }

    @Override
    public boolean hasExtensions() {
        return this.extensions != null && this.extensions.size() > 0;
    }

    @Override
    public DataDictionary addExtensions(Extension ... extensions) {
        this.getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public boolean hasDataFields() {
        return this.dataFields != null && this.dataFields.size() > 0;
    }

    public DataDictionary addDataFields(DataField ... dataFields) {
        this.getDataFields().addAll(Arrays.asList(dataFields));
        return this;
    }

    public boolean hasTaxonomies() {
        return this.taxonomies != null && this.taxonomies.size() > 0;
    }

    public DataDictionary addTaxonomies(Taxonomy ... taxonomies) {
        this.getTaxonomies().addAll(Arrays.asList(taxonomies));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if (status == VisitorAction.CONTINUE && this.hasExtensions()) {
                status = PMMLObject.traverse(visitor, this.getExtensions());
            }
            if (status == VisitorAction.CONTINUE && this.hasDataFields()) {
                status = PMMLObject.traverse(visitor, this.getDataFields());
            }
            if (status == VisitorAction.CONTINUE && this.hasTaxonomies()) {
                status = PMMLObject.traverse(visitor, this.getTaxonomies());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }
}

