/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.model.visitors;

import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.dmg.pmml.DataDictionary;
import org.dmg.pmml.DataField;
import org.dmg.pmml.Field;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.MiningField;
import org.dmg.pmml.MiningSchema;
import org.dmg.pmml.Model;
import org.dmg.pmml.PMML;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Visitable;
import org.jpmml.model.FieldUtil;
import org.jpmml.model.visitors.FieldDependencyResolver;
import org.jpmml.model.visitors.ModelCleaner;

public class DataDictionaryCleaner
extends ModelCleaner {
    private Set<Field> targetFields = new HashSet<Field>();

    @Override
    public void applyTo(Visitable visitable) {
        this.targetFields.clear();
        super.applyTo(visitable);
    }

    @Override
    public PMMLObject popParent() {
        PMML pmml;
        DataDictionary dataDictionary;
        PMMLObject parent = super.popParent();
        if (parent instanceof Model) {
            Model model = (Model)parent;
            this.processModel(model);
        } else if (parent instanceof PMML && (dataDictionary = (pmml = (PMML)parent).getDataDictionary()) != null) {
            this.processDataDictionary(dataDictionary);
        }
        return parent;
    }

    private void processModel(Model model) {
        Set<Field> targetFields = this.getTargetFields();
        MiningSchema miningSchema = model.getMiningSchema();
        if (miningSchema != null && miningSchema.hasMiningFields()) {
            LinkedHashSet<FieldName> targetFieldNames = new LinkedHashSet<FieldName>();
            List<MiningField> miningFields = miningSchema.getMiningFields();
            for (MiningField miningField : miningFields) {
                FieldName name = miningField.getName();
                MiningField.FieldUsage fieldUsage = miningField.getFieldUsage();
                switch (fieldUsage) {
                    case TARGET: 
                    case PREDICTED: {
                        targetFieldNames.add(name);
                        break;
                    }
                }
            }
            if (targetFieldNames.size() > 0) {
                Set<Field> modelFields = this.getFields(model);
                targetFields.addAll(FieldUtil.selectAll(modelFields, targetFieldNames));
            }
        }
    }

    private void processDataDictionary(DataDictionary dataDictionary) {
        if (dataDictionary.hasDataFields()) {
            List<DataField> dataFields = dataDictionary.getDataFields();
            Set<DataField> usedDataFields = this.getUsedDataFields();
            dataFields.retainAll(usedDataFields);
        }
    }

    private Set<DataField> getUsedDataFields() {
        FieldDependencyResolver fieldDependencyResolver = this.getFieldDependencyResolver();
        HashSet<Field> usedFields = new HashSet<Field>(this.getActiveFields());
        usedFields.addAll(this.getTargetFields());
        fieldDependencyResolver.expand(usedFields, fieldDependencyResolver.getLocalDerivedFields());
        fieldDependencyResolver.expand(usedFields, fieldDependencyResolver.getGlobalDerivedFields());
        return usedFields;
    }

    public Set<Field> getTargetFields() {
        return this.targetFields;
    }
}

