/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.model.visitors;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.dmg.pmml.Apply;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Visitable;
import org.dmg.pmml.VisitorAction;
import org.jpmml.model.ReflectionUtil;
import org.jpmml.model.visitors.AbstractSimpleVisitor;
import org.jpmml.schema.Added;
import org.jpmml.schema.Removed;
import org.jpmml.schema.Version;

public class VersionInspector
extends AbstractSimpleVisitor {
    private Version minimum = Version.getMinimum();
    private Version maximum = Version.getMaximum();
    private static Map<String, Version> functionVersions = new LinkedHashMap<String, Version>();

    @Override
    public void applyTo(Visitable visitable) {
        this.minimum = Version.getMinimum();
        this.maximum = Version.getMaximum();
        super.applyTo(visitable);
    }

    @Override
    public VisitorAction visit(PMMLObject object) {
        for (Class<?> clazz = object.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            this.inspect(clazz);
        }
        List<Field> fields = ReflectionUtil.getAllInstanceFields(object);
        for (Field field : fields) {
            Field enumField;
            Class<?> type;
            Object value = ReflectionUtil.getFieldValue(field, object);
            if (value == null || (type = field.getType()).isPrimitive() && ReflectionUtil.isDefaultValue(value)) continue;
            this.inspect(field);
            if (!(value instanceof Enum)) continue;
            Enum enumValue = (Enum)value;
            try {
                Class<?> enumClazz = enumValue.getClass();
                enumField = enumClazz.getField(enumValue.name());
            }
            catch (NoSuchFieldException nsfe) {
                throw new RuntimeException(nsfe);
            }
            this.inspect(enumField);
        }
        return VisitorAction.CONTINUE;
    }

    @Override
    public VisitorAction visit(Apply apply) {
        this.inspect(apply.getFunction());
        return super.visit(apply);
    }

    private void inspect(AnnotatedElement element) {
        Removed removed;
        Added added = element.getAnnotation(Added.class);
        if (added != null) {
            this.updateMinimum(added.value());
        }
        if ((removed = element.getAnnotation(Removed.class)) != null) {
            this.updateMaximum(removed.value());
        }
    }

    private void inspect(String function) {
        Version version = functionVersions.get(function);
        if (version != null) {
            this.updateMinimum(version);
        }
    }

    public Version getMinimum() {
        return this.minimum;
    }

    private void updateMinimum(Version minimum) {
        if (minimum != null && minimum.compareTo((Enum)this.minimum) > 0) {
            this.minimum = minimum;
        }
    }

    public Version getMaximum() {
        return this.maximum;
    }

    private void updateMaximum(Version maximum) {
        if (maximum != null && maximum.compareTo((Enum)this.maximum) < 0) {
            this.maximum = maximum;
        }
    }

    private static void declareFunctions(Version version, String ... functions) {
        for (String function : functions) {
            functionVersions.put(function, version);
        }
    }

    static {
        VersionInspector.declareFunctions(Version.PMML_3_0, "+", "-", "*", "/", "min", "max", "sum", "avg", "log10", "ln", "sqrt", "abs", "uppercase", "substring", "trimBlanks", "formatNumber", "formatDatetime", "dateDaysSinceYear", "dateSecondsSinceYear", "dateSecondsSinceMidnight");
        VersionInspector.declareFunctions(Version.PMML_3_1, "exp", "pow", "threshold", "floor", "ceil", "round");
        VersionInspector.declareFunctions(Version.PMML_4_0, "isMissing", "isNotMissing", "equal", "notEqual", "lessThan", "lessOrEqual", "greaterThan", "greaterOrEqual", "and", "or", "not", "isIn", "isNotIn", "if");
        VersionInspector.declareFunctions(Version.PMML_4_1, "median", "product", "lowercase");
        VersionInspector.declareFunctions(Version.PMML_4_2, "concat", "replace", "matches");
    }
}

