/*
 * Decompiled with CFR 0.152.
 */
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlList;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.SparseArray;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.IntegerAdapter;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="", propOrder={"indices", "entries"})
@XmlRootElement(name="INT-SparseArray", namespace="http://www.dmg.org/PMML-4_2")
public class IntSparseArray
extends SparseArray<Integer> {
    @XmlAttribute(name="n")
    @XmlJavaTypeAdapter(value=IntegerAdapter.class)
    private Integer n;
    @XmlAttribute(name="defaultValue")
    @XmlJavaTypeAdapter(value=IntegerAdapter.class)
    private Integer defaultValue;
    @XmlList
    @XmlElement(name="Indices", namespace="http://www.dmg.org/PMML-4_2", type=Integer.class)
    private List<Integer> indices;
    @XmlList
    @XmlElement(name="INT-Entries", namespace="http://www.dmg.org/PMML-4_2", type=Integer.class)
    private List<Integer> entries;

    @Override
    public Integer getN() {
        return this.n;
    }

    public IntSparseArray setN(Integer n) {
        this.n = n;
        return this;
    }

    @Override
    public Integer getDefaultValue() {
        if (this.defaultValue == null) {
            return new IntegerAdapter().unmarshal("0");
        }
        return this.defaultValue;
    }

    public IntSparseArray setDefaultValue(Integer defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    @Override
    public List<Integer> getIndices() {
        if (this.indices == null) {
            this.indices = new ArrayList<Integer>();
        }
        return this.indices;
    }

    @Override
    public List<Integer> getEntries() {
        if (this.entries == null) {
            this.entries = new ArrayList<Integer>();
        }
        return this.entries;
    }

    public boolean hasIndices() {
        return this.indices != null && this.indices.size() > 0;
    }

    public IntSparseArray addIndices(Integer ... indices) {
        this.getIndices().addAll(Arrays.asList(indices));
        return this;
    }

    public boolean hasEntries() {
        return this.entries != null && this.entries.size() > 0;
    }

    public IntSparseArray addEntries(Integer ... entries) {
        this.getEntries().addAll(Arrays.asList(entries));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        visitor.pushParent(this);
        visitor.popParent();
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }
}

