/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.model.visitors;

import java.lang.reflect.Field;
import java.util.List;
import org.dmg.pmml.FeatureType;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.OutputField;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.VisitorAction;
import org.jpmml.model.ReflectionUtil;
import org.jpmml.model.visitors.AbstractSimpleVisitor;

public abstract class FieldNameFilterer
extends AbstractSimpleVisitor {
    public abstract FieldName filter(FieldName var1);

    @Override
    public VisitorAction visit(PMMLObject object) {
        List<Field> fields = ReflectionUtil.getInstanceFields(object.getClass());
        for (Field field : fields) {
            if (!FieldName.class.equals(field.getType())) continue;
            FieldName name = (FieldName)ReflectionUtil.getFieldValue(field, object);
            name = this.filter(name);
            ReflectionUtil.setFieldValue(field, object, name);
        }
        return VisitorAction.CONTINUE;
    }

    @Override
    public VisitorAction visit(OutputField outputField) {
        FeatureType feature = outputField.getFeature();
        switch (feature) {
            case TRANSFORMED_VALUE: 
            case DECISION: {
                String segmentId = outputField.getSegmentId();
                if (segmentId == null) break;
                outputField.setValue(this.filter(outputField.getValue()));
                break;
            }
        }
        return super.visit(outputField);
    }

    private String filter(String value) {
        FieldName name = value != null ? FieldName.create(value) : null;
        name = this.filter(name);
        return name != null ? name.getValue() : null;
    }
}

