/*
 * Decompiled with CFR 0.152.
 */
package org.dmg.pmml;

import com.sun.xml.bind.Locatable;
import com.sun.xml.bind.annotation.XmlLocation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.Expression;
import org.dmg.pmml.Extension;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.FieldNameAdapter;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.xml.sax.Locator;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="", propOrder={"extensions"})
@XmlRootElement(name="Aggregate")
public class Aggregate
extends Expression
implements Locatable,
HasExtensions {
    @XmlElement(name="Extension")
    protected List<Extension> extensions;
    @XmlAttribute(name="field", required=true)
    @XmlJavaTypeAdapter(value=FieldNameAdapter.class)
    protected FieldName field;
    @XmlAttribute(name="function", required=true)
    protected Function function;
    @XmlAttribute(name="groupField")
    @XmlJavaTypeAdapter(value=FieldNameAdapter.class)
    protected FieldName groupField;
    @XmlAttribute(name="sqlWhere")
    protected String sqlWhere;
    @XmlLocation
    @XmlTransient
    protected Locator locator;

    public Aggregate() {
    }

    public Aggregate(FieldName field, Function function) {
        this.field = field;
        this.function = function;
    }

    @Override
    public List<Extension> getExtensions() {
        if (this.extensions == null) {
            this.extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    public FieldName getField() {
        return this.field;
    }

    public void setField(FieldName value) {
        this.field = value;
    }

    public Function getFunction() {
        return this.function;
    }

    public void setFunction(Function value) {
        this.function = value;
    }

    public FieldName getGroupField() {
        return this.groupField;
    }

    public void setGroupField(FieldName value) {
        this.groupField = value;
    }

    public String getSqlWhere() {
        return this.sqlWhere;
    }

    public void setSqlWhere(String value) {
        this.sqlWhere = value;
    }

    public Aggregate withExtensions(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getExtensions().add(value);
            }
        }
        return this;
    }

    public Aggregate withExtensions(Collection<Extension> values) {
        if (values != null) {
            this.getExtensions().addAll(values);
        }
        return this;
    }

    public Aggregate withField(FieldName value) {
        this.setField(value);
        return this;
    }

    public Aggregate withFunction(Function value) {
        this.setFunction(value);
        return this;
    }

    public Aggregate withGroupField(FieldName value) {
        this.setGroupField(value);
        return this;
    }

    public Aggregate withSqlWhere(String value) {
        this.setSqlWhere(value);
        return this;
    }

    @Override
    public Locator sourceLocation() {
        return this.locator;
    }

    @Override
    public void setSourceLocation(Locator newLocator) {
        this.locator = newLocator;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        for (int i = 0; status == VisitorAction.CONTINUE && this.extensions != null && i < this.extensions.size(); ++i) {
            status = this.extensions.get(i).accept(visitor);
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

    @XmlType(name="")
    @XmlEnum
    public static enum Function {
        COUNT("count"),
        SUM("sum"),
        AVERAGE("average"),
        MIN("min"),
        MAX("max"),
        MULTISET("multiset");

        private final String value;

        private Function(String v) {
            this.value = v;
        }

        public String value() {
            return this.value;
        }

        public static Function fromValue(String v) {
            for (Function c : Function.values()) {
                if (!c.value.equals(v)) continue;
                return c;
            }
            throw new IllegalArgumentException(v);
        }
    }
}

