/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.model.kryo;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Objects;
import org.dmg.pmml.PMMLObject;
import org.jpmml.model.Serializer;
import org.jpmml.model.kryo.KryoUtil;

public class KryoSerializer
implements Serializer {
    private Kryo kryo = null;

    public KryoSerializer() {
        this(KryoUtil.createKryo());
    }

    public KryoSerializer(Kryo kryo) {
        this.setKryo(kryo);
    }

    public PMMLObject deserialize(InputStream is) {
        return (PMMLObject)this.deserializeRaw(is);
    }

    public void serialize(PMMLObject object, OutputStream os) {
        this.serializeRaw(object, os);
    }

    public Object deserializeRaw(InputStream is) {
        Kryo kryo = this.getKryo();
        try (Input input = new Input(is);){
            Object object = kryo.readClassAndObject(input);
            return object;
        }
    }

    public void serializeRaw(Object object, OutputStream os) {
        Kryo kryo = this.getKryo();
        try (Output output = new Output(os);){
            kryo.writeClassAndObject(output, object);
        }
    }

    public Kryo getKryo() {
        return this.kryo;
    }

    private void setKryo(Kryo kryo) {
        this.kryo = Objects.requireNonNull(kryo);
    }
}

