/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.model.kryo;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.serializers.JavaSerializer;
import jakarta.xml.bind.JAXBElement;
import org.dmg.pmml.PMMLObject;
import org.jpmml.model.collections.DoubletonList;
import org.jpmml.model.collections.SingletonList;
import org.jpmml.model.collections.TripletonList;
import org.jpmml.model.kryo.serializers.DoubletonListSerializer;
import org.jpmml.model.kryo.serializers.PMMLObjectSerializer;
import org.jpmml.model.kryo.serializers.SingletonListSerializer;
import org.jpmml.model.kryo.serializers.TripletonListSerializer;
import org.w3c.dom.Element;

public class KryoUtil {
    private KryoUtil() {
    }

    public static Kryo createKryo() {
        Kryo kryo = new Kryo();
        KryoUtil.init(kryo);
        KryoUtil.register(kryo);
        return kryo;
    }

    public static void init(Kryo kryo) {
        kryo.setRegistrationRequired(false);
        kryo.setReferences(true);
    }

    public static void register(Kryo kryo) {
        kryo.addDefaultSerializer(PMMLObject.class, PMMLObjectSerializer.class);
        kryo.addDefaultSerializer(Element.class, (Serializer)new JavaSerializer());
        kryo.addDefaultSerializer(JAXBElement.class, (Serializer)new JavaSerializer());
        kryo.register(SingletonList.class, (Serializer)new SingletonListSerializer());
        kryo.register(DoubletonList.class, (Serializer)new DoubletonListSerializer());
        kryo.register(TripletonList.class, (Serializer)new TripletonListSerializer());
    }
}

