/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.model.jackson;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultIndenter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Objects;
import org.dmg.pmml.PMML;
import org.dmg.pmml.PMMLObject;
import org.jpmml.model.TextSerializer;
import org.jpmml.model.jackson.JacksonUtil;

public class JacksonSerializer
implements TextSerializer {
    private ObjectMapper objectMapper = null;
    private Class<? extends PMMLObject> rootType;

    public JacksonSerializer() {
        this((JsonFactory)null);
    }

    public JacksonSerializer(JsonFactory jsonFactory) {
        this(JacksonUtil.createObjectMapper(jsonFactory));
    }

    public JacksonSerializer(ObjectMapper objectMapper) {
        this(objectMapper, PMML.class);
    }

    public JacksonSerializer(ObjectMapper objectMapper, Class<? extends PMMLObject> rootType) {
        this.setObjectMapper(objectMapper);
        this.setRootType(rootType);
    }

    public PMMLObject deserialize(InputStream is) throws IOException {
        ObjectMapper objectMapper = this.getObjectMapper();
        Class<? extends PMMLObject> rootType = this.getRootType();
        ObjectReader objectReader = objectMapper.readerFor(rootType);
        return (PMMLObject)objectReader.readValue(is);
    }

    public void serialize(PMMLObject object, OutputStream os) throws IOException {
        ObjectMapper objectMapper = this.getObjectMapper();
        Class<? extends PMMLObject> rootType = this.getRootType();
        ObjectWriter objectWriter = objectMapper.writerFor(rootType);
        objectWriter.writeValue(os, (Object)object);
    }

    public void serializePretty(PMMLObject object, OutputStream os) throws IOException {
        ObjectMapper objectMapper = this.getObjectMapper();
        Class<? extends PMMLObject> rootType = this.getRootType();
        DefaultIndenter indenter = new DefaultIndenter("\t", "\n");
        DefaultPrettyPrinter prettyPrinter = new DefaultPrettyPrinter();
        prettyPrinter.indentObjectsWith((DefaultPrettyPrinter.Indenter)indenter);
        prettyPrinter.indentArraysWith((DefaultPrettyPrinter.Indenter)indenter);
        ObjectWriter objectWriter = objectMapper.writerFor(rootType).with((PrettyPrinter)prettyPrinter);
        objectWriter.writeValue(os, (Object)object);
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    private void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = Objects.requireNonNull(objectMapper);
    }

    public Class<? extends PMMLObject> getRootType() {
        return this.rootType;
    }

    private void setRootType(Class<? extends PMMLObject> rootType) {
        this.rootType = Objects.requireNonNull(rootType);
    }
}

