/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.model.jackson;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.dmg.pmml.PMML;
import org.dmg.pmml.PMMLObject;
import org.jpmml.model.jackson.PMMLModule;

public class JacksonUtil {
    private JacksonUtil() {
    }

    public static PMML readPMML(InputStream is) throws IOException {
        return JacksonUtil.read(PMML.class, is);
    }

    public static <E extends PMMLObject> E read(Class<? extends E> clazz, InputStream is) throws IOException {
        ObjectMapper objectMapper = JacksonUtil.createObjectMapper(null);
        ObjectReader objectReader = objectMapper.readerFor(clazz);
        return (E)((PMMLObject)objectReader.readValue(is));
    }

    public static void writePMML(PMML pmml, OutputStream os) throws IOException {
        JacksonUtil.write((PMMLObject)pmml, os);
    }

    public static void write(PMMLObject object, OutputStream os) throws IOException {
        ObjectMapper objectMapper = JacksonUtil.createObjectMapper(null);
        ObjectWriter objectWriter = objectMapper.writerWithDefaultPrettyPrinter();
        objectWriter.writeValue(os, (Object)object);
    }

    public static ObjectMapper createObjectMapper(JsonFactory jsonFactory) {
        ObjectMapper objectMapper = new ObjectMapper(jsonFactory).enable(SerializationFeature.WRAP_ROOT_VALUE).enable(DeserializationFeature.UNWRAP_ROOT_VALUE);
        objectMapper.registerModule((Module)new PMMLModule());
        return objectMapper;
    }
}

