/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.agent;

import java.io.IOException;
import java.io.StringReader;
import java.lang.instrument.Instrumentation;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Properties;
import org.jpmml.agent.ExtensionListRemover;
import org.jpmml.agent.InstrumentationProvider;
import org.jpmml.agent.LocatorRemover;
import org.jpmml.agent.NodeTransformer;

public class Main {
    public static void premain(String options, Instrumentation instrumentation) throws IOException {
        String node;
        String extensions;
        String locator;
        Properties properties = new Properties();
        if (options != null) {
            options = options.replace(';', '\n');
            try (StringReader reader = new StringReader(options);){
                properties.load(reader);
            }
        }
        if ((locator = properties.getProperty("locator")) != null && !"true".equalsIgnoreCase(locator)) {
            instrumentation.addTransformer(new LocatorRemover(), true);
        }
        if ((extensions = properties.getProperty("extensions")) != null && !"true".equalsIgnoreCase(extensions)) {
            instrumentation.addTransformer(new ExtensionListRemover(), true);
        }
        if ((node = properties.getProperty("node")) != null) {
            LinkedHashSet<String> commands = new LinkedHashSet<String>(Arrays.asList(node.split(",")));
            instrumentation.addTransformer(new NodeTransformer(commands), true);
        }
        InstrumentationProvider.setInstrumentation(instrumentation);
    }
}

