/*
 * Decompiled with CFR 0.152.
 */
package org.jparsec.examples.java.parser;

import java.util.Collections;
import java.util.List;
import java.util.function.UnaryOperator;
import org.jparsec.Parser;
import org.jparsec.Parsers;
import org.jparsec.Terminals;
import org.jparsec.examples.java.ast.type.ArrayTypeLiteral;
import org.jparsec.examples.java.ast.type.LowerBoundWildcard;
import org.jparsec.examples.java.ast.type.SimpleTypeLiteral;
import org.jparsec.examples.java.ast.type.TypeLiteral;
import org.jparsec.examples.java.ast.type.UpperBoundWildcard;
import org.jparsec.examples.java.parser.TerminalParser;

public final class TypeLiteralParser {
    static final List<TypeLiteral> EMPTY_TYPE_ARGUMENT_LIST = Collections.emptyList();
    static final Parser<UnaryOperator<TypeLiteral>> ARRAY_OF = TerminalParser.phrase("[ ]").retn(ArrayTypeLiteral::new);
    static final Parser<TypeLiteral> ELEMENT_TYPE_LITERAL = TypeLiteralParser.elementTypeLiteral();
    static final Parser<ArrayTypeLiteral> ARRAY_TYPE_LITERAL = ELEMENT_TYPE_LITERAL.followedBy(TerminalParser.phrase("[ ]")).postfix(ARRAY_OF).map(ArrayTypeLiteral::new);
    static final Parser<TypeLiteral> TYPE_LITERAL = ELEMENT_TYPE_LITERAL.postfix(ARRAY_OF);

    static Parser<TypeLiteral> elementTypeLiteral() {
        Parser.Reference ref = Parser.newReference();
        Parser lazy = ref.lazy();
        Parser arg = TypeLiteralParser.wildcard((Parser<TypeLiteral>)lazy).or(lazy);
        Parser nativeTypeName = TerminalParser.oneOf("byte", "short", "int", "long", "boolean", "char", "float", "double", "void").map(Object::toString);
        Parser typeName = nativeTypeName.or(Terminals.Identifier.PARSER);
        Parser parser = Parsers.sequence((Parser)typeName.sepBy1(TerminalParser.term(".")), TypeLiteralParser.optionalTypeArgs((Parser<TypeLiteral>)arg), SimpleTypeLiteral::new);
        ref.set((Object)parser.postfix(ARRAY_OF));
        return parser;
    }

    static Parser<List<TypeLiteral>> optionalTypeArgs(Parser<TypeLiteral> parser) {
        return Parsers.between(TerminalParser.term("<"), (Parser)parser.sepBy1(TerminalParser.term(",")), TerminalParser.term(">")).optional(EMPTY_TYPE_ARGUMENT_LIST);
    }

    static Parser<TypeLiteral> wildcard(Parser<TypeLiteral> type) {
        return Parsers.or((Parser)TerminalParser.phrase("? extends").next(type).map(UpperBoundWildcard::new), (Parser)TerminalParser.phrase("? super").next(type).map(LowerBoundWildcard::new), (Parser)TerminalParser.term("?").retn((Object)new UpperBoundWildcard(null)));
    }
}

