/*
 * Decompiled with CFR 0.152.
 */
package org.jparsec.examples.java.parser;

import java.util.ArrayList;
import java.util.function.UnaryOperator;
import org.jparsec.Parser;
import org.jparsec.Parsers;
import org.jparsec.Terminals;
import org.jparsec.examples.java.ast.expression.Expression;
import org.jparsec.examples.java.ast.statement.Annotation;
import org.jparsec.examples.java.ast.statement.AssertStatement;
import org.jparsec.examples.java.ast.statement.BlockStatement;
import org.jparsec.examples.java.ast.statement.BreakStatement;
import org.jparsec.examples.java.ast.statement.ContinueStatement;
import org.jparsec.examples.java.ast.statement.DoWhileStatement;
import org.jparsec.examples.java.ast.statement.ExpressionListStatement;
import org.jparsec.examples.java.ast.statement.ExpressionStatement;
import org.jparsec.examples.java.ast.statement.ForStatement;
import org.jparsec.examples.java.ast.statement.ForeachStatement;
import org.jparsec.examples.java.ast.statement.IfStatement;
import org.jparsec.examples.java.ast.statement.LabelStatement;
import org.jparsec.examples.java.ast.statement.Modifier;
import org.jparsec.examples.java.ast.statement.NopStatement;
import org.jparsec.examples.java.ast.statement.ParameterDef;
import org.jparsec.examples.java.ast.statement.ReturnStatement;
import org.jparsec.examples.java.ast.statement.Statement;
import org.jparsec.examples.java.ast.statement.SuperCallStatement;
import org.jparsec.examples.java.ast.statement.SwitchStatement;
import org.jparsec.examples.java.ast.statement.SynchronizedBlockStatement;
import org.jparsec.examples.java.ast.statement.SystemModifier;
import org.jparsec.examples.java.ast.statement.ThisCallStatement;
import org.jparsec.examples.java.ast.statement.ThrowStatement;
import org.jparsec.examples.java.ast.statement.TryStatement;
import org.jparsec.examples.java.ast.statement.VarStatement;
import org.jparsec.examples.java.ast.statement.WhileStatement;
import org.jparsec.examples.java.parser.ExpressionParser;
import org.jparsec.examples.java.parser.TerminalParser;
import org.jparsec.examples.java.parser.TypeLiteralParser;

public final class StatementParser {
    static final Parser<Modifier> SYSTEM_MODIFIER = StatementParser.systemModifier(SystemModifier.values());
    static final Parser<Statement> NOP = TerminalParser.term(";").retn((Object)NopStatement.instance);
    static final Parser<UnaryOperator<Statement>> LABEL = Terminals.Identifier.PARSER.followedBy(TerminalParser.term(":")).atomic().map(name -> stmt -> new LabelStatement((String)name, (Statement)stmt));
    static final Parser<Statement> BREAK = Parsers.between(TerminalParser.term("break"), (Parser)Terminals.Identifier.PARSER.optional(), TerminalParser.term(";")).map(BreakStatement::new);
    static final Parser<Statement> CONTINUE = Parsers.between(TerminalParser.term("continue"), (Parser)Terminals.Identifier.PARSER.optional(), TerminalParser.term(";")).map(ContinueStatement::new);

    static Parser<Modifier> systemModifier(SystemModifier ... modifiers) {
        ArrayList<Parser> list = new ArrayList<Parser>(modifiers.length);
        for (SystemModifier modifier : modifiers) {
            list.add(TerminalParser.term(((Object)modifier).toString()).retn((Object)modifier));
        }
        return Parsers.or(list);
    }

    static Parser<Annotation> annotation(Parser<Expression> expr) {
        Parser element = Parsers.sequence((Parser)Terminals.Identifier.PARSER.followedBy(TerminalParser.term("=")).atomic().optional(), ExpressionParser.arrayInitializerOrRegularExpression(expr), Annotation.Element::new);
        return Parsers.sequence((Parser)TerminalParser.term("@").next(TypeLiteralParser.ELEMENT_TYPE_LITERAL), (Parser)ExpressionParser.paren(element.sepBy(TerminalParser.term(","))).optional(), Annotation::new);
    }

    static Parser<Modifier> modifier(Parser<Expression> expr) {
        return Parsers.or(StatementParser.annotation(expr), SYSTEM_MODIFIER);
    }

    static Parser<Statement> returnStatement(Parser<Expression> expr) {
        return Parsers.between(TerminalParser.term("return"), (Parser)expr.optional(), TerminalParser.term(";")).map(ReturnStatement::new);
    }

    static Parser<BlockStatement> blockStatement(Parser<Statement> stmt) {
        return Parsers.between(TerminalParser.term("{"), (Parser)stmt.many(), TerminalParser.term("}")).map(BlockStatement::new);
    }

    static Parser<Statement> whileStatement(Parser<Expression> expr, Parser<Statement> stmt) {
        return Parsers.sequence((Parser)Parsers.between(TerminalParser.phrase("while ("), expr, TerminalParser.term(")")), stmt, WhileStatement::new);
    }

    static Parser<Statement> doWhileStatement(Parser<Statement> stmt, Parser<Expression> expr) {
        return Parsers.sequence((Parser)TerminalParser.term("do").next(stmt), (Parser)Parsers.between(TerminalParser.phrase("while ("), expr, TerminalParser.phrase(") ;")), DoWhileStatement::new);
    }

    static Parser<Statement> ifStatement(Parser<Expression> expr, Parser<Statement> stmt) {
        return Parsers.sequence((Parser)Parsers.between(TerminalParser.phrase("if ("), expr, TerminalParser.term(")")), stmt, (Parser)Parsers.pair((Parser)Parsers.between(TerminalParser.phrase("else if ("), expr, TerminalParser.term(")")), stmt).many(), (Parser)TerminalParser.term("else").next(stmt).optional(), IfStatement::new);
    }

    static Parser<Statement> switchStatement(Parser<Expression> expr, Parser<Statement> stmt) {
        return Parsers.sequence((Parser)Parsers.between(TerminalParser.phrase("switch ("), expr, TerminalParser.phrase(") {")), (Parser)Parsers.pair((Parser)Parsers.between(TerminalParser.term("case"), expr, TerminalParser.term(":")), (Parser)stmt.optional()).many(), (Parser)TerminalParser.phrase("default :").next(stmt.optional()).optional().followedBy(TerminalParser.term("}")), SwitchStatement::new);
    }

    static Parser<Statement> foreachStatement(Parser<Expression> expr, Parser<Statement> stmt) {
        return Parsers.sequence((Parser)TerminalParser.phrase("for (").next(TypeLiteralParser.TYPE_LITERAL), (Parser)Terminals.Identifier.PARSER, (Parser)TerminalParser.term(":").next(expr), (Parser)TerminalParser.term(")").next(stmt), ForeachStatement::new);
    }

    static Parser<Statement> forStatement(Parser<Expression> expr, Parser<Statement> stmt) {
        return Parsers.sequence((Parser)TerminalParser.phrase("for (").next(Parsers.or(StatementParser.varStatement(expr), StatementParser.expressionList(expr), NOP)), (Parser)expr.optional(), (Parser)Parsers.between(TerminalParser.term(";"), (Parser)expr.sepBy(TerminalParser.term(",")), TerminalParser.term(")")), stmt, ForStatement::new);
    }

    static Parser<Statement> thisCall(Parser<Expression> expr) {
        return Parsers.between(TerminalParser.phrase("this ("), (Parser)expr.sepBy(TerminalParser.term(",")), TerminalParser.phrase(") ;")).map(ThisCallStatement::new);
    }

    static Parser<Statement> superCall(Parser<Expression> expr) {
        return Parsers.between(TerminalParser.phrase("super ("), (Parser)expr.sepBy(TerminalParser.term(",")), TerminalParser.phrase(") ;")).map(SuperCallStatement::new);
    }

    static Parser<Statement> varStatement(Parser<Expression> expr) {
        Parser initializer = TerminalParser.term("=").next(ExpressionParser.arrayInitializerOrRegularExpression(expr));
        Parser var = Parsers.sequence((Parser)Terminals.Identifier.PARSER, (Parser)initializer.optional(), VarStatement.Var::new);
        return Parsers.sequence((Parser)StatementParser.modifier(expr).many(), TypeLiteralParser.TYPE_LITERAL, (Parser)var.sepBy1(TerminalParser.term(",")).followedBy(TerminalParser.term(";")), VarStatement::new);
    }

    static Parser<Statement> expressionList(Parser<Expression> expr) {
        return expr.sepBy1(TerminalParser.term(",")).followedBy(TerminalParser.term(";")).map(ExpressionListStatement::new);
    }

    static Parser<Statement> synchronizedBlock(Parser<Statement> stmt) {
        return TerminalParser.term("synchronized").next(StatementParser.blockStatement(stmt)).map(SynchronizedBlockStatement::new);
    }

    static Parser<Statement> assertStatement(Parser<Expression> expr) {
        return Parsers.sequence((Parser)TerminalParser.term("assert").next(expr), (Parser)TerminalParser.term(":").next(expr).optional().followedBy(TerminalParser.term(";")), AssertStatement::new);
    }

    static Parser<Statement> expression(Parser<Expression> expr) {
        return expr.followedBy(TerminalParser.term(";")).map(ExpressionStatement::new);
    }

    static Parser<ParameterDef> parameter(Parser<Modifier> mod) {
        return Parsers.sequence((Parser)mod.many(), TypeLiteralParser.TYPE_LITERAL, (Parser)TerminalParser.term("...").succeeds(), (Parser)Terminals.Identifier.PARSER, ParameterDef::new);
    }

    static Parser<Statement> tryStatement(Parser<Modifier> mod, Parser<Statement> stmt) {
        Parser<BlockStatement> block = StatementParser.blockStatement(stmt);
        return Parsers.sequence((Parser)TerminalParser.term("try").next(block), (Parser)Parsers.sequence((Parser)TerminalParser.term("catch").next(Parsers.between(TerminalParser.term("("), StatementParser.parameter(mod), TerminalParser.term(")"))), block, TryStatement.CatchBlock::new).many(), (Parser)TerminalParser.term("finally").next(block).optional(), TryStatement::new);
    }

    static Parser<Statement> throwStatement(Parser<Expression> thrown) {
        return Parsers.between(TerminalParser.term("throw"), thrown, TerminalParser.term(";")).map(ThrowStatement::new);
    }

    static Parser<Statement> statement(Parser<Expression> expr) {
        Parser.Reference ref = Parser.newReference();
        Parser lazy = ref.lazy();
        Parser parser = Parsers.or((Parser[])new Parser[]{StatementParser.returnStatement(expr), BREAK, CONTINUE, StatementParser.blockStatement((Parser<Statement>)lazy), StatementParser.foreachStatement(expr, (Parser<Statement>)lazy), StatementParser.forStatement(expr, (Parser<Statement>)lazy), StatementParser.whileStatement(expr, (Parser<Statement>)lazy), StatementParser.doWhileStatement((Parser<Statement>)lazy, expr), StatementParser.ifStatement(expr, (Parser<Statement>)lazy), StatementParser.switchStatement(expr, (Parser<Statement>)lazy), StatementParser.tryStatement(StatementParser.modifier(expr), (Parser<Statement>)lazy), StatementParser.throwStatement(expr), StatementParser.synchronizedBlock((Parser<Statement>)lazy), StatementParser.assertStatement(expr), StatementParser.varStatement(expr), StatementParser.thisCall(expr), StatementParser.superCall(expr), StatementParser.expression(expr), NOP}).prefix(LABEL).label("statement");
        ref.set((Object)parser);
        return parser;
    }
}

