/*
 * Decompiled with CFR 0.152.
 */
package org.jparsec.examples.java.parser;

import org.jparsec.Parser;
import org.jparsec.Parsers;
import org.jparsec.Scanners;
import org.jparsec.examples.java.ast.expression.DecimalPointNumberLiteral;
import org.jparsec.examples.java.ast.expression.IntegerLiteral;
import org.jparsec.examples.java.ast.expression.NumberType;
import org.jparsec.examples.java.ast.expression.ScientificNumberLiteral;
import org.jparsec.examples.java.parser.JavaScanners;
import org.jparsec.pattern.Patterns;

public final class JavaLexer {
    static final Parser<String> IDENTIFIER = Patterns.isChar(Character::isJavaIdentifierStart).next(Patterns.isChar(Character::isJavaIdentifierPart).many()).toScanner("identifier").source();
    static final Parser<Void> DECIMAL_POINT_SCANNER = Patterns.INTEGER.optional().next(Patterns.FRACTION).toScanner("decimal point number");
    static final Parser<DecimalPointNumberLiteral> DECIMAL_POINT_NUMBER = Parsers.sequence((Parser)DECIMAL_POINT_SCANNER.source(), JavaLexer.numberType(NumberType.DOUBLE), DecimalPointNumberLiteral::new);
    static final Parser<IntegerLiteral> HEX_INTEGER = Parsers.sequence((Parser)Scanners.HEX_INTEGER.source(), JavaLexer.numberType(NumberType.INT), (text, type) -> new IntegerLiteral(IntegerLiteral.Radix.HEX, text.substring(2), (NumberType)((Object)type)));
    static final Parser<IntegerLiteral> OCT_INTEGER = Parsers.sequence((Parser)JavaScanners.OCT_INTEGER.source(), JavaLexer.numberType(NumberType.INT), (text, type) -> new IntegerLiteral(IntegerLiteral.Radix.OCT, text.length() == 1 ? text : text.substring(1), (NumberType)((Object)type)));
    static final Parser<IntegerLiteral> DEC_INTEGER = Parsers.sequence((Parser)JavaScanners.DEC_INTEGER.source(), JavaLexer.numberType(NumberType.INT), (n, t) -> new IntegerLiteral(IntegerLiteral.Radix.DEC, (String)n, (NumberType)((Object)t)));
    static final Parser<IntegerLiteral> INTEGER = Parsers.or(HEX_INTEGER, OCT_INTEGER, DEC_INTEGER);
    static final Parser<ScientificNumberLiteral> SCIENTIFIC_NUMBER_LITERAL = Parsers.sequence((Parser)Scanners.SCIENTIFIC_NOTATION, JavaLexer.numberType(NumberType.DOUBLE), ScientificNumberLiteral::new);

    static Parser<NumberType> numberType(NumberType defaultType) {
        return Parsers.or((Parser)Scanners.among((String)"lL").retn((Object)NumberType.LONG), (Parser)Scanners.among((String)"fF").retn((Object)NumberType.FLOAT), (Parser)Scanners.among((String)"dD").retn((Object)NumberType.DOUBLE), (Parser)Parsers.constant((Object)((Object)defaultType)));
    }
}

