/*
 * Decompiled with CFR 0.152.
 */
package org.jparsec.examples.java.ast.statement;

import java.util.List;
import org.jparsec.examples.common.Strings;
import org.jparsec.examples.common.ValueObject;
import org.jparsec.examples.java.ast.expression.Expression;
import org.jparsec.examples.java.ast.statement.Modifier;
import org.jparsec.examples.java.ast.type.TypeLiteral;

public final class Annotation
extends ValueObject
implements Modifier {
    public final TypeLiteral type;
    public final List<Element> elements;

    public Annotation(TypeLiteral type, List<Element> elements) {
        this.type = type;
        this.elements = elements;
    }

    @Override
    public String toString() {
        return "@" + this.type + (this.elements == null ? "" : "(" + Strings.join(", ", this.elements) + ")");
    }

    public static final class Element
    extends ValueObject {
        public final String name;
        public final Expression value;

        public Element(String name, Expression value) {
            this.name = name;
            this.value = value;
        }

        @Override
        public String toString() {
            return this.name == null ? this.value.toString() : this.name + "=" + this.value;
        }
    }
}

