/*
 * Decompiled with CFR 0.152.
 */
package org.jparsec.examples.java.ast.declaration;

import java.util.List;
import org.jparsec.examples.common.Strings;
import org.jparsec.examples.common.ValueObject;
import org.jparsec.examples.java.ast.declaration.Declaration;
import org.jparsec.examples.java.ast.declaration.Member;
import org.jparsec.examples.java.ast.expression.Expression;
import org.jparsec.examples.java.ast.statement.Modifier;
import org.jparsec.examples.java.ast.type.TypeLiteral;

public final class EnumDef
extends ValueObject
implements Declaration {
    public final List<Modifier> modifiers;
    public final String name;
    public final List<TypeLiteral> interfaces;
    public final List<Value> values;
    public final List<Member> members;

    public EnumDef(List<Modifier> modifiers, String name, List<TypeLiteral> interfaces, List<Value> values, List<Member> members) {
        this.modifiers = modifiers;
        this.name = name;
        this.interfaces = interfaces;
        this.values = values;
        this.members = members;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (Modifier modifier : this.modifiers) {
            builder.append(modifier).append(' ');
        }
        builder.append("enum ").append(this.name);
        if (this.interfaces != null) {
            builder.append(" implements ");
            Strings.join(builder, ", ", this.interfaces);
        }
        builder.append(" {");
        Strings.join(builder, ", ", this.values);
        if (this.members != null) {
            builder.append("; ");
            Strings.join(builder, " ", this.members);
        }
        builder.append("}");
        return builder.toString();
    }

    public static final class Value {
        public final String name;
        public final List<Expression> arguments;
        public final List<Member> body;

        public Value(String name, List<Expression> arguments, List<Member> body) {
            this.name = name;
            this.arguments = arguments;
            this.body = body;
        }

        public String toString() {
            return this.name + (this.arguments == null ? "" : "(" + Strings.join(", ", this.arguments) + ")") + (this.body == null ? "" : " {" + Strings.join(" ", this.body) + "}");
        }
    }
}

