/*
 * Decompiled with CFR 0.152.
 */
package org.jparsec.examples.java.ast.declaration;

import java.util.List;
import org.jparsec.examples.common.Strings;
import org.jparsec.examples.common.ValueObject;
import org.jparsec.examples.java.ast.declaration.Declaration;
import org.jparsec.examples.java.ast.declaration.DefBody;
import org.jparsec.examples.java.ast.declaration.TypeParameterDef;
import org.jparsec.examples.java.ast.statement.Modifier;
import org.jparsec.examples.java.ast.type.TypeLiteral;

public final class ClassDef
extends ValueObject
implements Declaration {
    public final List<Modifier> modifiers;
    public final String name;
    public final List<TypeParameterDef> typeParameters;
    public final TypeLiteral superclass;
    public final List<TypeLiteral> interfaces;
    public final DefBody body;

    public ClassDef(List<Modifier> modifiers, String name, List<TypeParameterDef> typeParameters, TypeLiteral superclass, List<TypeLiteral> interfaces, DefBody body) {
        this.modifiers = modifiers;
        this.name = name;
        this.typeParameters = typeParameters;
        this.superclass = superclass;
        this.interfaces = interfaces;
        this.body = body;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (Modifier modifier : this.modifiers) {
            builder.append(modifier).append(' ');
        }
        builder.append("class ").append(this.name);
        if (this.typeParameters != null) {
            builder.append('<');
            Strings.join(builder, ", ", this.typeParameters);
            builder.append('>');
        }
        if (this.superclass != null) {
            builder.append(" extends ").append(this.superclass);
        }
        if (this.interfaces != null) {
            builder.append(" implements ");
            Strings.join(builder, ", ", this.interfaces);
        }
        builder.append(' ').append(this.body);
        return builder.toString();
    }
}

