/*
 * Decompiled with CFR 0.152.
 */
package org.jparsec.examples.java.parser;

import java.util.Collections;
import java.util.List;
import java.util.function.BinaryOperator;
import java.util.function.UnaryOperator;
import org.jparsec.OperatorTable;
import org.jparsec.Parser;
import org.jparsec.Parsers;
import org.jparsec.Terminals;
import org.jparsec.examples.java.ast.declaration.DefBody;
import org.jparsec.examples.java.ast.expression.ArrayInitializer;
import org.jparsec.examples.java.ast.expression.ArraySubscriptExpression;
import org.jparsec.examples.java.ast.expression.BinaryExpression;
import org.jparsec.examples.java.ast.expression.BooleanLiteral;
import org.jparsec.examples.java.ast.expression.CastExpression;
import org.jparsec.examples.java.ast.expression.CharLiteral;
import org.jparsec.examples.java.ast.expression.ClassLiteral;
import org.jparsec.examples.java.ast.expression.ConditionalExpression;
import org.jparsec.examples.java.ast.expression.ConstructorReference;
import org.jparsec.examples.java.ast.expression.DecimalPointNumberLiteral;
import org.jparsec.examples.java.ast.expression.Expression;
import org.jparsec.examples.java.ast.expression.Identifier;
import org.jparsec.examples.java.ast.expression.InstanceOfExpression;
import org.jparsec.examples.java.ast.expression.IntegerLiteral;
import org.jparsec.examples.java.ast.expression.LambdaExpression;
import org.jparsec.examples.java.ast.expression.MethodCallExpression;
import org.jparsec.examples.java.ast.expression.MethodReference;
import org.jparsec.examples.java.ast.expression.NewArrayExpression;
import org.jparsec.examples.java.ast.expression.NewExpression;
import org.jparsec.examples.java.ast.expression.NullExpression;
import org.jparsec.examples.java.ast.expression.Operator;
import org.jparsec.examples.java.ast.expression.PostfixUnaryExpression;
import org.jparsec.examples.java.ast.expression.PrefixUnaryExpression;
import org.jparsec.examples.java.ast.expression.QualifiedExpression;
import org.jparsec.examples.java.ast.expression.ScientificNumberLiteral;
import org.jparsec.examples.java.ast.expression.StringLiteral;
import org.jparsec.examples.java.ast.expression.SuperExpression;
import org.jparsec.examples.java.ast.expression.ThisExpression;
import org.jparsec.examples.java.ast.statement.ExpressionStatement;
import org.jparsec.examples.java.ast.statement.Statement;
import org.jparsec.examples.java.ast.type.TypeLiteral;
import org.jparsec.examples.java.parser.StatementParser;
import org.jparsec.examples.java.parser.TerminalParser;
import org.jparsec.examples.java.parser.TypeLiteralParser;

public final class ExpressionParser {
    static final Parser<Expression> NULL = TerminalParser.term("null").retn((Object)NullExpression.instance);
    static final Parser<UnaryOperator<Expression>> INSTANCE_OF = TerminalParser.term("instanceof").next(TypeLiteralParser.TYPE_LITERAL).map(t -> e -> new InstanceOfExpression((Expression)e, (TypeLiteral)t));
    static final Parser<UnaryOperator<Expression>> QUALIFIED_EXPR = TerminalParser.term(".").next(Terminals.Identifier.PARSER).map(n -> e -> new QualifiedExpression((Expression)e, (String)n));
    static final Parser<UnaryOperator<Expression>> METHOD_REFERENCE = Parsers.sequence(TerminalParser.term("::"), TypeLiteralParser.optionalTypeArgs(TypeLiteralParser.TYPE_LITERAL), (Parser)Terminals.Identifier.PARSER, (__, typeParams, name) -> qualifier -> new MethodReference((Expression)qualifier, (List<TypeLiteral>)typeParams, (String)name));
    static final Parser<UnaryOperator<Expression>> CONSTRUCTOR_REFERENCE = TerminalParser.phrase(":: new").retn(ConstructorReference::new);
    static final Parser<Expression> THIS = Terminals.Identifier.PARSER.followedBy(TerminalParser.term(".")).many().followedBy(TerminalParser.term("this")).map(ThisExpression::new);
    static final Parser<Expression> SUPER = TerminalParser.term("super").retn((Object)new SuperExpression());
    static final Parser<Expression> IDENTIFIER = Terminals.Identifier.PARSER.map(Identifier::new);
    static final Parser<Expression> CLASS_LITERAL = TypeLiteralParser.TYPE_LITERAL.followedBy(TerminalParser.phrase(". class")).map(ClassLiteral::new);
    static final Parser<Expression> INTEGER_LITERAL = Parsers.tokenType(IntegerLiteral.class, (String)"integer literal");
    static final Parser<Expression> DECIMAL_LITERAL = Parsers.tokenType(DecimalPointNumberLiteral.class, (String)"decimal number literal");
    static final Parser<Expression> STRING_LITERAL = Terminals.StringLiteral.PARSER.map(StringLiteral::new);
    static final Parser<Expression> CHAR_LITERAL = Terminals.CharLiteral.PARSER.map(CharLiteral::new);
    static final Parser<Expression> BOOLEAN_LITERAL = Parsers.or((Parser)TerminalParser.term("true").retn((Object)new BooleanLiteral(true)), (Parser)TerminalParser.term("false").retn((Object)new BooleanLiteral(false)));
    static final Parser<Expression> SCIENTIFIC_LITERAL = Parsers.tokenType(ScientificNumberLiteral.class, (String)"scientific number literal");
    static final Parser<Expression> ATOM = Parsers.or((Parser[])new Parser[]{NULL, THIS, SUPER, CLASS_LITERAL, BOOLEAN_LITERAL, CHAR_LITERAL, STRING_LITERAL, SCIENTIFIC_LITERAL, INTEGER_LITERAL, DECIMAL_LITERAL, IDENTIFIER});

    static Parser<BinaryOperator<Expression>> conditional(Parser<Expression> consequence) {
        return consequence.between(TerminalParser.term("?"), TerminalParser.term(":")).map(cons -> (cond, alt) -> new ConditionalExpression((Expression)cond, (Expression)cons, (Expression)alt));
    }

    static final Parser<Expression> castOrExpression(Parser<Expression> expr) {
        Parser explicitCast = Parsers.sequence(ExpressionParser.paren(TypeLiteralParser.TYPE_LITERAL), expr, CastExpression::new);
        return explicitCast.or(ExpressionParser.paren(expr));
    }

    static Parser<UnaryOperator<Expression>> subscript(Parser<Expression> expr) {
        return expr.between(TerminalParser.term("["), TerminalParser.term("]")).map(i -> a -> new ArraySubscriptExpression((Expression)a, (Expression)i));
    }

    static Parser<UnaryOperator<Expression>> qualifiedMethodCall(Parser<Expression> arg) {
        return Parsers.sequence((Parser)TerminalParser.term(".").next(TypeLiteralParser.optionalTypeArgs(TypeLiteralParser.TYPE_LITERAL)), (Parser)Terminals.Identifier.PARSER, ExpressionParser.argumentList(arg), (t, m, a) -> q -> new MethodCallExpression((Expression)q, (List<TypeLiteral>)t, (String)m, (List<Expression>)a));
    }

    static Parser<UnaryOperator<Expression>> qualifiedNew(Parser<Expression> arg, Parser<DefBody> body) {
        return Parsers.sequence((Parser)TerminalParser.phrase(". new").next(TypeLiteralParser.ELEMENT_TYPE_LITERAL), ExpressionParser.argumentList(arg), (Parser)body.optional(), (t, a, b) -> q -> new NewExpression((Expression)q, (TypeLiteral)t, (List<Expression>)a, (DefBody)b));
    }

    static Parser<Expression> simpleMethodCall(Parser<Expression> arg) {
        return Parsers.sequence((Parser)Terminals.Identifier.PARSER, ExpressionParser.argumentList(arg), (name, args) -> new MethodCallExpression(null, TypeLiteralParser.EMPTY_TYPE_ARGUMENT_LIST, (String)name, (List<Expression>)args));
    }

    static Parser<Expression> simpleNewExpression(Parser<Expression> arg, Parser<DefBody> body) {
        return Parsers.sequence((Parser)TerminalParser.term("new").next(TypeLiteralParser.ELEMENT_TYPE_LITERAL), ExpressionParser.argumentList(arg), (Parser)body.optional(), (type, args, defBody) -> new NewExpression(null, (TypeLiteral)type, (List<Expression>)args, (DefBody)defBody));
    }

    static Parser<Expression> newArrayWithExplicitLength(Parser<Expression> expr) {
        return Parsers.sequence((Parser)TerminalParser.term("new").next(TypeLiteralParser.TYPE_LITERAL), (Parser)expr.between(TerminalParser.term("["), TerminalParser.term("]")), (Parser)Parsers.between(TerminalParser.term("{"), (Parser)expr.sepBy(TerminalParser.term(",")), TerminalParser.term("}")).optional(), NewArrayExpression::new);
    }

    static Parser<Expression> newArrayWithoutExplicitLength(Parser<Expression> expr) {
        return Parsers.sequence((Parser)TerminalParser.term("new").next(TypeLiteralParser.ARRAY_TYPE_LITERAL), (Parser)Parsers.between(TerminalParser.term("{"), (Parser)expr.sepBy(TerminalParser.term(",")), TerminalParser.term("}")), (type, values) -> new NewArrayExpression(type.elementType, null, (List<Expression>)values));
    }

    static <T> Parser<T> paren(Parser<T> parser) {
        return parser.between(TerminalParser.term("("), TerminalParser.term(")"));
    }

    private static Parser<List<Expression>> argumentList(Parser<Expression> arg) {
        return ExpressionParser.paren(arg.sepBy(TerminalParser.term(",")));
    }

    static Parser<LambdaExpression> lambdaExpression(Parser<Expression> expression, Parser<Statement> stmt) {
        Parser typedParam = Parsers.sequence(TypeLiteralParser.TYPE_LITERAL, (Parser)Terminals.Identifier.PARSER, LambdaExpression.Parameter::new);
        Parser simpleParam = Terminals.Identifier.PARSER.map(LambdaExpression.Parameter::new);
        Parser lambdaParam = typedParam.or(simpleParam);
        Parser params = ExpressionParser.paren(lambdaParam.sepBy(TerminalParser.term(","))).or(lambdaParam.map(Collections::singletonList));
        Parser body = StatementParser.blockStatement(stmt).cast().or(expression.map(ExpressionStatement::new));
        return Parsers.sequence((Parser)params, (Parser)TerminalParser.term("->").next(body), LambdaExpression::new);
    }

    static Parser<Expression> expression(Parser<Expression> atom, Parser<DefBody> classBody, Parser<Statement> statement) {
        Parser.Reference ref = Parser.newReference();
        Parser lazy = ref.lazy();
        atom = Parsers.or(ExpressionParser.castOrExpression((Parser<Expression>)lazy), ExpressionParser.simpleNewExpression((Parser<Expression>)lazy, classBody), ExpressionParser.newArrayWithExplicitLength((Parser<Expression>)lazy), ExpressionParser.newArrayWithoutExplicitLength((Parser<Expression>)lazy), ExpressionParser.simpleMethodCall((Parser<Expression>)lazy), ExpressionParser.lambdaExpression((Parser<Expression>)lazy, statement), atom);
        Parser parser = new OperatorTable().postfix(ExpressionParser.subscript((Parser<Expression>)lazy), 200).postfix(ExpressionParser.qualifiedMethodCall((Parser<Expression>)lazy), 200).postfix(ExpressionParser.qualifiedNew((Parser<Expression>)lazy, classBody), 200).postfix(METHOD_REFERENCE, 200).postfix(CONSTRUCTOR_REFERENCE, 20).postfix(QUALIFIED_EXPR, 200).postfix(ExpressionParser.postfix(Operator.POST_INC), 200).postfix(ExpressionParser.postfix(Operator.POST_DEC), 200).prefix(ExpressionParser.prefix(Operator.INC), 190).prefix(ExpressionParser.prefix(Operator.DEC), 190).prefix(ExpressionParser.prefix(Operator.POSITIVE), 190).prefix(ExpressionParser.prefix(Operator.NEGATIVE), 190).prefix(ExpressionParser.prefix(Operator.INC), 190).prefix(ExpressionParser.prefix(Operator.DEC), 190).prefix(ExpressionParser.prefix(Operator.NOT), 190).prefix(ExpressionParser.prefix(Operator.BITWISE_NOT), 190).infixl(ExpressionParser.binary(Operator.MUL), 100).infixl(ExpressionParser.binary(Operator.DIV), 100).infixl(ExpressionParser.binary(Operator.MOD), 100).infixl(ExpressionParser.binary(Operator.DIV), 100).infixl(ExpressionParser.binary(Operator.PLUS), 90).infixl(ExpressionParser.binary(Operator.MINUS), 90).infixl(ExpressionParser.binary(Operator.LSHIFT), 80).infixl(ExpressionParser.binary(Operator.RSHIFT), 80).infixl(ExpressionParser.binary(Operator.UNSIGNED_RSHIFT), 80).infixl(ExpressionParser.binary(Operator.LE), 70).infixl(ExpressionParser.binary(Operator.GE), 70).infixl(ExpressionParser.binary(Operator.LT), 70).infixl(ExpressionParser.binary(Operator.GT), 70).postfix(INSTANCE_OF, 65).infixl(ExpressionParser.binary(Operator.EQ), 60).infixl(ExpressionParser.binary(Operator.NE), 60).infixl(ExpressionParser.binary(Operator.BITWISE_AND), 50).infixl(ExpressionParser.binary(Operator.BITWISE_XOR), 40).infixl(ExpressionParser.binary(Operator.BITWISE_OR), 30).infixl(ExpressionParser.binary(Operator.AND), 20).infixl(ExpressionParser.binary(Operator.OR), 10).infixr(ExpressionParser.conditional((Parser<Expression>)lazy), 5).infixr(ExpressionParser.binary(Operator.ASSIGNMENT), 0).infixr(ExpressionParser.binary(Operator.APLUS), 0).infixr(ExpressionParser.binary(Operator.AMINUS), 0).infixr(ExpressionParser.binary(Operator.AMUL), 0).infixr(ExpressionParser.binary(Operator.ADIV), 0).infixr(ExpressionParser.binary(Operator.AMOD), 0).infixr(ExpressionParser.binary(Operator.AAND), 0).infixr(ExpressionParser.binary(Operator.AOR), 0).infixr(ExpressionParser.binary(Operator.AXOR), 0).infixr(ExpressionParser.binary(Operator.ALSHIFT), 0).infixr(ExpressionParser.binary(Operator.ARSHIFT), 0).infixr(ExpressionParser.binary(Operator.UNSIGNED_ARSHIFT), 0).build(atom);
        ref.set((Object)parser);
        return parser;
    }

    public static Parser<Expression> expression(Parser<DefBody> classBody, Parser<Statement> statement) {
        return ExpressionParser.expression(ATOM, classBody, statement);
    }

    public static Parser<Expression> arrayInitializer(Parser<Expression> expr) {
        return expr.sepEndBy(TerminalParser.term(",")).between(TerminalParser.term("{"), TerminalParser.term("}")).map(ArrayInitializer::new);
    }

    static Parser<Expression> arrayInitializerOrRegularExpression(Parser<Expression> expr) {
        return ExpressionParser.arrayInitializer(expr).or(expr);
    }

    private static Parser<BinaryOperator<Expression>> binary(Operator op) {
        return TerminalParser.term(op.toString()).retn((l, r) -> new BinaryExpression((Expression)l, op, (Expression)r));
    }

    private static Parser<UnaryOperator<Expression>> prefix(Operator op) {
        return TerminalParser.term(op.toString()).retn(e -> new PrefixUnaryExpression(op, (Expression)e));
    }

    private static Parser<UnaryOperator<Expression>> postfix(Operator op) {
        return TerminalParser.term(op.toString()).retn(e -> new PostfixUnaryExpression((Expression)e, op));
    }
}

