/*
 * Decompiled with CFR 0.152.
 */
package org.jparsec.examples.bnf.parser;

import org.jparsec.Indentation;
import org.jparsec.Parser;
import org.jparsec.Parsers;
import org.jparsec.Scanners;
import org.jparsec.Terminals;

public final class TerminalParser {
    private static final String[] OPERATORS = new String[]{"*", "+", "?", "|", "::=", "(", ")"};
    private static final Terminals TERMS = Terminals.operators((String[])OPERATORS);
    private static final Parser<Void> COMMENT = Scanners.lineComment((String)"#");
    private static final Parser<String> LITERAL = Parsers.or((Parser)Terminals.StringLiteral.DOUBLE_QUOTE_TOKENIZER, (Parser)Terminals.StringLiteral.SINGLE_QUOTE_TOKENIZER);
    private static final Parser<?> IDENT = Terminals.Identifier.TOKENIZER;
    static final Parser<?> TOKENIZER = Parsers.or((Parser)TERMS.tokenizer(), LITERAL, IDENT);
    static final Indentation INDENTATION = new Indentation();

    static Parser<?> term(String name) {
        return TERMS.token(name);
    }

    static <T> T parse(Parser<T> parser, String source) {
        return (T)parser.from(INDENTATION.lexer(TOKENIZER, Indentation.WHITESPACES.or(COMMENT).many())).parse((CharSequence)source);
    }
}

