/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.reactor.extensions;

import java.util.function.Consumer;
import org.jooq.SubscriberProvider;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.CoreSubscriber;
import reactor.util.context.Context;

public class CoreSubscriberProvider
implements SubscriberProvider<Context> {
    public Context context() {
        return Context.empty();
    }

    public Context context(Subscriber<?> subscriber) {
        if (subscriber instanceof CoreSubscriber) {
            CoreSubscriber c = (CoreSubscriber)subscriber;
            return c.currentContext();
        }
        return this.context();
    }

    public <T> Subscriber<T> subscriber(final Consumer<? super Subscription> onSubscribe, final Consumer<? super T> onNext, final Consumer<? super Throwable> onError, final Runnable onComplete, final Context context) {
        return new CoreSubscriber<T>(){

            public Context currentContext() {
                return context != null ? context : CoreSubscriberProvider.this.context();
            }

            public void onNext(T t) {
                onNext.accept(t);
            }

            public void onError(Throwable t) {
                onError.accept(t);
            }

            public void onComplete() {
                onComplete.run();
            }

            public void onSubscribe(Subscription s) {
                onSubscribe.accept(s);
            }
        };
    }
}

