/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.postgres.extensions.types;

import java.util.Objects;
import org.jetbrains.annotations.Nullable;
import org.jooq.postgres.extensions.types.Range;

abstract class AbstractRange<T>
implements Range<T> {
    private final T lower;
    private final T upper;
    private final boolean lowerIncluding;
    private final boolean upperIncluding;

    AbstractRange(T lower, boolean lowerIncluding, T upper, boolean upperIncluding) {
        this.lower = lower;
        this.upper = upper;
        this.lowerIncluding = lower != null && lowerIncluding;
        this.upperIncluding = upper != null && upperIncluding;
    }

    @Override
    public boolean isEmpty() {
        return this.lowerIncluding && !this.upperIncluding && Objects.equals(this.lower, this.upper);
    }

    @Override
    @Nullable
    public final T lower() {
        return this.lower;
    }

    @Override
    public final boolean lowerIncluding() {
        return this.lowerIncluding;
    }

    @Override
    @Nullable
    public final T upper() {
        return this.upper;
    }

    @Override
    public final boolean upperIncluding() {
        return this.upperIncluding;
    }

    public int hashCode() {
        if (this.isEmpty()) {
            return 0;
        }
        return Objects.hash(this.lower, this.lowerIncluding, this.upper, this.upperIncluding);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractRange other = (AbstractRange)obj;
        if (this.isEmpty()) {
            return other.isEmpty();
        }
        return Objects.equals(this.lower, other.lower) && this.lowerIncluding == other.lowerIncluding && Objects.equals(this.upper, other.upper) && this.upperIncluding == other.upperIncluding;
    }

    public String toString() {
        return (this.lowerIncluding ? "[" : "(") + (String)(this.lower == null ? "" : "" + this.lower) + "," + (String)(this.upper == null ? "" : "" + this.upper) + (this.upperIncluding ? "]" : ")");
    }
}

