/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.migrations.jgit;

import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jooq.tools.StringUtils;

public class GitConfiguration {
    private final File repository;
    private final String basedir;
    private final String schemaFilePattern;
    private final String incrementFilePattern;
    private final String scriptFilePattern;
    private final String snapshotFilePattern;
    private final boolean includeUncommitted;

    public GitConfiguration() {
        this(null, null, null, null, null, null, true);
    }

    private GitConfiguration(File repository, String basedir, String schemaFilePattern, String incrementFilePattern, String scriptFilePattern, String snapshotFilePattern, boolean includeUncommitted) {
        this.repository = repository != null ? repository : new File(".");
        this.basedir = basedir != null ? basedir : "src/main/resources";
        this.schemaFilePattern = (String)StringUtils.defaultIfNull((Object)schemaFilePattern, (Object)"migrations/schemas/**");
        this.incrementFilePattern = (String)StringUtils.defaultIfNull((Object)incrementFilePattern, (Object)"migrations/increments/**");
        this.scriptFilePattern = (String)StringUtils.defaultIfNull((Object)scriptFilePattern, (Object)"migrations/scripts/**");
        this.snapshotFilePattern = (String)StringUtils.defaultIfNull((Object)snapshotFilePattern, (Object)"migrations/snapshots/**");
        this.includeUncommitted = includeUncommitted;
    }

    @NotNull
    public final GitConfiguration repository(File newRepository) {
        return new GitConfiguration(newRepository, this.basedir, this.schemaFilePattern, this.incrementFilePattern, this.scriptFilePattern, this.snapshotFilePattern, this.includeUncommitted);
    }

    @NotNull
    public final File repository() {
        return this.repository;
    }

    @NotNull
    public final GitConfiguration basedir(String newBasedir) {
        return new GitConfiguration(this.repository, newBasedir, this.schemaFilePattern, this.incrementFilePattern, this.scriptFilePattern, this.snapshotFilePattern, this.includeUncommitted);
    }

    @NotNull
    public final String basedir() {
        return this.basedir;
    }

    @NotNull
    public final GitConfiguration schemaFilePattern(String newSchemaFilePattern) {
        return new GitConfiguration(this.repository, this.basedir, newSchemaFilePattern, this.incrementFilePattern, this.scriptFilePattern, this.snapshotFilePattern, this.includeUncommitted);
    }

    @NotNull
    public final String schemaFilePattern() {
        return this.schemaFilePattern;
    }

    @NotNull
    public final GitConfiguration incrementFilePattern(String newIncrementFilePattern) {
        return new GitConfiguration(this.repository, this.basedir, this.schemaFilePattern, newIncrementFilePattern, this.scriptFilePattern, this.snapshotFilePattern, this.includeUncommitted);
    }

    @NotNull
    public final String incrementFilePattern() {
        return this.incrementFilePattern;
    }

    @NotNull
    public final GitConfiguration includeUncommitted(boolean newIncludeUncommitted) {
        return new GitConfiguration(this.repository, this.basedir, this.schemaFilePattern, this.incrementFilePattern, this.scriptFilePattern, this.snapshotFilePattern, newIncludeUncommitted);
    }

    @NotNull
    public final boolean includeUncommitted() {
        return this.includeUncommitted;
    }
}

