/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.migrations.jgit;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.Status;
import org.eclipse.jgit.api.errors.NoHeadException;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.diff.DiffFormatter;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevTag;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.util.io.DisabledOutputStream;
import org.jooq.Commit;
import org.jooq.CommitProvider;
import org.jooq.Commits;
import org.jooq.Configuration;
import org.jooq.ContentType;
import org.jooq.DSLContext;
import org.jooq.File;
import org.jooq.FilePattern;
import org.jooq.Migrations;
import org.jooq.migrations.jgit.GitConfiguration;
import org.jooq.migrations.jgit.GitException;
import org.jooq.tools.JooqLogger;

public final class GitCommitProvider
implements CommitProvider {
    private static final JooqLogger log = JooqLogger.getLogger(GitCommitProvider.class);
    private final DSLContext dsl;
    private final Migrations migrations;
    private final GitConfiguration git;
    private final FilePattern incrementFilePattern;
    private final FilePattern schemaFilePattern;
    private static final Comparator<RevCommit> COMMIT_COMPARATOR = (o1, o2) -> o1.getCommitTime() - o2.getCommitTime();

    public GitCommitProvider(Configuration configuration, GitConfiguration git) {
        this.dsl = configuration.dsl();
        this.migrations = this.dsl.migrations();
        this.git = git;
        this.incrementFilePattern = new FilePattern().pattern(git.incrementFilePattern());
        this.schemaFilePattern = new FilePattern().pattern(git.schemaFilePattern());
    }

    public final Commits provide() {
        Commits commits = this.migrations.commits();
        try (Git g = Git.open((java.io.File)this.git.repository());
             Repository r = g.getRepository();
             ObjectReader reader = r.newObjectReader();){
            ArrayList<RevCommit> revCommits = new ArrayList<RevCommit>();
            HashMap<String, List<RevTag>> tags = new HashMap<String, List<RevTag>>();
            RevCommit last = null;
            try {
                for (RevCommit commit : g.log().call()) {
                    if (last == null) {
                        last = commit;
                    }
                    revCommits.add(commit);
                }
            }
            catch (NoHeadException e) {
                log.debug((Object)"No HEAD exists");
            }
            for (Ref ref : g.tagList().call()) {
                RevTag tag = RevTag.parse((byte[])reader.open((AnyObjectId)ref.getObjectId()).getBytes());
                tags.computeIfAbsent(tag.getObject().getName(), id -> new ArrayList()).add(tag);
            }
            Collections.reverse(revCommits);
            Commit init = commits.root();
            while (!revCommits.isEmpty()) {
                Iterator it = revCommits.iterator();
                block22: while (it.hasNext()) {
                    RevCommit revCommit = (RevCommit)it.next();
                    if (revCommit.getParents() == null || revCommit.getParents().length == 0) {
                        commits.add(GitCommitProvider.tag(tags, init.commit(revCommit.getName(), revCommit.getFullMessage(), this.editFiles(r, revCommit))));
                        it.remove();
                        continue;
                    }
                    Commit[] parents = new Commit[revCommit.getParentCount()];
                    ArrayList<RevCommit> l = new ArrayList<RevCommit>(Arrays.asList(revCommit.getParents()));
                    l.sort(COMMIT_COMPARATOR);
                    for (int i = 0; i < parents.length; ++i) {
                        parents[i] = commits.get(revCommit.getParents()[i].getName());
                        if (parents[i] == null) continue block22;
                    }
                    if (parents.length == 1) {
                        commits.add(GitCommitProvider.tag(tags, parents[0].commit(revCommit.getName(), revCommit.getFullMessage(), this.editFiles(r, revCommit))));
                    } else if (parents.length == 2) {
                        commits.add(GitCommitProvider.tag(tags, parents[0].merge(revCommit.getName(), revCommit.getFullMessage(), parents[1], this.editFiles(r, revCommit))));
                    } else {
                        throw new UnsupportedOperationException("Merging more than two parents not yet supported");
                    }
                    it.remove();
                }
            }
            Status status = g.status().call();
            if (status.hasUncommittedChanges() || !status.getUntracked().isEmpty()) {
                commits.add(this.commit(last != null ? commits.get(last.getName()) : init, status));
            }
        }
        catch (Exception e) {
            throw new GitException("Error while providing git versions", e);
        }
        return commits;
    }

    private static final Commit tag(Map<String, List<RevTag>> tags, Commit commit) {
        Commit result = commit;
        List<RevTag> list = tags.get(commit.id());
        if (list != null) {
            for (RevTag tag : list) {
                result = result.tag(tag.getTagName(), tag.getFullMessage());
            }
        }
        return result;
    }

    private final Commit commit(Commit commit, Status status) {
        ArrayList<File> files = new ArrayList<File>();
        this.add(files, status.getAdded());
        this.add(files, status.getChanged());
        this.add(files, status.getModified());
        this.add(files, status.getUntracked());
        this.del(files, status.getMissing());
        this.del(files, status.getRemoved());
        return commit.commit("uncommitted", "uncommitted", files);
    }

    private void add(List<File> files, Set<String> paths) {
        for (String path : paths) {
            ContentType contentType = this.contentType(path);
            if (contentType == null) continue;
            files.add(this.read(path, contentType));
        }
    }

    private final void del(List<File> files, Set<String> paths) {
        for (String path : paths) {
            ContentType contentType = this.contentType(path);
            if (contentType == null) continue;
            files.add(this.migrations.file(path, null, contentType));
        }
    }

    private final File read(String path, ContentType contentType) {
        try {
            return this.migrations.file(path, new String(Files.readAllBytes(new java.io.File(this.git.repository(), path).toPath())), contentType);
        }
        catch (IOException e) {
            throw new GitException("Cannot read file", e);
        }
    }

    private final List<File> editFiles(Repository repository, RevCommit revCommit) throws Exception {
        if (revCommit.getParentCount() == 0) {
            return this.allFiles(repository, revCommit);
        }
        ArrayList<File> files = new ArrayList<File>();
        try (DiffFormatter formatter = new DiffFormatter((OutputStream)DisabledOutputStream.INSTANCE);){
            formatter.setRepository(repository);
            block10: for (DiffEntry entry : formatter.scan((AnyObjectId)revCommit.getParent(0), (AnyObjectId)revCommit)) {
                String oldPath = entry.getOldPath();
                String newPath = entry.getNewPath();
                ContentType oldType = this.contentType(oldPath);
                ContentType newType = this.contentType(newPath);
                DiffEntry.ChangeType changeType = entry.getChangeType();
                if (newType == null && oldType == null) continue;
                if (changeType != DiffEntry.ChangeType.DELETE) {
                    if (newType == null) {
                        changeType = DiffEntry.ChangeType.DELETE;
                    } else if (oldType == null) {
                        changeType = DiffEntry.ChangeType.ADD;
                    } else if (oldType != newType) {
                        changeType = DiffEntry.ChangeType.RENAME;
                    }
                }
                switch (changeType) {
                    case ADD: 
                    case MODIFY: 
                    case COPY: {
                        files.add(this.migrations.file(newPath, this.read(repository, revCommit, newPath), newType));
                        continue block10;
                    }
                    case RENAME: {
                        files.add(this.migrations.file(oldPath, null, oldType));
                        files.add(this.migrations.file(newPath, this.read(repository, revCommit, newPath), newType));
                        continue block10;
                    }
                    case DELETE: {
                        files.add(this.migrations.file(oldPath, null, oldType));
                        continue block10;
                    }
                }
                throw new UnsupportedOperationException(String.valueOf(changeType));
            }
        }
        return files;
    }

    private final ContentType contentType(String path) {
        return this.incrementFilePattern.matches(path) ? ContentType.INCREMENT : (this.schemaFilePattern.matches(path) ? ContentType.SCHEMA : null);
    }

    private final List<File> allFiles(Repository repository, RevCommit revCommit) throws Exception {
        ArrayList<File> files = new ArrayList<File>();
        TreeWalk treeWalk = new TreeWalk(repository);
        treeWalk.addTree((AnyObjectId)revCommit.getTree());
        treeWalk.setRecursive(false);
        while (treeWalk.next()) {
            if (treeWalk.isSubtree()) {
                treeWalk.enterSubtree();
                continue;
            }
            ContentType contentType = this.contentType(treeWalk.getPathString());
            if (contentType == null) continue;
            files.add(this.migrations.file(treeWalk.getPathString(), this.read(repository, revCommit, treeWalk.getPathString()), contentType));
        }
        return files;
    }

    private final String read(Repository repository, RevCommit commit, String path) throws IOException {
        try (TreeWalk treeWalk = TreeWalk.forPath((Repository)repository, (String)path, (RevTree)commit.getTree());){
            String string;
            block12: {
                ObjectId blobId = treeWalk.getObjectId(0);
                ObjectReader objectReader = repository.newObjectReader();
                try {
                    ObjectLoader objectLoader = objectReader.open((AnyObjectId)blobId);
                    byte[] bytes = objectLoader.getBytes();
                    string = new String(bytes, StandardCharsets.UTF_8);
                    if (objectReader == null) break block12;
                }
                catch (Throwable throwable) {
                    if (objectReader != null) {
                        try {
                            objectReader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                objectReader.close();
            }
            return string;
        }
    }
}

