/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.migrations.jgit;

import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jooq.tools.StringUtils;

public class GitConfiguration {
    private final File repository;
    private final String schemaFilePattern;
    private final String incrementFilePattern;
    private final String scriptFilePattern;
    private final String snapshotFilePattern;
    private final boolean includeUncommitted;

    public GitConfiguration() {
        this(null, null, null, null, null, true);
    }

    private GitConfiguration(File repository, String schemaFilePattern, String incrementFilePattern, String scriptFilePattern, String snapshotFilePattern, boolean includeUncommitted) {
        this.repository = repository != null ? repository : new File(".");
        this.schemaFilePattern = (String)StringUtils.defaultIfNull((Object)schemaFilePattern, (Object)"migrations/schema/**");
        this.incrementFilePattern = (String)StringUtils.defaultIfNull((Object)incrementFilePattern, (Object)"migrations/increment/**");
        this.scriptFilePattern = (String)StringUtils.defaultIfNull((Object)scriptFilePattern, (Object)"migrations/script/**");
        this.snapshotFilePattern = (String)StringUtils.defaultIfNull((Object)snapshotFilePattern, (Object)"migrations/snapshot/**");
        this.includeUncommitted = includeUncommitted;
    }

    @NotNull
    public final GitConfiguration repository(File newRepository) {
        return new GitConfiguration(newRepository, this.schemaFilePattern, this.incrementFilePattern, this.scriptFilePattern, this.snapshotFilePattern, this.includeUncommitted);
    }

    @NotNull
    public final File repository() {
        return this.repository;
    }

    @NotNull
    public final GitConfiguration schemaFilePattern(String newSchemaFilePattern) {
        return new GitConfiguration(this.repository, newSchemaFilePattern, this.incrementFilePattern, this.scriptFilePattern, this.snapshotFilePattern, this.includeUncommitted);
    }

    @NotNull
    public final String schemaFilePattern() {
        return this.schemaFilePattern;
    }

    @NotNull
    public final GitConfiguration incrementFilePattern(String newIncrementFilePattern) {
        return new GitConfiguration(this.repository, this.schemaFilePattern, newIncrementFilePattern, this.scriptFilePattern, this.snapshotFilePattern, this.includeUncommitted);
    }

    @NotNull
    public final String incrementFilePattern() {
        return this.incrementFilePattern;
    }

    @NotNull
    public final GitConfiguration includeUncommitted(boolean newIncludeUncommitted) {
        return new GitConfiguration(this.repository, this.schemaFilePattern, this.incrementFilePattern, this.scriptFilePattern, this.snapshotFilePattern, newIncludeUncommitted);
    }

    @NotNull
    public final boolean includeUncommitted() {
        return this.includeUncommitted;
    }
}

