/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.migrations.maven;

import java.io.File;
import org.apache.maven.plugin.MojoExecutionException;
import org.jooq.Commit;
import org.jooq.CommitProvider;
import org.jooq.Commits;
import org.jooq.Configuration;
import org.jooq.Migration;
import org.jooq.Migrations;
import org.jooq.impl.DefaultCommitProvider;
import org.jooq.migrations.maven.AbstractMigrationsMojo;

public abstract class AbstractMigrateMojo
extends AbstractMigrationsMojo {
    @Override
    final void execute0(Configuration configuration) throws Exception {
        if (this.directory == null) {
            throw new MojoExecutionException("Directory was not provided");
        }
        CommitProvider cp = configuration.commitProvider();
        if (cp instanceof DefaultCommitProvider) {
            Migrations migrations = configuration.dsl().migrations();
            Commits commits = migrations.commits();
            commits.load(this.file(this.directory));
            cp = () -> commits;
        }
        Migration migration = configuration.derive(cp).dsl().migrations().migrateTo(cp.provide().latest());
        if (this.getLog().isInfoEnabled()) {
            Commit snapshot = migration.fromSnapshot();
            this.getLog().info((CharSequence)("Migration loaded from version " + String.valueOf(migration.from()) + " to version " + String.valueOf(migration.to()) + (String)(snapshot != null ? " from snapshot: " + snapshot.id() : "") + " (number of queries: " + migration.queries().queries().length + ")"));
        }
        this.execute1(migration);
    }

    abstract void execute1(Migration var1) throws Exception;

    final File file(String file) {
        this.getLog().debug((CharSequence)("Reading migrations directory: " + file));
        File f = new File(file);
        if (!f.isAbsolute()) {
            f = new File(this.project.getBasedir(), file);
        }
        return f;
    }

    static final String fileName(String id, String fileName, String suffix) {
        Object result;
        Object object = result = fileName != null ? fileName : id + "-" + suffix;
        if (!((String)result).endsWith(".sql")) {
            result = (String)result + ".sql";
        }
        return result;
    }
}

