/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.migrations.maven;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.jooq.History;
import org.jooq.Migration;
import org.jooq.Queries;
import org.jooq.migrations.maven.AbstractMigrateMojo;

@Mojo(name="addUntracked", defaultPhase=LifecyclePhase.GENERATE_SOURCES, requiresDependencyResolution=ResolutionScope.TEST, threadSafe=true)
public class AddUntrackedMojo
extends AbstractMigrateMojo {
    @Parameter(property="jooq.migrate.addUntracked.fileName")
    String fileName;

    @Override
    final void execute1(Migration migration) throws Exception {
        Queries untracked = migration.untracked();
        if (untracked.queries().length > 0) {
            History history = migration.dsl().migrations().history();
            String id = history.available() ? history.current().version().id() : migration.from().id();
            File file = new File(this.file(this.directory), id + "/increments/" + AddUntrackedMojo.fileName(id, this.fileName, "added"));
            file.getParentFile().mkdirs();
            StringBuilder sb = new StringBuilder();
            if (this.getLog().isInfoEnabled()) {
                this.getLog().info((CharSequence)("Writing untracked objects to: " + String.valueOf(file) + "\n" + String.valueOf(untracked)));
            }
            sb.append("-- Untracked objects of version: " + id + "\n");
            if ("root".equals(id)) {
                sb.append("-- Objects that were present before the root version will not be created during migration on any databases.\n");
                sb.append("-- They are added to this file only as a baseline.\n");
            }
            sb.append(untracked);
            sb.append("\n");
            Files.write(file.toPath(), Arrays.asList(sb.toString()), StandardOpenOption.CREATE, StandardOpenOption.APPEND);
        }
    }
}

