/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.migrations.maven;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.jooq.CloseableDSLContext;
import org.jooq.Configuration;
import org.jooq.conf.MigrationSchema;
import org.jooq.impl.DSL;
import org.jooq.migrations.maven.Jdbc;
import org.jooq.tools.StringUtils;

abstract class AbstractMigrationsMojo
extends AbstractMojo {
    @Parameter(property="project", required=true, readonly=true)
    MavenProject project;
    @Parameter(property="jooq.migrate.skip")
    boolean skip;
    @Parameter(property="jooq.migrate.jdbc")
    Jdbc jdbc;
    @Parameter(property="jooq.migrate.directory")
    String directory;
    @Parameter(property="jooq.migrate.setupScript")
    String setupScript;
    @Parameter(property="jooq.migrate.cleanupScript")
    String cleanupScript;
    @Parameter(property="jooq.migrate.schemata")
    List<MigrationSchema> schemata;
    @Parameter(property="jooq.migrate.schemataCreateSchemaIfNotExists")
    boolean schemataCreateSchemaIfNotExists;
    @Parameter(property="jooq.migrate.defaultCatalog")
    String defaultCatalog;
    @Parameter(property="jooq.migrate.defaultSchema")
    String defaultSchema;
    @Parameter(property="jooq.migrate.historyCatalog")
    String historyCatalog;
    @Parameter(property="jooq.migrate.historySchema")
    String historySchema;
    @Parameter(property="jooq.migrate.historySchemaCreateSchemaIfNotExists")
    boolean historySchemaCreateSchemaIfNotExists;

    AbstractMigrationsMojo() {
    }

    public final void execute() throws MojoExecutionException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping jOOQ migrations");
            return;
        }
        this.getLog().warn((CharSequence)"----------------------------------------------------------------------------------------------------------");
        this.getLog().warn((CharSequence)"WARNING: jOOQ-migrations is an experimental set of features, and not yet documented. USE AT YOUR OWN RISK.");
        this.getLog().warn((CharSequence)"----------------------------------------------------------------------------------------------------------");
        ClassLoader oldCL = Thread.currentThread().getContextClassLoader();
        URLClassLoader pluginClassLoader = this.getClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(pluginClassLoader);
            if (this.jdbc == null || this.jdbc.url == null) {
                throw new MojoExecutionException("JDBC URL is required");
            }
            if (this.jdbc.driver != null) {
                Class.forName(this.jdbc.driver);
            }
            try (CloseableDSLContext ctx = DSL.using((String)this.jdbc.url, (String)((String)StringUtils.defaultIfNull((Object)this.jdbc.user, (Object)this.jdbc.username)), (String)this.jdbc.password);){
                ctx.settings().getMigrationSchemata().addAll(this.schemata);
                if (this.defaultCatalog != null || this.defaultSchema != null) {
                    ctx.settings().setMigrationDefaultSchema(new MigrationSchema().withCatalog((String)StringUtils.defaultIfNull((Object)this.defaultCatalog, (Object)"")).withSchema((String)StringUtils.defaultIfNull((Object)this.defaultSchema, (Object)"")));
                }
                if (this.historyCatalog != null || this.historySchema != null) {
                    ctx.settings().setMigrationHistorySchema(new MigrationSchema().withCatalog((String)StringUtils.defaultIfNull((Object)this.historyCatalog, (Object)"")).withSchema((String)StringUtils.defaultIfNull((Object)this.historySchema, (Object)"")));
                }
                ctx.settings().setMigrationSchemataCreateSchemaIfNotExists(Boolean.valueOf(this.schemataCreateSchemaIfNotExists));
                ctx.settings().setMigrationHistorySchemaCreateSchemaIfNotExists(Boolean.valueOf(this.historySchemaCreateSchemaIfNotExists));
                if (!StringUtils.isBlank((String)this.defaultCatalog)) {
                    ctx.setCatalog(this.defaultCatalog).execute();
                }
                if (!StringUtils.isBlank((String)this.defaultSchema)) {
                    ctx.setSchema(this.defaultSchema).execute();
                }
                if (this.setupScript != null) {
                    ctx.execute(this.setupScript);
                }
                this.execute0(ctx.configuration());
                if (this.cleanupScript != null) {
                    ctx.execute(this.cleanupScript);
                }
            }
        }
        catch (Exception ex) {
            throw new MojoExecutionException("Error running jOOQ code generation tool", ex);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldCL);
            try {
                pluginClassLoader.close();
            }
            catch (Throwable e) {
                this.getLog().error((CharSequence)"Couldn't close the classloader.", e);
            }
        }
    }

    abstract void execute0(Configuration var1) throws Exception;

    private URLClassLoader getClassLoader() throws MojoExecutionException {
        try {
            List classpathElements = this.project.getRuntimeClasspathElements();
            URL[] urls = new URL[classpathElements.size()];
            for (int i = 0; i < urls.length; ++i) {
                urls[i] = new File((String)classpathElements.get(i)).toURI().toURL();
            }
            return new URLClassLoader(urls, ((Object)((Object)this)).getClass().getClassLoader());
        }
        catch (Exception e) {
            throw new MojoExecutionException("Couldn't create a classloader.", e);
        }
    }
}

