/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.util.sybase;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.SQLDialect;
import org.jooq.SortField;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.jooq.tools.JooqLogger;
import org.jooq.util.AbstractDatabase;
import org.jooq.util.ArrayDefinition;
import org.jooq.util.ColumnDefinition;
import org.jooq.util.Database;
import org.jooq.util.DefaultDataTypeDefinition;
import org.jooq.util.DefaultRelations;
import org.jooq.util.DefaultSequenceDefinition;
import org.jooq.util.EnumDefinition;
import org.jooq.util.PackageDefinition;
import org.jooq.util.RoutineDefinition;
import org.jooq.util.SchemaDefinition;
import org.jooq.util.SequenceDefinition;
import org.jooq.util.TableDefinition;
import org.jooq.util.UDTDefinition;
import org.jooq.util.sybase.SybaseDataType;
import org.jooq.util.sybase.SybaseRoutineDefinition;
import org.jooq.util.sybase.SybaseTableDefinition;
import org.jooq.util.sybase.sys.Tables;
import org.jooq.util.sybase.sys.tables.Sysidx;
import org.jooq.util.sybase.sys.tables.Systable;

public class SybaseDatabase
extends AbstractDatabase {
    private static final JooqLogger log = JooqLogger.getLogger(SybaseDatabase.class);

    @Override
    protected DSLContext create0() {
        return DSL.using((Connection)this.getConnection(), (SQLDialect)SQLDialect.SYBASE);
    }

    private SchemaDefinition getSchema() {
        List<SchemaDefinition> schemata = this.getSchemata();
        if (schemata.size() > 1) {
            log.error((Object)"NOT SUPPORTED", (Object)"jOOQ does not support multiple schemata in Sybase ASE.");
            log.error((Object)"-----------------------------------------------------------------------");
        }
        return schemata.get(0);
    }

    @Override
    protected void loadPrimaryKeys(DefaultRelations relations2) throws SQLException {
        for (Record record : this.create().select(DSL.concat((Field[])new Field[]{Tables.SYSTABLE.TABLE_NAME, DSL.val((Object)"__"), Tables.SYSIDX.INDEX_NAME}).as("indexName"), Tables.SYSTABLE.TABLE_NAME, Tables.SYSTABCOL.COLUMN_NAME).from(new TableLike[]{Tables.SYSIDX}).join((TableLike)Tables.SYSIDXCOL).on(new Condition[]{Tables.SYSIDX.TABLE_ID.equal(Tables.SYSIDXCOL.TABLE_ID)}).and(Tables.SYSIDX.INDEX_ID.equal(Tables.SYSIDXCOL.INDEX_ID)).join((TableLike)Tables.SYSTABLE).on(new Condition[]{Tables.SYSIDXCOL.TABLE_ID.equal(Tables.SYSTABLE.TABLE_ID)}).join((TableLike)Tables.SYSTABCOL).on(new Condition[]{Tables.SYSIDXCOL.TABLE_ID.equal(Tables.SYSTABCOL.TABLE_ID)}).and(Tables.SYSIDXCOL.COLUMN_ID.equal(Tables.SYSTABCOL.COLUMN_ID)).where(new Condition[]{Tables.SYSIDX.INDEX_CATEGORY.equal((Object)1)}).orderBy(new Field[]{Tables.SYSIDXCOL.SEQUENCE}).fetch()) {
            String key = (String)record.getValue("indexName", String.class);
            String tableName = (String)record.getValue(Tables.SYSTABLE.TABLE_NAME);
            String columnName = (String)record.getValue(Tables.SYSTABCOL.COLUMN_NAME);
            TableDefinition table = this.getTable(this.getSchema(), tableName);
            if (table == null) continue;
            relations2.addPrimaryKey(key, table.getColumn(columnName));
        }
    }

    @Override
    protected void loadUniqueKeys(DefaultRelations r) throws SQLException {
        for (Record record : this.create().select(DSL.concat((Field[])new Field[]{Tables.SYSTABLE.TABLE_NAME, DSL.val((Object)"__"), Tables.SYSIDX.INDEX_NAME}).as("indexName"), Tables.SYSTABLE.TABLE_NAME, Tables.SYSTABCOL.COLUMN_NAME).from(new TableLike[]{Tables.SYSIDX}).join((TableLike)Tables.SYSIDXCOL).on(new Condition[]{Tables.SYSIDX.TABLE_ID.equal(Tables.SYSIDXCOL.TABLE_ID)}).and(Tables.SYSIDX.INDEX_ID.equal(Tables.SYSIDXCOL.INDEX_ID)).join((TableLike)Tables.SYSTABLE).on(new Condition[]{Tables.SYSIDXCOL.TABLE_ID.equal(Tables.SYSTABLE.TABLE_ID)}).join((TableLike)Tables.SYSTABCOL).on(new Condition[]{Tables.SYSIDXCOL.TABLE_ID.equal(Tables.SYSTABCOL.TABLE_ID)}).and(Tables.SYSIDXCOL.COLUMN_ID.equal(Tables.SYSTABCOL.COLUMN_ID)).where(new Condition[]{Tables.SYSIDX.INDEX_CATEGORY.equal((Object)3)}).and(Tables.SYSIDX.UNIQUE.equal((Object)2)).orderBy(new Field[]{Tables.SYSIDXCOL.SEQUENCE}).fetch()) {
            String key = (String)record.getValue("indexName", String.class);
            String tableName = (String)record.getValue(Tables.SYSTABLE.TABLE_NAME);
            String columnName = (String)record.getValue(Tables.SYSTABCOL.COLUMN_NAME);
            TableDefinition table = this.getTable(this.getSchema(), tableName);
            if (table == null) continue;
            r.addUniqueKey(key, table.getColumn(columnName));
        }
    }

    @Override
    protected void loadForeignKeys(DefaultRelations relations2) throws SQLException {
        Sysidx fkIndex = Tables.SYSIDX.as("fkIndex");
        Sysidx ukIndex = Tables.SYSIDX.as("ukIndex");
        Systable fkTable = Tables.SYSTABLE.as("fkTable");
        Systable ukTable = Tables.SYSTABLE.as("ukTable");
        for (Record record : this.create().select(DSL.concat((Field[])new Field[]{fkTable.TABLE_NAME, DSL.val((Object)"__"), fkIndex.INDEX_NAME}).as("fkIndexName"), fkTable.TABLE_NAME, Tables.SYSTABCOL.COLUMN_NAME, DSL.concat((Field[])new Field[]{ukTable.TABLE_NAME, DSL.val((Object)"__"), ukIndex.INDEX_NAME}).as("ukIndexName")).from(new TableLike[]{Tables.SYSFKEY}).join((TableLike)fkIndex).on(new Condition[]{Tables.SYSFKEY.FOREIGN_INDEX_ID.equal(fkIndex.INDEX_ID)}).and(Tables.SYSFKEY.FOREIGN_TABLE_ID.equal(fkIndex.TABLE_ID)).join((TableLike)Tables.SYSIDXCOL).on(new Condition[]{fkIndex.INDEX_ID.equal(Tables.SYSIDXCOL.INDEX_ID)}).and(fkIndex.TABLE_ID.equal(Tables.SYSIDXCOL.TABLE_ID)).join((TableLike)fkTable).on(new Condition[]{Tables.SYSFKEY.FOREIGN_TABLE_ID.equal(fkTable.TABLE_ID)}).join((TableLike)Tables.SYSTABCOL).on(new Condition[]{Tables.SYSIDXCOL.TABLE_ID.equal(Tables.SYSTABCOL.TABLE_ID)}).and(Tables.SYSIDXCOL.COLUMN_ID.equal(Tables.SYSTABCOL.COLUMN_ID)).join((TableLike)ukIndex).on(new Condition[]{Tables.SYSFKEY.PRIMARY_INDEX_ID.equal(ukIndex.INDEX_ID)}).and(Tables.SYSFKEY.PRIMARY_TABLE_ID.equal(ukIndex.TABLE_ID)).join((TableLike)ukTable).on(new Condition[]{Tables.SYSFKEY.PRIMARY_TABLE_ID.equal(ukTable.TABLE_ID)}).orderBy(new SortField[]{fkTable.TABLE_NAME.asc(), fkIndex.INDEX_NAME.asc(), Tables.SYSIDXCOL.SEQUENCE.asc()}).fetch()) {
            String foreignKey = (String)record.getValue("fkIndexName", String.class);
            String foreignKeyTableName = (String)record.getValue(Tables.SYSTABLE.TABLE_NAME);
            String foreignKeyColumn = (String)record.getValue(Tables.SYSTABCOL.COLUMN_NAME);
            String referencedKey = (String)record.getValue("ukIndexName", String.class);
            TableDefinition foreignKeyTable = this.getTable(this.getSchema(), foreignKeyTableName);
            if (foreignKeyTable == null) continue;
            ColumnDefinition referencingColumn = foreignKeyTable.getColumn(foreignKeyColumn);
            relations2.addForeignKey(foreignKey, referencedKey, referencingColumn, this.getSchema());
        }
    }

    @Override
    protected void loadCheckConstraints(DefaultRelations r) throws SQLException {
    }

    @Override
    protected List<SchemaDefinition> getSchemata0() throws SQLException {
        ArrayList<SchemaDefinition> result = new ArrayList<SchemaDefinition>();
        for (String name : this.create().select(Tables.SYSUSER.USER_NAME).from(new TableLike[]{Tables.SYSUSER}).fetch(Tables.SYSUSER.USER_NAME)) {
            result.add(new SchemaDefinition((Database)this, name, ""));
        }
        return result;
    }

    @Override
    protected List<SequenceDefinition> getSequences0() throws SQLException {
        ArrayList<SequenceDefinition> result = new ArrayList<SequenceDefinition>();
        for (String name : this.create().select(Tables.SYSSEQUENCE.SEQUENCE_NAME).from(new TableLike[]{Tables.SYSSEQUENCE}).orderBy(new Field[]{Tables.SYSSEQUENCE.SEQUENCE_NAME}).fetch(Tables.SYSSEQUENCE.SEQUENCE_NAME)) {
            DefaultDataTypeDefinition type = new DefaultDataTypeDefinition(this, this.getSchema(), SybaseDataType.NUMERIC.getTypeName(), 0, 38, 0, false, false);
            result.add(new DefaultSequenceDefinition(this.getSchema(), name, type));
        }
        return result;
    }

    @Override
    protected List<TableDefinition> getTables0() throws SQLException {
        ArrayList<TableDefinition> result = new ArrayList<TableDefinition>();
        for (Record record : this.create().select(Tables.SYSTABLE.TABLE_NAME, Tables.SYSTABLE.REMARKS).from(new TableLike[]{Tables.SYSTABLE}).fetch()) {
            String name = (String)record.getValue(Tables.SYSTABLE.TABLE_NAME);
            String comment = (String)record.getValue(Tables.SYSTABLE.REMARKS);
            SybaseTableDefinition table = new SybaseTableDefinition(this.getSchema(), name, comment);
            result.add(table);
        }
        return result;
    }

    @Override
    protected List<EnumDefinition> getEnums0() throws SQLException {
        ArrayList<EnumDefinition> result = new ArrayList<EnumDefinition>();
        return result;
    }

    @Override
    protected List<UDTDefinition> getUDTs0() throws SQLException {
        ArrayList<UDTDefinition> result = new ArrayList<UDTDefinition>();
        return result;
    }

    @Override
    protected List<ArrayDefinition> getArrays0() throws SQLException {
        ArrayList<ArrayDefinition> result = new ArrayList<ArrayDefinition>();
        return result;
    }

    @Override
    protected List<RoutineDefinition> getRoutines0() throws SQLException {
        ArrayList<RoutineDefinition> result = new ArrayList<RoutineDefinition>();
        for (Record record : this.create().select(Tables.SYSPROCEDURE.PROC_NAME).from(new TableLike[]{Tables.SYSPROCEDURE}).orderBy(new Field[]{Tables.SYSPROCEDURE.PROC_NAME}).fetch()) {
            String name = (String)record.getValue(Tables.SYSPROCEDURE.PROC_NAME);
            result.add(new SybaseRoutineDefinition(this.getSchema(), null, name));
        }
        return result;
    }

    @Override
    protected List<PackageDefinition> getPackages0() throws SQLException {
        ArrayList<PackageDefinition> result = new ArrayList<PackageDefinition>();
        return result;
    }
}

