/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.util.oracle;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.Record4;
import org.jooq.Result;
import org.jooq.SQLDialect;
import org.jooq.Select;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.jooq.util.AbstractDatabase;
import org.jooq.util.ArrayDefinition;
import org.jooq.util.ColumnDefinition;
import org.jooq.util.DataTypeDefinition;
import org.jooq.util.Database;
import org.jooq.util.DefaultArrayDefinition;
import org.jooq.util.DefaultCheckConstraintDefinition;
import org.jooq.util.DefaultDataTypeDefinition;
import org.jooq.util.DefaultRelations;
import org.jooq.util.DefaultSequenceDefinition;
import org.jooq.util.EnumDefinition;
import org.jooq.util.PackageDefinition;
import org.jooq.util.RoutineDefinition;
import org.jooq.util.SchemaDefinition;
import org.jooq.util.SequenceDefinition;
import org.jooq.util.TableDefinition;
import org.jooq.util.UDTDefinition;
import org.jooq.util.oracle.OraclePackageDefinition;
import org.jooq.util.oracle.OracleRoutineDefinition;
import org.jooq.util.oracle.OracleTableDefinition;
import org.jooq.util.oracle.OracleUDTDefinition;
import org.jooq.util.oracle.sys.Tables;
import org.jooq.util.oracle.sys.tables.AllConstraints;

public class OracleDatabase
extends AbstractDatabase {
    @Override
    protected void loadPrimaryKeys(DefaultRelations relations2) throws SQLException {
        for (Record record : this.fetchKeys("P")) {
            SchemaDefinition schema = this.getSchema((String)record.getValue(Tables.ALL_CONS_COLUMNS.OWNER));
            String key = (String)record.getValue(Tables.ALL_CONS_COLUMNS.CONSTRAINT_NAME);
            String tableName = (String)record.getValue(Tables.ALL_CONS_COLUMNS.TABLE_NAME);
            String columnName = (String)record.getValue(Tables.ALL_CONS_COLUMNS.COLUMN_NAME);
            TableDefinition table = this.getTable(schema, tableName);
            if (table == null) continue;
            relations2.addPrimaryKey(key, table.getColumn(columnName));
        }
    }

    @Override
    protected void loadUniqueKeys(DefaultRelations relations2) throws SQLException {
        for (Record record : this.fetchKeys("U")) {
            SchemaDefinition schema = this.getSchema((String)record.getValue(Tables.ALL_CONS_COLUMNS.OWNER));
            String key = (String)record.getValue(Tables.ALL_CONS_COLUMNS.CONSTRAINT_NAME);
            String tableName = (String)record.getValue(Tables.ALL_CONS_COLUMNS.TABLE_NAME);
            String columnName = (String)record.getValue(Tables.ALL_CONS_COLUMNS.COLUMN_NAME);
            TableDefinition table = this.getTable(schema, tableName);
            if (table == null) continue;
            relations2.addUniqueKey(key, table.getColumn(columnName));
        }
    }

    private Result<Record4<String, String, String, String>> fetchKeys(String constraintType) {
        return this.create().select(Tables.ALL_CONS_COLUMNS.OWNER, Tables.ALL_CONS_COLUMNS.CONSTRAINT_NAME, Tables.ALL_CONS_COLUMNS.TABLE_NAME, Tables.ALL_CONS_COLUMNS.COLUMN_NAME).from(new TableLike[]{Tables.ALL_CONS_COLUMNS.join((TableLike)Tables.ALL_CONSTRAINTS).on(new Condition[]{Tables.ALL_CONS_COLUMNS.OWNER.equal(Tables.ALL_CONSTRAINTS.OWNER)}).and(Tables.ALL_CONS_COLUMNS.CONSTRAINT_NAME.equal(Tables.ALL_CONSTRAINTS.CONSTRAINT_NAME))}).where(new Condition[]{Tables.ALL_CONSTRAINTS.CONSTRAINT_TYPE.equal((Object)constraintType).and(Tables.ALL_CONSTRAINTS.CONSTRAINT_NAME.notLike("BIN$%")).and(Tables.ALL_CONS_COLUMNS.OWNER.upper().in(this.getInputSchemata()))}).orderBy(new Field[]{Tables.ALL_CONS_COLUMNS.OWNER, Tables.ALL_CONS_COLUMNS.CONSTRAINT_NAME, Tables.ALL_CONS_COLUMNS.POSITION}).fetch();
    }

    @Override
    protected void loadForeignKeys(DefaultRelations relations2) throws SQLException {
        for (Record record : this.create().select(Tables.ALL_CONS_COLUMNS.OWNER, Tables.ALL_CONS_COLUMNS.CONSTRAINT_NAME, Tables.ALL_CONS_COLUMNS.TABLE_NAME, Tables.ALL_CONS_COLUMNS.COLUMN_NAME, Tables.ALL_CONSTRAINTS.R_CONSTRAINT_NAME, Tables.ALL_CONSTRAINTS.R_OWNER).from(new TableLike[]{Tables.ALL_CONSTRAINTS.join((TableLike)Tables.ALL_CONS_COLUMNS).on(new Condition[]{Tables.ALL_CONSTRAINTS.OWNER.equal(Tables.ALL_CONS_COLUMNS.OWNER)}).and(Tables.ALL_CONSTRAINTS.TABLE_NAME.equal(Tables.ALL_CONS_COLUMNS.TABLE_NAME)).and(Tables.ALL_CONSTRAINTS.CONSTRAINT_NAME.equal(Tables.ALL_CONS_COLUMNS.CONSTRAINT_NAME))}).where(new Condition[]{Tables.ALL_CONSTRAINTS.CONSTRAINT_TYPE.equal((Object)"R")}).and(Tables.ALL_CONSTRAINTS.OWNER.upper().in(this.getInputSchemata())).orderBy(new Field[]{Tables.ALL_CONS_COLUMNS.OWNER, Tables.ALL_CONS_COLUMNS.TABLE_NAME, Tables.ALL_CONS_COLUMNS.CONSTRAINT_NAME, Tables.ALL_CONS_COLUMNS.POSITION}).fetch()) {
            SchemaDefinition foreignKeySchema = this.getSchema((String)record.getValue(Tables.ALL_CONS_COLUMNS.OWNER));
            SchemaDefinition uniqueKeySchema = this.getSchema((String)record.getValue(Tables.ALL_CONSTRAINTS.R_OWNER));
            String foreignKeyName = (String)record.getValue(Tables.ALL_CONS_COLUMNS.CONSTRAINT_NAME);
            String foreignKeyTableName = (String)record.getValue(Tables.ALL_CONS_COLUMNS.TABLE_NAME);
            String foreignKeyColumnName = (String)record.getValue(Tables.ALL_CONS_COLUMNS.COLUMN_NAME);
            String uniqueKeyName = (String)record.getValue(Tables.ALL_CONSTRAINTS.R_CONSTRAINT_NAME);
            TableDefinition referencingTable = this.getTable(foreignKeySchema, foreignKeyTableName);
            if (referencingTable == null) continue;
            ColumnDefinition column = referencingTable.getColumn(foreignKeyColumnName);
            relations2.addForeignKey(foreignKeyName, uniqueKeyName, column, uniqueKeySchema);
        }
    }

    @Override
    protected void loadCheckConstraints(DefaultRelations relations2) throws SQLException {
        AllConstraints ac = Tables.ALL_CONSTRAINTS.as("ac");
        for (Record record : this.create().select(ac.OWNER, ac.TABLE_NAME, ac.CONSTRAINT_NAME, ac.SEARCH_CONDITION).from(new TableLike[]{ac}).where(new Condition[]{ac.CONSTRAINT_TYPE.eq((Object)"C")}).and(ac.OWNER.upper().in(this.getInputSchemata())).fetch()) {
            SchemaDefinition schema = this.getSchema((String)record.getValue(ac.OWNER));
            TableDefinition table = this.getTable(schema, (String)record.getValue(ac.TABLE_NAME));
            if (table == null) continue;
            relations2.addCheckConstraint(table, new DefaultCheckConstraintDefinition(schema, table, (String)record.getValue(ac.CONSTRAINT_NAME), (String)record.getValue(ac.SEARCH_CONDITION)));
        }
    }

    @Override
    protected List<SchemaDefinition> getSchemata0() throws SQLException {
        ArrayList<SchemaDefinition> result = new ArrayList<SchemaDefinition>();
        for (String name : this.create().selectDistinct(Tables.ALL_USERS.USERNAME).from(new TableLike[]{Tables.ALL_USERS}).fetch(Tables.ALL_USERS.USERNAME)) {
            result.add(new SchemaDefinition((Database)this, name, ""));
        }
        return result;
    }

    @Override
    protected List<SequenceDefinition> getSequences0() throws SQLException {
        ArrayList<SequenceDefinition> result = new ArrayList<SequenceDefinition>();
        for (Record record : this.create().select(Tables.ALL_SEQUENCES.SEQUENCE_OWNER, Tables.ALL_SEQUENCES.SEQUENCE_NAME, Tables.ALL_SEQUENCES.MAX_VALUE).from(new TableLike[]{Tables.ALL_SEQUENCES}).where(new Condition[]{Tables.ALL_SEQUENCES.SEQUENCE_OWNER.upper().in(this.getInputSchemata())}).orderBy(new Field[]{Tables.ALL_SEQUENCES.SEQUENCE_OWNER, Tables.ALL_SEQUENCES.SEQUENCE_NAME}).fetch()) {
            SchemaDefinition schema = this.getSchema((String)record.getValue(Tables.ALL_SEQUENCES.SEQUENCE_OWNER));
            BigInteger value = (BigInteger)record.getValue(Tables.ALL_SEQUENCES.MAX_VALUE, BigInteger.class, (Object)BigInteger.valueOf(Long.MAX_VALUE));
            DataTypeDefinition type = this.getDataTypeForMAX_VAL(schema, value);
            result.add(new DefaultSequenceDefinition(schema, (String)record.getValue(Tables.ALL_SEQUENCES.SEQUENCE_NAME), type));
        }
        return result;
    }

    @Override
    protected List<TableDefinition> getTables0() throws SQLException {
        ArrayList<TableDefinition> result = new ArrayList<TableDefinition>();
        for (Record record : this.create().select(new Field[0]).from(new TableLike[]{this.create().select(Tables.ALL_TAB_COMMENTS.OWNER, Tables.ALL_TAB_COMMENTS.TABLE_NAME, Tables.ALL_TAB_COMMENTS.COMMENTS).from(new TableLike[]{Tables.ALL_TAB_COMMENTS}).where(new Condition[]{Tables.ALL_TAB_COMMENTS.OWNER.upper().in(this.getInputSchemata())}).and(Tables.ALL_TAB_COMMENTS.TABLE_NAME.notLike("%$%")).unionAll((Select)this.create().select(Tables.ALL_MVIEW_COMMENTS.OWNER, Tables.ALL_MVIEW_COMMENTS.MVIEW_NAME, Tables.ALL_MVIEW_COMMENTS.COMMENTS).from(new TableLike[]{Tables.ALL_MVIEW_COMMENTS}).where(new Condition[]{Tables.ALL_MVIEW_COMMENTS.OWNER.upper().in(this.getInputSchemata())}).and(Tables.ALL_MVIEW_COMMENTS.MVIEW_NAME.notLike("%$%")))}).orderBy(new int[]{1, 2}).fetch()) {
            SchemaDefinition schema = this.getSchema((String)record.getValue(Tables.ALL_TAB_COMMENTS.OWNER));
            String name = (String)record.getValue(Tables.ALL_TAB_COMMENTS.TABLE_NAME);
            String comment = (String)record.getValue(Tables.ALL_TAB_COMMENTS.COMMENTS);
            OracleTableDefinition table = new OracleTableDefinition(schema, name, comment);
            result.add(table);
        }
        return result;
    }

    @Override
    protected List<EnumDefinition> getEnums0() throws SQLException {
        ArrayList<EnumDefinition> result = new ArrayList<EnumDefinition>();
        return result;
    }

    @Override
    protected List<UDTDefinition> getUDTs0() throws SQLException {
        ArrayList<UDTDefinition> result = new ArrayList<UDTDefinition>();
        for (Record record : this.create().selectDistinct(Tables.ALL_TYPES.OWNER, Tables.ALL_TYPES.TYPE_NAME).from(new TableLike[]{Tables.ALL_TYPES}).where(new Condition[]{Tables.ALL_TYPES.OWNER.upper().in(this.getInputSchemata())}).and(Tables.ALL_TYPES.TYPECODE.equal((Object)"OBJECT")).orderBy(new Field[]{Tables.ALL_TYPES.OWNER, Tables.ALL_TYPES.TYPE_NAME}).fetch()) {
            SchemaDefinition schema = this.getSchema((String)record.getValue(Tables.ALL_TYPES.OWNER));
            String name = (String)record.getValue(Tables.ALL_TYPES.TYPE_NAME);
            result.add(new OracleUDTDefinition(schema, name, null));
        }
        return result;
    }

    @Override
    protected List<ArrayDefinition> getArrays0() throws SQLException {
        ArrayList<ArrayDefinition> arrays = new ArrayList<ArrayDefinition>();
        for (Record record : this.create().select(Tables.ALL_COLL_TYPES.OWNER, Tables.ALL_COLL_TYPES.TYPE_NAME, Tables.ALL_COLL_TYPES.ELEM_TYPE_NAME, Tables.ALL_COLL_TYPES.LENGTH, Tables.ALL_COLL_TYPES.PRECISION, Tables.ALL_COLL_TYPES.SCALE).from(new TableLike[]{Tables.ALL_COLL_TYPES}).where(new Condition[]{Tables.ALL_COLL_TYPES.OWNER.upper().in(this.getInputSchemata())}).and(Tables.ALL_COLL_TYPES.COLL_TYPE.in((Object[])new String[]{"VARYING ARRAY", "TABLE"})).orderBy(new Field[]{Tables.ALL_COLL_TYPES.OWNER, Tables.ALL_COLL_TYPES.TYPE_NAME}).fetch()) {
            SchemaDefinition schema = this.getSchema((String)record.getValue(Tables.ALL_COLL_TYPES.OWNER));
            String name = (String)record.getValue(Tables.ALL_COLL_TYPES.TYPE_NAME);
            String dataType = (String)record.getValue(Tables.ALL_COLL_TYPES.ELEM_TYPE_NAME);
            int length = ((BigDecimal)record.getValue(Tables.ALL_COLL_TYPES.LENGTH, (Object)BigDecimal.ZERO)).intValue();
            int precision = ((BigDecimal)record.getValue(Tables.ALL_COLL_TYPES.PRECISION, (Object)BigDecimal.ZERO)).intValue();
            int scale = ((BigDecimal)record.getValue(Tables.ALL_COLL_TYPES.SCALE, (Object)BigDecimal.ZERO)).intValue();
            DefaultDataTypeDefinition type = new DefaultDataTypeDefinition(this, schema, dataType, length, precision, scale, null, null);
            DefaultArrayDefinition array = new DefaultArrayDefinition(schema, name, type);
            arrays.add(array);
        }
        return arrays;
    }

    @Override
    protected List<RoutineDefinition> getRoutines0() throws SQLException {
        ArrayList<RoutineDefinition> result = new ArrayList<RoutineDefinition>();
        for (Record record : this.create().select(Tables.ALL_OBJECTS.OWNER, Tables.ALL_OBJECTS.OBJECT_NAME, Tables.ALL_OBJECTS.OBJECT_ID, Tables.ALL_PROCEDURES.AGGREGATE).from(new TableLike[]{Tables.ALL_OBJECTS}).leftOuterJoin((TableLike)Tables.ALL_PROCEDURES).on(new Condition[]{Tables.ALL_OBJECTS.OWNER.equal(Tables.ALL_PROCEDURES.OWNER)}).and(Tables.ALL_OBJECTS.OBJECT_TYPE.equal(Tables.ALL_PROCEDURES.OBJECT_TYPE)).and(Tables.ALL_OBJECTS.OBJECT_NAME.equal(Tables.ALL_PROCEDURES.OBJECT_NAME)).where(new Condition[]{Tables.ALL_OBJECTS.OWNER.upper().in(this.getInputSchemata()).and(Tables.ALL_OBJECTS.OBJECT_TYPE.in((Object[])new String[]{"FUNCTION", "PROCEDURE"}))}).orderBy(new Field[]{Tables.ALL_OBJECTS.OWNER, Tables.ALL_OBJECTS.OBJECT_NAME, Tables.ALL_OBJECTS.OBJECT_ID}).fetch()) {
            SchemaDefinition schema = this.getSchema((String)record.getValue(Tables.ALL_OBJECTS.OWNER));
            String objectName = (String)record.getValue(Tables.ALL_OBJECTS.OBJECT_NAME);
            BigDecimal objectId = (BigDecimal)record.getValue(Tables.ALL_OBJECTS.OBJECT_ID);
            boolean aggregate = (Boolean)record.getValue(Tables.ALL_PROCEDURES.AGGREGATE, Boolean.TYPE);
            result.add(new OracleRoutineDefinition(schema, null, objectName, "", objectId, null, aggregate));
        }
        return result;
    }

    @Override
    protected List<PackageDefinition> getPackages0() throws SQLException {
        ArrayList<PackageDefinition> result = new ArrayList<PackageDefinition>();
        for (Record record : this.create().select(Tables.ALL_OBJECTS.OWNER, Tables.ALL_OBJECTS.OBJECT_NAME, Tables.ALL_OBJECTS.OBJECT_ID).from(new TableLike[]{Tables.ALL_OBJECTS}).where(new Condition[]{Tables.ALL_OBJECTS.OWNER.upper().in(this.getInputSchemata()).and(Tables.ALL_OBJECTS.OBJECT_TYPE.equal((Object)"PACKAGE"))}).orderBy(new Field[]{Tables.ALL_OBJECTS.OWNER, Tables.ALL_OBJECTS.OBJECT_NAME, Tables.ALL_OBJECTS.OBJECT_ID}).fetch()) {
            SchemaDefinition schema = this.getSchema((String)record.getValue(Tables.ALL_OBJECTS.OWNER));
            String name = (String)record.getValue(Tables.ALL_OBJECTS.OBJECT_NAME);
            result.add(new OraclePackageDefinition(schema, name, ""));
        }
        return result;
    }

    @Override
    protected DSLContext create0() {
        return DSL.using((Connection)this.getConnection(), (SQLDialect)SQLDialect.ORACLE);
    }
}

