/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.util.mysql;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.Record4;
import org.jooq.Result;
import org.jooq.SQLDialect;
import org.jooq.SortField;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.jooq.util.AbstractDatabase;
import org.jooq.util.ArrayDefinition;
import org.jooq.util.ColumnDefinition;
import org.jooq.util.Database;
import org.jooq.util.DefaultEnumDefinition;
import org.jooq.util.DefaultRelations;
import org.jooq.util.EnumDefinition;
import org.jooq.util.PackageDefinition;
import org.jooq.util.RoutineDefinition;
import org.jooq.util.SchemaDefinition;
import org.jooq.util.SequenceDefinition;
import org.jooq.util.TableDefinition;
import org.jooq.util.UDTDefinition;
import org.jooq.util.mysql.MySQLRoutineDefinition;
import org.jooq.util.mysql.MySQLTableDefinition;
import org.jooq.util.mysql.information_schema.tables.Columns;
import org.jooq.util.mysql.information_schema.tables.KeyColumnUsage;
import org.jooq.util.mysql.information_schema.tables.ReferentialConstraints;
import org.jooq.util.mysql.information_schema.tables.Schemata;
import org.jooq.util.mysql.information_schema.tables.TableConstraints;
import org.jooq.util.mysql.information_schema.tables.Tables;
import org.jooq.util.mysql.mysql.tables.Proc;

public class MySQLDatabase
extends AbstractDatabase {
    @Override
    protected void loadPrimaryKeys(DefaultRelations relations2) throws SQLException {
        for (Record record : this.fetchKeys("PRIMARY KEY")) {
            SchemaDefinition schema = this.getSchema((String)record.getValue(KeyColumnUsage.TABLE_SCHEMA));
            String constraintName = (String)record.getValue(KeyColumnUsage.CONSTRAINT_NAME);
            String tableName = (String)record.getValue(KeyColumnUsage.TABLE_NAME);
            String columnName = (String)record.getValue(KeyColumnUsage.COLUMN_NAME);
            String key = this.getKeyName(tableName, constraintName);
            TableDefinition table = this.getTable(schema, tableName);
            if (table == null) continue;
            relations2.addPrimaryKey(key, table.getColumn(columnName));
        }
    }

    @Override
    protected void loadUniqueKeys(DefaultRelations relations2) throws SQLException {
        for (Record record : this.fetchKeys("UNIQUE")) {
            SchemaDefinition schema = this.getSchema((String)record.getValue(KeyColumnUsage.TABLE_SCHEMA));
            String constraintName = (String)record.getValue(KeyColumnUsage.CONSTRAINT_NAME);
            String tableName = (String)record.getValue(KeyColumnUsage.TABLE_NAME);
            String columnName = (String)record.getValue(KeyColumnUsage.COLUMN_NAME);
            String key = this.getKeyName(tableName, constraintName);
            TableDefinition table = this.getTable(schema, tableName);
            if (table == null) continue;
            relations2.addUniqueKey(key, table.getColumn(columnName));
        }
    }

    private String getKeyName(String tableName, String keyName) {
        return "KEY_" + tableName + "_" + keyName;
    }

    private Result<Record4<String, String, String, String>> fetchKeys(String constraintType) {
        return this.create().select(KeyColumnUsage.TABLE_SCHEMA, KeyColumnUsage.CONSTRAINT_NAME, KeyColumnUsage.TABLE_NAME, KeyColumnUsage.COLUMN_NAME).from(new TableLike[]{org.jooq.util.mysql.information_schema.Tables.KEY_COLUMN_USAGE}).join((TableLike)org.jooq.util.mysql.information_schema.Tables.TABLE_CONSTRAINTS).on(new Condition[]{KeyColumnUsage.TABLE_SCHEMA.equal(TableConstraints.TABLE_SCHEMA)}).and(KeyColumnUsage.TABLE_NAME.equal(TableConstraints.TABLE_NAME)).and(KeyColumnUsage.CONSTRAINT_NAME.equal(TableConstraints.CONSTRAINT_NAME)).where(new Condition[]{TableConstraints.CONSTRAINT_TYPE.equal((Object)constraintType)}).and(KeyColumnUsage.TABLE_SCHEMA.in(this.getInputSchemata())).orderBy(new SortField[]{KeyColumnUsage.TABLE_SCHEMA.asc(), KeyColumnUsage.TABLE_NAME.asc(), KeyColumnUsage.ORDINAL_POSITION.asc()}).fetch();
    }

    @Override
    protected void loadForeignKeys(DefaultRelations relations2) throws SQLException {
        for (Record record : this.create().select(ReferentialConstraints.CONSTRAINT_SCHEMA, ReferentialConstraints.CONSTRAINT_NAME, ReferentialConstraints.TABLE_NAME, ReferentialConstraints.REFERENCED_TABLE_NAME, ReferentialConstraints.UNIQUE_CONSTRAINT_NAME, ReferentialConstraints.UNIQUE_CONSTRAINT_SCHEMA, KeyColumnUsage.COLUMN_NAME).from(new TableLike[]{org.jooq.util.mysql.information_schema.Tables.REFERENTIAL_CONSTRAINTS}).join((TableLike)org.jooq.util.mysql.information_schema.Tables.KEY_COLUMN_USAGE).on(new Condition[]{ReferentialConstraints.CONSTRAINT_SCHEMA.equal(KeyColumnUsage.CONSTRAINT_SCHEMA)}).and(ReferentialConstraints.CONSTRAINT_NAME.equal(KeyColumnUsage.CONSTRAINT_NAME)).where(new Condition[]{ReferentialConstraints.CONSTRAINT_SCHEMA.in(this.getInputSchemata())}).orderBy(new SortField[]{KeyColumnUsage.CONSTRAINT_SCHEMA.asc(), KeyColumnUsage.CONSTRAINT_NAME.asc(), KeyColumnUsage.ORDINAL_POSITION.asc()}).fetch()) {
            SchemaDefinition foreignKeySchema = this.getSchema((String)record.getValue(ReferentialConstraints.CONSTRAINT_SCHEMA));
            SchemaDefinition uniqueKeySchema = this.getSchema((String)record.getValue(ReferentialConstraints.UNIQUE_CONSTRAINT_SCHEMA));
            String foreignKey = (String)record.getValue(ReferentialConstraints.CONSTRAINT_NAME);
            String foreignKeyColumn = (String)record.getValue(KeyColumnUsage.COLUMN_NAME);
            String foreignKeyTableName = (String)record.getValue(ReferentialConstraints.TABLE_NAME);
            String referencedKey = (String)record.getValue(ReferentialConstraints.UNIQUE_CONSTRAINT_NAME);
            String referencedTableName = (String)record.getValue(ReferentialConstraints.REFERENCED_TABLE_NAME);
            TableDefinition foreignKeyTable = this.getTable(foreignKeySchema, foreignKeyTableName);
            if (foreignKeyTable == null) continue;
            ColumnDefinition column = foreignKeyTable.getColumn(foreignKeyColumn);
            String key = this.getKeyName(referencedTableName, referencedKey);
            relations2.addForeignKey(foreignKey, key, column, uniqueKeySchema);
        }
    }

    @Override
    protected void loadCheckConstraints(DefaultRelations r) throws SQLException {
    }

    @Override
    protected List<SchemaDefinition> getSchemata0() throws SQLException {
        ArrayList<SchemaDefinition> result = new ArrayList<SchemaDefinition>();
        for (String name : this.create().select(Schemata.SCHEMA_NAME).from(new TableLike[]{org.jooq.util.mysql.information_schema.Tables.SCHEMATA}).fetch(Schemata.SCHEMA_NAME)) {
            result.add(new SchemaDefinition((Database)this, name, ""));
        }
        return result;
    }

    @Override
    protected List<SequenceDefinition> getSequences0() throws SQLException {
        ArrayList<SequenceDefinition> result = new ArrayList<SequenceDefinition>();
        return result;
    }

    @Override
    protected List<TableDefinition> getTables0() throws SQLException {
        ArrayList<TableDefinition> result = new ArrayList<TableDefinition>();
        for (Record record : this.create().select(Tables.TABLE_SCHEMA, Tables.TABLE_NAME, Tables.TABLE_COMMENT).from(new TableLike[]{org.jooq.util.mysql.information_schema.Tables.TABLES}).where(new Condition[]{Tables.TABLE_SCHEMA.in(this.getInputSchemata())}).orderBy(new Field[]{Tables.TABLE_SCHEMA, Tables.TABLE_NAME}).fetch()) {
            SchemaDefinition schema = this.getSchema((String)record.getValue(Tables.TABLE_SCHEMA));
            String name = (String)record.getValue(Tables.TABLE_NAME);
            String comment = (String)record.getValue(Tables.TABLE_COMMENT);
            MySQLTableDefinition table = new MySQLTableDefinition(schema, name, comment);
            result.add(table);
        }
        return result;
    }

    @Override
    protected List<EnumDefinition> getEnums0() throws SQLException {
        ArrayList<EnumDefinition> result = new ArrayList<EnumDefinition>();
        Result records = this.create().select(Columns.TABLE_SCHEMA, Columns.COLUMN_COMMENT, Columns.TABLE_NAME, Columns.COLUMN_NAME, Columns.COLUMN_TYPE).from(new TableLike[]{org.jooq.util.mysql.information_schema.Tables.COLUMNS}).where(new Condition[]{Columns.COLUMN_TYPE.like("enum(%)").and(Columns.TABLE_SCHEMA.in(this.getInputSchemata()))}).orderBy(new SortField[]{Columns.TABLE_SCHEMA.asc(), Columns.TABLE_NAME.asc(), Columns.COLUMN_NAME.asc()}).fetch();
        for (Record record : records) {
            ColumnDefinition columnDefinition;
            SchemaDefinition schema = this.getSchema((String)record.getValue(Columns.TABLE_SCHEMA));
            String comment = (String)record.getValue(Columns.COLUMN_COMMENT);
            String table = (String)record.getValue(Columns.TABLE_NAME);
            String column = (String)record.getValue(Columns.COLUMN_NAME);
            String name = table + "_" + column;
            String columnType = (String)record.getValue(Columns.COLUMN_TYPE);
            TableDefinition tableDefinition = this.getTable(schema, table);
            if (tableDefinition == null || (columnDefinition = tableDefinition.getColumn(column)) == null || this.getConfiguredForcedType(columnDefinition) != null) continue;
            DefaultEnumDefinition definition = new DefaultEnumDefinition(schema, name, comment);
            for (String string : columnType.replaceAll("enum\\(|\\)", "").split(",")) {
                definition.addLiteral(string.trim().replaceAll("'", ""));
            }
            result.add(definition);
        }
        return result;
    }

    @Override
    protected List<UDTDefinition> getUDTs0() throws SQLException {
        ArrayList<UDTDefinition> result = new ArrayList<UDTDefinition>();
        return result;
    }

    @Override
    protected List<ArrayDefinition> getArrays0() throws SQLException {
        ArrayList<ArrayDefinition> result = new ArrayList<ArrayDefinition>();
        return result;
    }

    @Override
    protected List<RoutineDefinition> getRoutines0() throws SQLException {
        ArrayList<RoutineDefinition> result = new ArrayList<RoutineDefinition>();
        for (Record record : this.create().select(Proc.DB, Proc.NAME, Proc.COMMENT, Proc.PARAM_LIST, Proc.RETURNS).from(new TableLike[]{Proc.PROC}).where(new Condition[]{Proc.DB.in(this.getInputSchemata())}).orderBy(new Field[]{Proc.DB, Proc.NAME}).fetch()) {
            SchemaDefinition schema = this.getSchema((String)record.getValue(Proc.DB));
            String name = (String)record.getValue(Proc.NAME);
            String comment = (String)record.getValue(Proc.COMMENT);
            String params = new String((byte[])record.getValue(Proc.PARAM_LIST));
            String returns = new String((byte[])record.getValue(Proc.RETURNS));
            result.add(new MySQLRoutineDefinition(schema, name, comment, params, returns));
        }
        return result;
    }

    @Override
    protected List<PackageDefinition> getPackages0() throws SQLException {
        ArrayList<PackageDefinition> result = new ArrayList<PackageDefinition>();
        return result;
    }

    @Override
    protected DSLContext create0() {
        return DSL.using((Connection)this.getConnection(), (SQLDialect)SQLDialect.MYSQL);
    }
}

