/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.util.ingres;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.Record4;
import org.jooq.Result;
import org.jooq.SQLDialect;
import org.jooq.SortField;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.jooq.util.AbstractDatabase;
import org.jooq.util.ArrayDefinition;
import org.jooq.util.ColumnDefinition;
import org.jooq.util.Database;
import org.jooq.util.DefaultDataTypeDefinition;
import org.jooq.util.DefaultRelations;
import org.jooq.util.DefaultSequenceDefinition;
import org.jooq.util.EnumDefinition;
import org.jooq.util.PackageDefinition;
import org.jooq.util.RoutineDefinition;
import org.jooq.util.SchemaDefinition;
import org.jooq.util.SequenceDefinition;
import org.jooq.util.TableDefinition;
import org.jooq.util.UDTDefinition;
import org.jooq.util.ingres.IngresTableDefinition;
import org.jooq.util.ingres.ingres.Tables;
import org.jooq.util.ingres.ingres.tables.Iiconstraints;
import org.jooq.util.ingres.ingres.tables.IidbComments;
import org.jooq.util.ingres.ingres.tables.Iikeys;
import org.jooq.util.ingres.ingres.tables.IirefConstraints;
import org.jooq.util.ingres.ingres.tables.Iischema;
import org.jooq.util.ingres.ingres.tables.Iisequences;
import org.jooq.util.ingres.ingres.tables.Iitables;

public class IngresDatabase
extends AbstractDatabase {
    @Override
    protected DSLContext create0() {
        return DSL.using((Connection)this.getConnection(), (SQLDialect)SQLDialect.INGRES);
    }

    @Override
    protected void loadPrimaryKeys(DefaultRelations relations2) throws SQLException {
        for (Record record : this.fetchKeys("P")) {
            SchemaDefinition schema = this.getSchema((String)record.getValue(DSL.trim(Iiconstraints.SCHEMA_NAME)));
            String key = (String)record.getValue(DSL.trim(Iiconstraints.CONSTRAINT_NAME));
            String tableName = (String)record.getValue(DSL.trim(Iiconstraints.TABLE_NAME));
            String columnName = (String)record.getValue(DSL.trim(Iikeys.COLUMN_NAME));
            TableDefinition table = this.getTable(schema, tableName);
            if (table == null) continue;
            relations2.addPrimaryKey(key, table.getColumn(columnName));
        }
    }

    @Override
    protected void loadUniqueKeys(DefaultRelations relations2) throws SQLException {
        for (Record record : this.fetchKeys("U")) {
            SchemaDefinition schema = this.getSchema((String)record.getValue(DSL.trim(Iiconstraints.SCHEMA_NAME)));
            String key = (String)record.getValue(DSL.trim(Iiconstraints.CONSTRAINT_NAME));
            String tableName = (String)record.getValue(DSL.trim(Iiconstraints.TABLE_NAME));
            String columnName = (String)record.getValue(DSL.trim(Iikeys.COLUMN_NAME));
            TableDefinition table = this.getTable(schema, tableName);
            if (table == null) continue;
            relations2.addPrimaryKey(key, table.getColumn(columnName));
        }
    }

    private Result<Record4<String, String, String, String>> fetchKeys(String constraintType) {
        return this.create().select(DSL.trim(Iiconstraints.SCHEMA_NAME), DSL.trim(Iiconstraints.TABLE_NAME), DSL.trim(Iiconstraints.CONSTRAINT_NAME), DSL.trim(Iikeys.COLUMN_NAME)).from(new TableLike[]{Tables.IICONSTRAINTS}).join((TableLike)Iikeys.IIKEYS).on(new Condition[]{DSL.row(Iiconstraints.CONSTRAINT_NAME, Iiconstraints.SCHEMA_NAME).eq(Iikeys.CONSTRAINT_NAME, Iikeys.SCHEMA_NAME)}).where(new Condition[]{Iiconstraints.SCHEMA_NAME.in(this.getInputSchemata())}).and(Iiconstraints.CONSTRAINT_TYPE.trim().equal((Object)constraintType)).orderBy(new SortField[]{Iiconstraints.SCHEMA_NAME.asc(), Iiconstraints.TABLE_NAME.asc(), Iiconstraints.CONSTRAINT_NAME.asc(), Iikeys.KEY_POSITION.asc()}).fetch();
    }

    @Override
    protected void loadForeignKeys(DefaultRelations relations2) throws SQLException {
        Result result = this.create().select(DSL.trim(IirefConstraints.REF_SCHEMA_NAME), DSL.trim(IirefConstraints.REF_CONSTRAINT_NAME), DSL.trim(IirefConstraints.UNIQUE_CONSTRAINT_NAME), DSL.trim(IirefConstraints.UNIQUE_SCHEMA_NAME), DSL.trim(IirefConstraints.REF_TABLE_NAME), DSL.trim(Iikeys.COLUMN_NAME)).from(new TableLike[]{Tables.IICONSTRAINTS}).join((TableLike)Tables.IIREF_CONSTRAINTS).on(new Condition[]{DSL.row(Iiconstraints.CONSTRAINT_NAME, Iiconstraints.SCHEMA_NAME).eq(IirefConstraints.REF_CONSTRAINT_NAME, IirefConstraints.REF_SCHEMA_NAME)}).join((TableLike)Iikeys.IIKEYS).on(new Condition[]{DSL.row(IirefConstraints.REF_CONSTRAINT_NAME, IirefConstraints.REF_SCHEMA_NAME).eq(Iikeys.CONSTRAINT_NAME, Iikeys.SCHEMA_NAME)}).where(new Condition[]{Iiconstraints.SCHEMA_NAME.in(this.getInputSchemata())}).and(Iiconstraints.CONSTRAINT_TYPE.equal((Object)"R")).orderBy(new SortField[]{IirefConstraints.REF_SCHEMA_NAME.asc(), IirefConstraints.REF_TABLE_NAME.asc(), IirefConstraints.REF_CONSTRAINT_NAME.asc(), Iikeys.KEY_POSITION.asc()}).fetch();
        for (Record record : result) {
            SchemaDefinition foreignKeySchema = this.getSchema((String)record.getValue(DSL.trim(IirefConstraints.REF_SCHEMA_NAME)));
            SchemaDefinition uniqueKeySchema = this.getSchema((String)record.getValue(DSL.trim(IirefConstraints.UNIQUE_SCHEMA_NAME)));
            String foreignKey = (String)record.getValue(DSL.trim(IirefConstraints.REF_CONSTRAINT_NAME));
            String foreignKeyTable = (String)record.getValue(DSL.trim(IirefConstraints.REF_TABLE_NAME));
            String foreignKeyColumn = (String)record.getValue(DSL.trim(Iikeys.COLUMN_NAME));
            String uniqueKey = (String)record.getValue(DSL.trim(IirefConstraints.UNIQUE_CONSTRAINT_NAME));
            TableDefinition referencingTable = this.getTable(foreignKeySchema, foreignKeyTable);
            if (referencingTable == null) continue;
            ColumnDefinition referencingColumn = referencingTable.getColumn(foreignKeyColumn);
            relations2.addForeignKey(foreignKey, uniqueKey, referencingColumn, uniqueKeySchema);
        }
    }

    @Override
    protected void loadCheckConstraints(DefaultRelations r) throws SQLException {
    }

    @Override
    protected List<SchemaDefinition> getSchemata0() throws SQLException {
        ArrayList<SchemaDefinition> result = new ArrayList<SchemaDefinition>();
        for (String name : this.create().select(DSL.trim(Iischema.SCHEMA_NAME)).from(new TableLike[]{Tables.IISCHEMA}).fetch(DSL.trim(Iischema.SCHEMA_NAME))) {
            result.add(new SchemaDefinition((Database)this, name, ""));
        }
        return result;
    }

    @Override
    protected List<SequenceDefinition> getSequences0() throws SQLException {
        ArrayList<SequenceDefinition> result = new ArrayList<SequenceDefinition>();
        for (Record record : this.create().select(DSL.trim(Iisequences.SEQ_OWNER), DSL.trim(Iisequences.SEQ_NAME), DSL.trim(Iisequences.DATA_TYPE)).from(new TableLike[]{Tables.IISEQUENCES}).where(new Condition[]{Iisequences.SEQ_OWNER.in(this.getInputSchemata())}).orderBy(new Field[]{Iisequences.SEQ_OWNER, Iisequences.SEQ_NAME}).fetch()) {
            SchemaDefinition schema = this.getSchema((String)record.getValue(DSL.trim(Iisequences.SEQ_OWNER)));
            DefaultDataTypeDefinition type = new DefaultDataTypeDefinition(this, schema, (String)record.getValue(DSL.trim(Iisequences.DATA_TYPE)));
            result.add(new DefaultSequenceDefinition(schema, (String)record.getValue(DSL.trim(Iisequences.SEQ_NAME)), type));
        }
        return result;
    }

    @Override
    protected List<TableDefinition> getTables0() throws SQLException {
        ArrayList<TableDefinition> result = new ArrayList<TableDefinition>();
        for (Record record : this.create().select(DSL.trim(Iitables.TABLE_OWNER), DSL.trim(Iitables.TABLE_NAME), DSL.trim(IidbComments.LONG_REMARK)).from(new TableLike[]{Tables.IITABLES}).leftOuterJoin((TableLike)Tables.IIDB_COMMENTS).on(new Condition[]{Iitables.TABLE_NAME.equal(IidbComments.OBJECT_NAME)}).and(Iitables.TABLE_OWNER.equal(IidbComments.OBJECT_OWNER)).and(IidbComments.OBJECT_TYPE.equal((Object)"T")).and(IidbComments.TEXT_SEQUENCE.equal((Object)1L)).where(new Condition[]{Iitables.TABLE_OWNER.in(this.getInputSchemata())}).orderBy(new Field[]{DSL.trim(Iitables.TABLE_OWNER), DSL.trim(Iitables.TABLE_NAME)}).fetch()) {
            result.add(new IngresTableDefinition(this.getSchema((String)record.getValue(DSL.trim(Iitables.TABLE_OWNER))), (String)record.getValue(DSL.trim(Iitables.TABLE_NAME)), (String)record.getValue(DSL.trim(IidbComments.LONG_REMARK))));
        }
        return result;
    }

    @Override
    protected List<RoutineDefinition> getRoutines0() throws SQLException {
        ArrayList<RoutineDefinition> result = new ArrayList<RoutineDefinition>();
        return result;
    }

    @Override
    protected List<PackageDefinition> getPackages0() throws SQLException {
        ArrayList<PackageDefinition> result = new ArrayList<PackageDefinition>();
        return result;
    }

    @Override
    protected List<EnumDefinition> getEnums0() throws SQLException {
        ArrayList<EnumDefinition> result = new ArrayList<EnumDefinition>();
        return result;
    }

    @Override
    protected List<UDTDefinition> getUDTs0() throws SQLException {
        ArrayList<UDTDefinition> result = new ArrayList<UDTDefinition>();
        return result;
    }

    @Override
    protected List<ArrayDefinition> getArrays0() throws SQLException {
        ArrayList<ArrayDefinition> result = new ArrayList<ArrayDefinition>();
        return result;
    }
}

