/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.util.ase;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.jooq.Record;
import org.jooq.Result;
import org.jooq.tools.StringUtils;
import org.jooq.util.AbstractRoutineDefinition;
import org.jooq.util.DefaultDataTypeDefinition;
import org.jooq.util.DefaultParameterDefinition;
import org.jooq.util.InOutDefinition;
import org.jooq.util.SchemaDefinition;

class ASERoutineDefinition
extends AbstractRoutineDefinition {
    public ASERoutineDefinition(SchemaDefinition schema, String name, String dataType, Number length, Number precision, Number scale) {
        super(schema, null, name, null, null);
        if (!StringUtils.isBlank((String)dataType)) {
            throw new InstantiationError("datatype argument not supported for ASE routines");
        }
    }

    @Override
    protected void init0() throws SQLException {
        ArrayList result = new ArrayList();
        List fetchMany = this.create().fetchMany("sp_help '" + this.getName() + "'");
        if (fetchMany.size() < 2) {
            return;
        }
        for (Record record : (Result)fetchMany.get(1)) {
            String n = (String)record.getValue("Parameter_name", String.class);
            String l = (String)record.getValue("Length", String.class);
            String p = (String)record.getValue("Prec", String.class);
            String s = (String)record.getValue("Scale", String.class);
            int o = (Integer)record.getValue("Param_order", Integer.TYPE);
            String inOut = (String)record.getValue("Mode", String.class);
            int length = 0;
            int precision = 0;
            int scale = 0;
            if (l != null && !"null".equalsIgnoreCase(l.trim())) {
                length = Integer.valueOf(l.trim());
            }
            if (p != null && !"null".equalsIgnoreCase(p.trim())) {
                precision = Integer.valueOf(p.trim());
            }
            if (s != null && !"null".equalsIgnoreCase(s.trim())) {
                scale = Integer.valueOf(s.trim());
            }
            DefaultDataTypeDefinition type = new DefaultDataTypeDefinition(this.getDatabase(), this.getSchema(), (String)record.getValue("Type", String.class), length, precision, scale, null, null);
            DefaultParameterDefinition parameter = new DefaultParameterDefinition(this, n.replaceAll("@", ""), o, type);
            this.addParameter(InOutDefinition.getFromString(inOut), parameter);
        }
    }
}

