/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.util.ase;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.Record10;
import org.jooq.Result;
import org.jooq.SQLDialect;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.jooq.tools.JooqLogger;
import org.jooq.util.AbstractDatabase;
import org.jooq.util.ArrayDefinition;
import org.jooq.util.ColumnDefinition;
import org.jooq.util.Database;
import org.jooq.util.DefaultRelations;
import org.jooq.util.EnumDefinition;
import org.jooq.util.PackageDefinition;
import org.jooq.util.RoutineDefinition;
import org.jooq.util.SchemaDefinition;
import org.jooq.util.SequenceDefinition;
import org.jooq.util.TableDefinition;
import org.jooq.util.UDTDefinition;
import org.jooq.util.ase.ASETableDefinition;
import org.jooq.util.ase.sys.tables.Sysindexes;
import org.jooq.util.ase.sys.tables.Sysreferences;
import org.jooq.util.ase.sys.tables.Sysusers;

public class ASEDatabase
extends AbstractDatabase {
    private static final JooqLogger log = JooqLogger.getLogger(ASEDatabase.class);
    private static final int PK_INCL = 2048;
    private static final int PK_EXCL = 64;
    private static final int UK_INCL = 4098;
    private static final int UK_EXCL = 2112;

    @Override
    protected DSLContext create0() {
        return DSL.using((Connection)this.getConnection(), (SQLDialect)SQLDialect.ASE);
    }

    private SchemaDefinition getSchema() {
        List<SchemaDefinition> schemata = this.getSchemata();
        if (schemata.size() > 1) {
            log.error((Object)"NOT SUPPORTED", (Object)"jOOQ does not support multiple schemata in Sybase ASE.");
            log.error((Object)"-----------------------------------------------------------------------");
        }
        return schemata.get(0);
    }

    @Override
    protected void loadPrimaryKeys(DefaultRelations relations2) throws SQLException {
        for (Record record : this.fetchKeys(2048, 64)) {
            String keyName = (String)record.getValue(0, String.class);
            TableDefinition table = this.getTable(this.getSchema(), (String)record.getValue(1, String.class));
            if (table == null) continue;
            for (int i = 0; i < 8 && record.getValue(2 + i) != null; ++i) {
                relations2.addPrimaryKey(keyName, table.getColumn((String)record.getValue(2 + i, String.class)));
            }
        }
    }

    @Override
    protected void loadUniqueKeys(DefaultRelations relations2) throws SQLException {
        for (Record record : this.fetchKeys(4098, 2112)) {
            String keyName = (String)record.getValue(0, String.class);
            TableDefinition table = this.getTable(this.getSchema(), (String)record.getValue(1, String.class));
            if (table == null) continue;
            for (int i = 0; i < 8 && record.getValue(2 + i) != null; ++i) {
                relations2.addUniqueKey(keyName, table.getColumn((String)record.getValue(2 + i, String.class)));
            }
        }
    }

    private Result<Record10<String, String, String, String, String, String, String, String, String, String>> fetchKeys(int incl, int excl) {
        Field table = DSL.field((String)"object_name(id)", String.class);
        Field key = DSL.field((String)"name", String.class);
        return this.create().select(DSL.concat((Field[])new Field[]{table, DSL.val((Object)"__"), key}), table, DSL.field((String)"index_col(object_name(id), indid, 1)", String.class), DSL.field((String)"index_col(object_name(id), indid, 2)", String.class), DSL.field((String)"index_col(object_name(id), indid, 3)", String.class), DSL.field((String)"index_col(object_name(id), indid, 4)", String.class), DSL.field((String)"index_col(object_name(id), indid, 5)", String.class), DSL.field((String)"index_col(object_name(id), indid, 6)", String.class), DSL.field((String)"index_col(object_name(id), indid, 7)", String.class), DSL.field((String)"index_col(object_name(id), indid, 8)", String.class)).from(new TableLike[]{Sysindexes.SYSINDEXES}).where("status & ? = 0", new Object[]{excl}).and("status & ? <> 0", new Object[]{incl}).orderBy(new Field[]{Sysindexes.ID}).fetch();
    }

    @Override
    protected void loadForeignKeys(DefaultRelations relations2) throws SQLException {
        Field fkTable = DSL.field((String)"object_name(tableid)", String.class);
        Field fk = DSL.field((String)"object_name(constrid)", String.class);
        Field pkTable = DSL.field((String)"object_name(reftabid)", String.class);
        Field pk = DSL.field((String)"index_name(pmrydbid, reftabid, indexid)", String.class);
        for (Record record : this.create().select(fkTable.as("fk_table"), DSL.concat((Field[])new Field[]{fkTable, DSL.val((Object)"__"), fk}).as("fk"), DSL.concat((Field[])new Field[]{pkTable, DSL.val((Object)"__"), pk}).as("pk"), DSL.field((String)"col_name(tableid, fokey1)", String.class), DSL.field((String)"col_name(tableid, fokey2)", String.class), DSL.field((String)"col_name(tableid, fokey3)", String.class), DSL.field((String)"col_name(tableid, fokey4)", String.class), DSL.field((String)"col_name(tableid, fokey5)", String.class), DSL.field((String)"col_name(tableid, fokey6)", String.class), DSL.field((String)"col_name(tableid, fokey7)", String.class), DSL.field((String)"col_name(tableid, fokey8)", String.class), DSL.field((String)"col_name(tableid, fokey9)", String.class), DSL.field((String)"col_name(tableid, fokey10)", String.class), DSL.field((String)"col_name(tableid, fokey11)", String.class), DSL.field((String)"col_name(tableid, fokey12)", String.class), DSL.field((String)"col_name(tableid, fokey13)", String.class), DSL.field((String)"col_name(tableid, fokey14)", String.class), DSL.field((String)"col_name(tableid, fokey15)", String.class), DSL.field((String)"col_name(tableid, fokey16)", String.class), DSL.field((String)"object_owner_id(tableid)")).from(new TableLike[]{Sysreferences.SYSREFERENCES}).fetch()) {
            TableDefinition referencingTable = this.getTable(this.getSchema(), (String)record.getValue("fk_table", String.class));
            if (referencingTable == null) continue;
            for (int i = 0; i < 16 && record.getValue(i + 3) != null; ++i) {
                String foreignKeyName = (String)record.getValue("fk", String.class);
                String foreignKeyColumnName = (String)record.getValue(i + 3, String.class);
                String uniqueKeyName = (String)record.getValue("pk", String.class);
                ColumnDefinition column = referencingTable.getColumn(foreignKeyColumnName);
                relations2.addForeignKey(foreignKeyName, uniqueKeyName, column, this.getSchema());
            }
        }
    }

    @Override
    protected void loadCheckConstraints(DefaultRelations r) throws SQLException {
    }

    @Override
    protected List<SchemaDefinition> getSchemata0() throws SQLException {
        ArrayList<SchemaDefinition> result = new ArrayList<SchemaDefinition>();
        for (String name : this.create().select(Sysusers.NAME).from(new TableLike[]{Sysusers.SYSUSERS}).fetch(Sysusers.NAME)) {
            result.add(new SchemaDefinition((Database)this, name, ""));
        }
        return result;
    }

    @Override
    protected List<SequenceDefinition> getSequences0() throws SQLException {
        ArrayList<SequenceDefinition> result = new ArrayList<SequenceDefinition>();
        return result;
    }

    @Override
    protected List<TableDefinition> getTables0() throws SQLException {
        ArrayList<TableDefinition> result = new ArrayList<TableDefinition>();
        for (Record record : this.fetchTables()) {
            SchemaDefinition schema = this.getSchema((String)record.getValue("Owner", String.class));
            String name = (String)record.getValue("Name", String.class);
            result.add(new ASETableDefinition(schema, name, null));
        }
        return result;
    }

    private List<Record> fetchTables() {
        ArrayList<Record> result = new ArrayList<Record>();
        for (Record record : this.create().fetch("sp_help")) {
            if (!Arrays.asList("view", "user table", "system table").contains(record.getValue("Object_type", String.class)) || !this.getInputSchemata().contains(record.getValue("Owner", String.class))) continue;
            result.add(record);
        }
        return result;
    }

    private List<Record> fetchRoutines() {
        ArrayList<Record> result = new ArrayList<Record>();
        for (Record record : this.create().fetch("sp_help")) {
            if (!Arrays.asList("stored procedure").contains(record.getValue("Object_type", String.class)) || !this.getInputSchemata().contains(record.getValue("Owner", String.class))) continue;
            result.add(record);
        }
        return result;
    }

    @Override
    protected List<RoutineDefinition> getRoutines0() throws SQLException {
        ArrayList<RoutineDefinition> result = new ArrayList<RoutineDefinition>();
        return result;
    }

    @Override
    protected List<PackageDefinition> getPackages0() throws SQLException {
        ArrayList<PackageDefinition> result = new ArrayList<PackageDefinition>();
        return result;
    }

    @Override
    protected List<EnumDefinition> getEnums0() throws SQLException {
        ArrayList<EnumDefinition> result = new ArrayList<EnumDefinition>();
        return result;
    }

    @Override
    protected List<UDTDefinition> getUDTs0() throws SQLException {
        ArrayList<UDTDefinition> result = new ArrayList<UDTDefinition>();
        return result;
    }

    @Override
    protected List<ArrayDefinition> getArrays0() throws SQLException {
        ArrayList<ArrayDefinition> result = new ArrayList<ArrayDefinition>();
        return result;
    }
}

