/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.meta.xml;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.jooq.TableOptions;
import org.jooq.impl.DSL;
import org.jooq.impl.QOM;
import org.jooq.meta.AbstractTableDefinition;
import org.jooq.meta.ColumnDefinition;
import org.jooq.meta.DefaultColumnDefinition;
import org.jooq.meta.DefaultDataTypeDefinition;
import org.jooq.meta.SchemaDefinition;
import org.jooq.meta.xml.XMLDatabase;
import org.jooq.util.xml.jaxb.Column;
import org.jooq.util.xml.jaxb.InformationSchema;
import org.jooq.util.xml.jaxb.Table;

public class XMLTableDefinition
extends AbstractTableDefinition {
    private final InformationSchema info;
    private final Table table;

    public XMLTableDefinition(SchemaDefinition schema, InformationSchema info, Table table) {
        this(schema, info, table, "");
    }

    public XMLTableDefinition(SchemaDefinition schema, InformationSchema info, Table table, String comment) {
        this(schema, info, table, comment, TableOptions.TableType.TABLE, null);
    }

    public XMLTableDefinition(SchemaDefinition schema, InformationSchema info, Table table, String comment, TableOptions.TableType tableType, String source) {
        super(schema, table.getTableName(), comment, tableType, source);
        this.info = info;
        this.table = table;
    }

    @Override
    protected List<ColumnDefinition> getElements0() throws SQLException {
        ArrayList<ColumnDefinition> result = new ArrayList<ColumnDefinition>();
        for (Column column : ((XMLDatabase)this.getDatabase()).getColumnsByTableName(DSL.name((String[])new String[]{this.table.getTableCatalog(), this.table.getTableSchema(), this.table.getTableName()}))) {
            SchemaDefinition schema = this.getDatabase().getSchema(column.getTableSchema());
            DefaultDataTypeDefinition type = new DefaultDataTypeDefinition(this.getDatabase(), schema, column.getDataType(), (Number)XMLDatabase.unbox(column.getCharacterMaximumLength()), (Number)XMLDatabase.unbox(column.getNumericPrecision()), (Number)XMLDatabase.unbox(column.getNumericScale()), column.isIsNullable(), column.getColumnDefault()).generatedAlwaysAs(Boolean.TRUE.equals(column.isIsGenerated()) ? column.getGenerationExpression() : null).generationOption((QOM.GenerationOption)(Boolean.TRUE.equals(column.isIsGenerated()) ? ("STORED".equalsIgnoreCase(column.getGenerationOption()) ? QOM.GenerationOption.STORED : ("VIRTUAL".equalsIgnoreCase(column.getGenerationOption()) ? QOM.GenerationOption.VIRTUAL : null)) : null));
            result.add(new DefaultColumnDefinition(this, column.getColumnName(), XMLDatabase.unbox(column.getOrdinalPosition()), type, column.getIdentityGeneration() != null, Boolean.TRUE.equals(column.isReadonly()), column.getComment()));
        }
        return result;
    }
}

