/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.meta;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jooq.meta.CheckConstraintDefinition;
import org.jooq.meta.ColumnDefinition;
import org.jooq.meta.DefaultForeignKeyDefinition;
import org.jooq.meta.DefaultUniqueKeyDefinition;
import org.jooq.meta.Definition;
import org.jooq.meta.ForeignKeyDefinition;
import org.jooq.meta.Relations;
import org.jooq.meta.SchemaDefinition;
import org.jooq.meta.TableDefinition;
import org.jooq.meta.UniqueKeyDefinition;
import org.jooq.tools.JooqLogger;

public class DefaultRelations
implements Relations {
    private static final JooqLogger log = JooqLogger.getLogger(DefaultRelations.class);
    private final Map<Key, UniqueKeyDefinition> primaryKeys = new LinkedHashMap<Key, UniqueKeyDefinition>();
    private final Map<Key, UniqueKeyDefinition> uniqueKeys = new LinkedHashMap<Key, UniqueKeyDefinition>();
    private final Map<Key, UniqueKeyDefinition> keys = new LinkedHashMap<Key, UniqueKeyDefinition>();
    private final Map<Key, ForeignKeyDefinition> foreignKeys = new LinkedHashMap<Key, ForeignKeyDefinition>();
    private final Map<Key, CheckConstraintDefinition> checkConstraints = new LinkedHashMap<Key, CheckConstraintDefinition>();
    private final Set<Key> incompleteKeys = new HashSet<Key>();
    private transient Map<ColumnDefinition, UniqueKeyDefinition> primaryKeysByColumn;
    private transient Map<ColumnDefinition, List<UniqueKeyDefinition>> uniqueKeysByColumn;
    private transient Map<ColumnDefinition, List<UniqueKeyDefinition>> keysByColumn;
    private transient Map<ColumnDefinition, List<ForeignKeyDefinition>> foreignKeysByColumn;
    private transient Map<TableDefinition, List<UniqueKeyDefinition>> uniqueKeysByTable;
    private transient Map<TableDefinition, List<UniqueKeyDefinition>> keysByTable;
    private transient Map<TableDefinition, List<ForeignKeyDefinition>> foreignKeysByTable;
    private transient Map<TableDefinition, List<CheckConstraintDefinition>> checkConstraintsByTable;
    private final Map<Key, Integer> nextUkColumnIndex = new HashMap<Key, Integer>();

    public void addPrimaryKey(String keyName, TableDefinition table, ColumnDefinition column) {
        this.addPrimaryKey(keyName, table, column, true);
    }

    public void addPrimaryKey(String keyName, TableDefinition table, ColumnDefinition column, boolean enforced) {
        Key key = DefaultRelations.key(table, keyName);
        if (column == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Ignoring primary key", (Object)(keyName + " (column unavailable)"));
            }
            if (table != null) {
                this.incompleteKeys.add(key);
                this.primaryKeys.remove(key);
                this.keys.remove(key);
            }
            return;
        }
        if (this.incompleteKeys.contains(key)) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Adding primary key", (Object)(keyName + " (" + String.valueOf(column) + ")"));
        }
        UniqueKeyDefinition result = this.getUniqueKey(keyName, table, column, true, enforced);
        result.getKeyColumns().add(column);
    }

    public void addUniqueKey(String keyName, TableDefinition table, ColumnDefinition column) {
        this.addUniqueKey(keyName, table, column, true);
    }

    public void addUniqueKey(String keyName, TableDefinition table, ColumnDefinition column, boolean enforced) {
        Key key = DefaultRelations.key(table, keyName);
        if (column == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Ignoring unique key", (Object)(keyName + " (column unavailable)"));
            }
            if (table != null) {
                this.incompleteKeys.add(key);
                this.uniqueKeys.remove(key);
                this.keys.remove(key);
            }
            return;
        }
        if (this.incompleteKeys.contains(key)) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Adding unique key", (Object)(keyName + " (" + String.valueOf(column) + ")"));
        }
        UniqueKeyDefinition result = this.getUniqueKey(keyName, table, column, false, enforced);
        result.getKeyColumns().add(column);
    }

    public void overridePrimaryKey(UniqueKeyDefinition key) {
        Key mapKey;
        UniqueKeyDefinition old = null;
        this.primaryKeysByColumn = null;
        this.uniqueKeysByColumn = null;
        this.uniqueKeysByTable = null;
        this.keysByColumn = null;
        this.keysByTable = null;
        this.foreignKeysByColumn = null;
        this.foreignKeysByTable = null;
        Iterator<Map.Entry<Key, UniqueKeyDefinition>> it = this.primaryKeys.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Key, UniqueKeyDefinition> entry = it.next();
            if (!entry.getValue().getTable().equals(key.getTable())) continue;
            old = entry.getValue();
            it.remove();
            break;
        }
        if (this.incompleteKeys.contains(mapKey = DefaultRelations.key(key.getTable(), key.getName()))) {
            return;
        }
        this.primaryKeys.put(mapKey, key);
        this.keys.put(mapKey, key);
        this.uniqueKeys.remove(mapKey);
        if (old != null) {
            this.uniqueKeys.put(mapKey, old);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Overriding primary key", (Object)("Table : " + String.valueOf(key.getTable()) + ", previous key : " + (old == null ? "none" : old.getName()) + ", new key : " + key.getName()));
        }
    }

    private UniqueKeyDefinition getUniqueKey(String keyName, TableDefinition table, ColumnDefinition column, boolean isPK, boolean enforced) {
        Key key = DefaultRelations.key(table, keyName);
        UniqueKeyDefinition result = this.keys.get(key);
        if (result == null) {
            result = new DefaultUniqueKeyDefinition(column.getSchema(), keyName, table, isPK, enforced);
            this.keys.put(key, result);
            if (isPK) {
                this.primaryKeys.put(key, result);
            } else {
                this.uniqueKeys.put(key, result);
            }
        }
        return result;
    }

    public void addForeignKey(String foreignKeyName, TableDefinition foreignKeyTable, ColumnDefinition foreignKeyColumn, String uniqueKeyName, TableDefinition uniqueKeyTable) {
        this.addForeignKey(foreignKeyName, foreignKeyTable, foreignKeyColumn, uniqueKeyName, uniqueKeyTable, true);
    }

    public void addForeignKey(String foreignKeyName, TableDefinition foreignKeyTable, ColumnDefinition foreignKeyColumn, String uniqueKeyName, TableDefinition uniqueKeyTable, boolean enforced) {
        UniqueKeyDefinition uk = this.keys.get(DefaultRelations.key(uniqueKeyTable, uniqueKeyName));
        Key key = DefaultRelations.key(foreignKeyTable, foreignKeyName);
        if (uk == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Ignoring foreign key", (Object)(uniqueKeyName + " (unique key unavailable)"));
            }
            if (foreignKeyTable != null) {
                this.incompleteKeys.add(key);
                this.foreignKeys.remove(key);
            }
            return;
        }
        this.addForeignKey(foreignKeyName, foreignKeyTable, foreignKeyColumn, uniqueKeyName, uniqueKeyTable, this.getNextUkColumn(key, uk), enforced);
    }

    private ColumnDefinition getNextUkColumn(Key key, UniqueKeyDefinition uk) {
        Integer index = this.nextUkColumnIndex.get(key);
        if (index == null) {
            index = 0;
            this.nextUkColumnIndex.put(key, index);
        } else {
            index = index + 1;
            this.nextUkColumnIndex.put(key, index);
        }
        return index < uk.getKeyColumns().size() ? uk.getKeyColumns().get(index) : null;
    }

    public void addForeignKey(String foreignKeyName, TableDefinition foreignKeyTable, ColumnDefinition foreignKeyColumn, String uniqueKeyName, TableDefinition uniqueKeyTable, ColumnDefinition uniqueKeyColumn, boolean enforced) {
        UniqueKeyDefinition uniqueKey;
        ForeignKeyDefinition foreignKey;
        Key key = DefaultRelations.key(foreignKeyTable, foreignKeyName);
        if (foreignKeyColumn == null || uniqueKeyColumn == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Ignoring foreign key", (Object)(String.valueOf(foreignKeyColumn) + " referencing " + String.valueOf(uniqueKeyColumn) + " (column unavailable)"));
            }
            if (foreignKeyTable != null) {
                this.incompleteKeys.add(key);
                this.foreignKeys.remove(key);
            }
            return;
        }
        if (this.incompleteKeys.contains(key)) {
            return;
        }
        if (uniqueKeyTable == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Ignoring foreign key", (Object)(foreignKeyName + " (" + String.valueOf(foreignKeyColumn) + ") referencing " + uniqueKeyName + " (" + String.valueOf(uniqueKeyColumn) + ") references a schema out of scope for jooq-meta: " + String.valueOf(uniqueKeyTable)));
            }
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Adding foreign key", (Object)(foreignKeyName + " (" + String.valueOf(foreignKeyColumn) + ") referencing " + uniqueKeyName + " (" + String.valueOf(uniqueKeyColumn) + ")"));
        }
        if ((foreignKey = this.foreignKeys.get(key)) == null && (uniqueKey = this.keys.get(DefaultRelations.key(uniqueKeyTable, uniqueKeyName))) != null) {
            foreignKey = new DefaultForeignKeyDefinition(foreignKeyColumn.getSchema(), foreignKeyName, (TableDefinition)foreignKeyColumn.getContainer(), uniqueKey, enforced);
            this.foreignKeys.put(key, foreignKey);
            uniqueKey.getForeignKeys().add(foreignKey);
        }
        if (foreignKey != null) {
            foreignKey.getKeyColumns().add(foreignKeyColumn);
            foreignKey.getReferencedColumns().add(uniqueKeyColumn);
        }
    }

    public void addCheckConstraint(TableDefinition table, CheckConstraintDefinition constraint) {
        this.checkConstraints.put(DefaultRelations.key(table, constraint.getName()), constraint);
    }

    @Override
    public UniqueKeyDefinition getPrimaryKey(ColumnDefinition column) {
        if (this.primaryKeysByColumn == null) {
            this.primaryKeysByColumn = new LinkedHashMap<ColumnDefinition, UniqueKeyDefinition>();
            for (UniqueKeyDefinition primaryKey : this.primaryKeys.values()) {
                for (ColumnDefinition keyColumn : primaryKey.getKeyColumns()) {
                    this.primaryKeysByColumn.put(keyColumn, primaryKey);
                }
            }
        }
        return this.primaryKeysByColumn.get(column);
    }

    @Override
    public List<UniqueKeyDefinition> getUniqueKeys(ColumnDefinition column) {
        if (this.uniqueKeysByColumn == null) {
            this.uniqueKeysByColumn = new LinkedHashMap<ColumnDefinition, List<UniqueKeyDefinition>>();
            for (UniqueKeyDefinition uniqueKey : this.uniqueKeys.values()) {
                for (ColumnDefinition keyColumn : uniqueKey.getKeyColumns()) {
                    this.uniqueKeysByColumn.computeIfAbsent(keyColumn, c -> new ArrayList()).add(uniqueKey);
                }
            }
            this.uniqueKeysByColumn.forEach((t, l) -> t.getDatabase().sort(l));
        }
        return DefaultRelations.nonNull(this.uniqueKeysByColumn, column);
    }

    @Override
    public List<UniqueKeyDefinition> getUniqueKeys(TableDefinition table) {
        if (this.uniqueKeysByTable == null) {
            this.uniqueKeysByTable = DefaultRelations.initByTable(this.uniqueKeys);
        }
        return DefaultRelations.nonNull(this.uniqueKeysByTable, table);
    }

    @Override
    public List<UniqueKeyDefinition> getUniqueKeys(SchemaDefinition schema) {
        LinkedHashSet<UniqueKeyDefinition> result = new LinkedHashSet<UniqueKeyDefinition>();
        for (TableDefinition table : schema.getDatabase().getTables(schema)) {
            result.addAll(this.getUniqueKeys(table));
        }
        return DefaultRelations.sort(new ArrayList(result));
    }

    @Override
    public List<UniqueKeyDefinition> getUniqueKeys() {
        return DefaultRelations.sort(new ArrayList<UniqueKeyDefinition>(this.uniqueKeys.values()));
    }

    @Override
    public List<UniqueKeyDefinition> getKeys(ColumnDefinition column) {
        if (this.keysByColumn == null) {
            this.keysByColumn = new LinkedHashMap<ColumnDefinition, List<UniqueKeyDefinition>>();
            for (UniqueKeyDefinition uniqueKey : this.keys.values()) {
                for (ColumnDefinition keyColumn : uniqueKey.getKeyColumns()) {
                    this.keysByColumn.computeIfAbsent(keyColumn, c -> new ArrayList()).add(uniqueKey);
                }
            }
            this.keysByColumn.forEach((t, l) -> t.getDatabase().sort(l));
        }
        return DefaultRelations.nonNull(this.keysByColumn, column);
    }

    @Override
    public List<UniqueKeyDefinition> getKeys(TableDefinition table) {
        if (this.keysByTable == null) {
            this.keysByTable = DefaultRelations.initByTable(this.keys);
        }
        return DefaultRelations.nonNull(this.keysByTable, table);
    }

    @Override
    public List<UniqueKeyDefinition> getKeys(SchemaDefinition schema) {
        LinkedHashSet<UniqueKeyDefinition> result = new LinkedHashSet<UniqueKeyDefinition>();
        for (TableDefinition table : schema.getDatabase().getTables(schema)) {
            result.addAll(this.getKeys(table));
        }
        return DefaultRelations.sort(new ArrayList(result));
    }

    @Override
    public List<UniqueKeyDefinition> getKeys() {
        return DefaultRelations.sort(new ArrayList<UniqueKeyDefinition>(this.keys.values()));
    }

    @Override
    public List<ForeignKeyDefinition> getForeignKeys(ColumnDefinition column) {
        if (this.foreignKeysByColumn == null) {
            this.foreignKeysByColumn = new LinkedHashMap<ColumnDefinition, List<ForeignKeyDefinition>>();
            for (ForeignKeyDefinition foreignKey : this.foreignKeys.values()) {
                for (ColumnDefinition keyColumn : foreignKey.getKeyColumns()) {
                    this.foreignKeysByColumn.computeIfAbsent(keyColumn, c -> new ArrayList()).add(foreignKey);
                }
            }
            this.foreignKeysByColumn.forEach((t, l) -> t.getDatabase().sort(l));
        }
        return DefaultRelations.nonNull(this.foreignKeysByColumn, column);
    }

    @Override
    public List<ForeignKeyDefinition> getForeignKeys(TableDefinition table) {
        if (this.foreignKeysByTable == null) {
            this.foreignKeysByTable = DefaultRelations.initByTable(this.foreignKeys);
        }
        return DefaultRelations.nonNull(this.foreignKeysByTable, table);
    }

    @Override
    public List<CheckConstraintDefinition> getCheckConstraints(TableDefinition table) {
        if (this.checkConstraintsByTable == null) {
            this.checkConstraintsByTable = DefaultRelations.initByTable(this.checkConstraints);
        }
        return DefaultRelations.nonNull(this.checkConstraintsByTable, table);
    }

    private static <D extends Definition> Map<TableDefinition, List<D>> initByTable(Map<Key, D> map) {
        LinkedHashMap result = new LinkedHashMap();
        map.forEach((k, v) -> result.computeIfAbsent(k.table, t -> new ArrayList()).add(v));
        result.forEach((t, l) -> t.getDatabase().sort(l));
        return result;
    }

    private static <K extends Definition, V extends Definition> List<V> nonNull(Map<K, List<V>> map, K key) {
        List<V> list = map.get(key);
        return list != null ? list : Collections.emptyList();
    }

    private static <D extends Definition> List<D> sort(List<D> list) {
        return list.isEmpty() ? list : ((Definition)list.get(0)).getDatabase().sort(list);
    }

    private static Key key(TableDefinition definition, String keyName) {
        return new Key(definition, keyName);
    }

    private record Key(TableDefinition table, String keyName) {
    }
}

