/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.meta.firebird;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.DataType;
import org.jooq.Field;
import org.jooq.GroupField;
import org.jooq.OrderField;
import org.jooq.Record;
import org.jooq.Record12;
import org.jooq.Record4;
import org.jooq.Record6;
import org.jooq.Result;
import org.jooq.ResultQuery;
import org.jooq.SQLDialect;
import org.jooq.Select;
import org.jooq.SelectField;
import org.jooq.SortOrder;
import org.jooq.TableLike;
import org.jooq.TableOptions;
import org.jooq.impl.DSL;
import org.jooq.impl.SQLDataType;
import org.jooq.meta.AbstractDatabase;
import org.jooq.meta.AbstractIndexDefinition;
import org.jooq.meta.ArrayDefinition;
import org.jooq.meta.CatalogDefinition;
import org.jooq.meta.Database;
import org.jooq.meta.DefaultCheckConstraintDefinition;
import org.jooq.meta.DefaultDataTypeDefinition;
import org.jooq.meta.DefaultDomainDefinition;
import org.jooq.meta.DefaultIndexColumnDefinition;
import org.jooq.meta.DefaultRelations;
import org.jooq.meta.DefaultSequenceDefinition;
import org.jooq.meta.DomainDefinition;
import org.jooq.meta.EnumDefinition;
import org.jooq.meta.IndexColumnDefinition;
import org.jooq.meta.IndexDefinition;
import org.jooq.meta.PackageDefinition;
import org.jooq.meta.ResultQueryDatabase;
import org.jooq.meta.RoutineDefinition;
import org.jooq.meta.SchemaDefinition;
import org.jooq.meta.SequenceDefinition;
import org.jooq.meta.TableDefinition;
import org.jooq.meta.UDTDefinition;
import org.jooq.meta.XMLSchemaCollectionDefinition;
import org.jooq.meta.firebird.FirebirdRoutineDefinition;
import org.jooq.meta.firebird.FirebirdTableDefinition;
import org.jooq.meta.firebird.FirebirdTableValuedFunction;
import org.jooq.meta.firebird.rdb.Tables;
import org.jooq.meta.firebird.rdb.tables.Rdb$checkConstraints;
import org.jooq.meta.firebird.rdb.tables.Rdb$fields;
import org.jooq.meta.firebird.rdb.tables.Rdb$functionArguments;
import org.jooq.meta.firebird.rdb.tables.Rdb$functions;
import org.jooq.meta.firebird.rdb.tables.Rdb$indexSegments;
import org.jooq.meta.firebird.rdb.tables.Rdb$indices;
import org.jooq.meta.firebird.rdb.tables.Rdb$procedures;
import org.jooq.meta.firebird.rdb.tables.Rdb$refConstraints;
import org.jooq.meta.firebird.rdb.tables.Rdb$relationConstraints;
import org.jooq.meta.firebird.rdb.tables.Rdb$triggers;
import org.jooq.meta.jaxb.SchemaMappingType;
import org.jooq.tools.StringUtils;
import org.jooq.util.firebird.FirebirdDataType;

public class FirebirdDatabase
extends AbstractDatabase
implements ResultQueryDatabase {
    private Boolean is30;

    public FirebirdDatabase() {
        SchemaMappingType schema = new SchemaMappingType();
        schema.setInputSchema("");
        schema.setOutputSchema("");
        ArrayList<SchemaMappingType> schemata = new ArrayList<SchemaMappingType>();
        schemata.add(schema);
        this.setConfiguredSchemata(schemata);
    }

    @Override
    protected void loadPrimaryKeys(DefaultRelations r) throws SQLException {
        for (Record record : this.primaryKeys(Collections.emptyList())) {
            String tableName = (String)record.get(Tables.RDB$RELATION_CONSTRAINTS.RDB$RELATION_NAME);
            String fieldName = (String)record.get(Tables.RDB$INDEX_SEGMENTS.RDB$FIELD_NAME);
            String key = (String)record.get(Tables.RDB$RELATION_CONSTRAINTS.RDB$CONSTRAINT_NAME);
            TableDefinition td = this.getTable(this.getSchemata().get(0), tableName);
            if (td == null) continue;
            r.addPrimaryKey(key, td, td.getColumn(fieldName));
        }
    }

    @Override
    protected void loadUniqueKeys(DefaultRelations r) throws SQLException {
        for (Record record : this.uniqueKeys(Collections.emptyList())) {
            String tableName = (String)record.get(Tables.RDB$RELATION_CONSTRAINTS.RDB$RELATION_NAME);
            String fieldName = (String)record.get(Tables.RDB$INDEX_SEGMENTS.RDB$FIELD_NAME);
            String key = (String)record.get(Tables.RDB$RELATION_CONSTRAINTS.RDB$CONSTRAINT_NAME);
            TableDefinition td = this.getTable(this.getSchemata().get(0), tableName);
            if (td == null) continue;
            r.addUniqueKey(key, td, td.getColumn(fieldName));
        }
    }

    @Override
    public ResultQuery<Record6<String, String, String, String, String, Integer>> primaryKeys(List<String> schemas) {
        return this.keys("PRIMARY KEY");
    }

    @Override
    public ResultQuery<Record6<String, String, String, String, String, Integer>> uniqueKeys(List<String> schemas) {
        return this.keys("UNIQUE");
    }

    private ResultQuery<Record6<String, String, String, String, String, Integer>> keys(String constraintType) {
        return this.create().select((SelectField)DSL.inline(null, (DataType)SQLDataType.VARCHAR).as("catalog"), (SelectField)DSL.inline(null, (DataType)SQLDataType.VARCHAR).as("schema"), (SelectField)Tables.RDB$RELATION_CONSTRAINTS.RDB$RELATION_NAME.trim().as(Tables.RDB$RELATION_CONSTRAINTS.RDB$RELATION_NAME), (SelectField)Tables.RDB$RELATION_CONSTRAINTS.RDB$CONSTRAINT_NAME.trim().as(Tables.RDB$RELATION_CONSTRAINTS.RDB$CONSTRAINT_NAME), (SelectField)Tables.RDB$INDEX_SEGMENTS.RDB$FIELD_NAME.trim().as(Tables.RDB$INDEX_SEGMENTS.RDB$FIELD_NAME), (SelectField)Tables.RDB$INDEX_SEGMENTS.RDB$FIELD_POSITION.coerce(SQLDataType.INTEGER)).from((TableLike)Tables.RDB$RELATION_CONSTRAINTS).join((TableLike)Tables.RDB$INDEX_SEGMENTS).on(Tables.RDB$INDEX_SEGMENTS.RDB$INDEX_NAME.eq(Tables.RDB$RELATION_CONSTRAINTS.RDB$INDEX_NAME)).where(Tables.RDB$RELATION_CONSTRAINTS.RDB$CONSTRAINT_TYPE.eq((Field)DSL.inline((String)constraintType))).orderBy((OrderField)Tables.RDB$RELATION_CONSTRAINTS.RDB$CONSTRAINT_NAME.asc(), (OrderField)Tables.RDB$INDEX_SEGMENTS.RDB$FIELD_POSITION.asc());
    }

    @Override
    protected void loadForeignKeys(DefaultRelations relations2) throws SQLException {
        Rdb$relationConstraints pk = Tables.RDB$RELATION_CONSTRAINTS.as("pk");
        Rdb$relationConstraints fk = Tables.RDB$RELATION_CONSTRAINTS.as("fk");
        Rdb$refConstraints rc = Tables.RDB$REF_CONSTRAINTS.as("rc");
        Rdb$indexSegments isp = Tables.RDB$INDEX_SEGMENTS.as("isp");
        Rdb$indexSegments isf = Tables.RDB$INDEX_SEGMENTS.as("isf");
        for (Record record : this.create().selectDistinct((SelectField)fk.RDB$CONSTRAINT_NAME.trim().as("fk"), (SelectField)fk.RDB$RELATION_NAME.trim().as("fkTable"), (SelectField)isf.RDB$FIELD_NAME.trim().as("fkField"), (SelectField)pk.RDB$CONSTRAINT_NAME.trim().as("pk"), (SelectField)pk.RDB$RELATION_NAME.trim().as("pkTable")).from((TableLike)fk).join((TableLike)rc).on(fk.RDB$CONSTRAINT_NAME.eq(rc.RDB$CONSTRAINT_NAME)).join((TableLike)pk).on(pk.RDB$CONSTRAINT_NAME.eq(rc.RDB$CONST_NAME_UQ)).join((TableLike)isp).on(isp.RDB$INDEX_NAME.eq(pk.RDB$INDEX_NAME)).join((TableLike)isf).on(isf.RDB$INDEX_NAME.eq(fk.RDB$INDEX_NAME)).where(isp.RDB$FIELD_POSITION.eq(isf.RDB$FIELD_POSITION)).orderBy((OrderField)fk.RDB$CONSTRAINT_NAME.asc(), (OrderField)isf.RDB$FIELD_POSITION.asc()).fetch()) {
            String pkName = (String)record.get("pk", String.class);
            String pkTable = (String)record.get("pkTable", String.class);
            String fkName = (String)record.get("fk", String.class);
            String fkTable = (String)record.get("fkTable", String.class);
            String fkField = (String)record.get("fkField", String.class);
            TableDefinition foreignKeyTable = this.getTable(this.getSchemata().get(0), fkTable, true);
            TableDefinition primaryKeyTable = this.getTable(this.getSchemata().get(0), pkTable, true);
            if (primaryKeyTable == null || foreignKeyTable == null) continue;
            relations2.addForeignKey(fkName, foreignKeyTable, foreignKeyTable.getColumn(fkField), pkName, primaryKeyTable);
        }
    }

    @Override
    protected void loadCheckConstraints(DefaultRelations relations2) throws SQLException {
        Rdb$relationConstraints r = Tables.RDB$RELATION_CONSTRAINTS.as("r");
        Rdb$checkConstraints c = Tables.RDB$CHECK_CONSTRAINTS.as("c");
        Rdb$triggers t = Tables.RDB$TRIGGERS.as("t");
        for (Record record : this.create().select((SelectField)r.RDB$RELATION_NAME.trim().as(r.RDB$RELATION_NAME), (SelectField)r.RDB$CONSTRAINT_NAME.trim().as(r.RDB$CONSTRAINT_NAME), (SelectField)DSL.max((Field)t.RDB$TRIGGER_SOURCE.trim()).as(t.RDB$TRIGGER_SOURCE)).from((TableLike)r).join((TableLike)c).on(r.RDB$CONSTRAINT_NAME.eq(c.RDB$CONSTRAINT_NAME)).join((TableLike)t).on(c.RDB$TRIGGER_NAME.eq(t.RDB$TRIGGER_NAME)).where(r.RDB$CONSTRAINT_TYPE.eq((Field)DSL.inline((String)"CHECK"))).groupBy(new GroupField[]{r.RDB$RELATION_NAME, r.RDB$CONSTRAINT_NAME}).orderBy(r.RDB$RELATION_NAME, r.RDB$CONSTRAINT_NAME)) {
            SchemaDefinition schema = this.getSchemata().get(0);
            TableDefinition table = this.getTable(schema, (String)record.get(r.RDB$RELATION_NAME));
            if (table == null) continue;
            relations2.addCheckConstraint(table, new DefaultCheckConstraintDefinition(schema, table, (String)record.get(r.RDB$CONSTRAINT_NAME), (String)record.get(t.RDB$TRIGGER_SOURCE)));
        }
    }

    @Override
    protected List<IndexDefinition> getIndexes0() throws SQLException {
        ArrayList<IndexDefinition> result = new ArrayList<IndexDefinition>();
        Rdb$relationConstraints c = Tables.RDB$RELATION_CONSTRAINTS.as("c");
        Rdb$indices i = Tables.RDB$INDICES.as("i");
        final Rdb$indexSegments s = Tables.RDB$INDEX_SEGMENTS.as("s");
        Map indexes = this.create().select((SelectField)s.rdb$indices().RDB$RELATION_NAME.trim().as(i.RDB$RELATION_NAME), (SelectField)s.rdb$indices().RDB$INDEX_NAME.trim().as(i.RDB$INDEX_NAME), s.rdb$indices().RDB$UNIQUE_FLAG, (SelectField)s.RDB$FIELD_NAME.trim().as(s.RDB$FIELD_NAME), s.RDB$FIELD_POSITION).from((TableLike)s).where(s.rdb$indices().RDB$INDEX_NAME.notIn((Select)DSL.select(c.RDB$CONSTRAINT_NAME).from((TableLike)c))).orderBy(s.rdb$indices().RDB$RELATION_NAME, s.rdb$indices().RDB$INDEX_NAME, s.RDB$FIELD_POSITION).fetchGroups(new Field[]{i.RDB$RELATION_NAME, i.RDB$INDEX_NAME, i.RDB$UNIQUE_FLAG}, new Field[]{s.RDB$FIELD_NAME, s.RDB$FIELD_POSITION});
        block0: for (Map.Entry entry : indexes.entrySet()) {
            Record index = (Record)entry.getKey();
            final Result columns = (Result)entry.getValue();
            SchemaDefinition schema = this.getSchemata().get(0);
            String indexName = (String)index.get(i.RDB$INDEX_NAME);
            String tableName = (String)index.get(i.RDB$RELATION_NAME);
            final TableDefinition table = this.getTable(schema, tableName);
            if (table == null) continue;
            boolean unique = (Boolean)index.get(i.RDB$UNIQUE_FLAG, Boolean.TYPE);
            for (Record column : columns) {
                if (table.getColumn((String)column.get(s.RDB$FIELD_NAME)) != null) continue;
                continue block0;
            }
            result.add(new AbstractIndexDefinition(schema, indexName, table, unique){
                List<IndexColumnDefinition> indexColumns;
                {
                    super(schema, name, table2, unique);
                    this.indexColumns = new ArrayList<IndexColumnDefinition>();
                    for (Record column : columns) {
                        this.indexColumns.add(new DefaultIndexColumnDefinition(this, table.getColumn((String)column.get(s.RDB$FIELD_NAME)), SortOrder.ASC, (Integer)column.get(s.RDB$FIELD_POSITION, Integer.TYPE)));
                    }
                }

                @Override
                protected List<IndexColumnDefinition> getIndexColumns0() {
                    return this.indexColumns;
                }
            });
        }
        return result;
    }

    @Override
    protected List<CatalogDefinition> getCatalogs0() throws SQLException {
        ArrayList<CatalogDefinition> result = new ArrayList<CatalogDefinition>();
        result.add(new CatalogDefinition((Database)this, "", ""));
        return result;
    }

    @Override
    protected List<SchemaDefinition> getSchemata0() throws SQLException {
        ArrayList<SchemaDefinition> result = new ArrayList<SchemaDefinition>();
        result.add(new SchemaDefinition((Database)this, "", ""));
        return result;
    }

    @Override
    public ResultQuery<Record4<String, String, String, String>> sources(List<String> schemas) {
        return this.create().select((SelectField)DSL.inline(null, (DataType)SQLDataType.VARCHAR).as("catalog"), (SelectField)DSL.inline(null, (DataType)SQLDataType.VARCHAR).as("schema"), (SelectField)Tables.RDB$RELATIONS.RDB$RELATION_NAME.trim(), (SelectField)Tables.RDB$RELATIONS.RDB$VIEW_SOURCE.trim()).from((TableLike)Tables.RDB$RELATIONS).orderBy((OrderField)Tables.RDB$RELATIONS.RDB$RELATION_NAME.trim());
    }

    @Override
    public ResultQuery<Record12<String, String, String, String, Integer, Integer, Long, Long, BigDecimal, BigDecimal, Boolean, Long>> sequences(List<String> schemas) {
        return this.create().select((SelectField)DSL.inline(null, (DataType)SQLDataType.VARCHAR).as("catalog"), (SelectField)DSL.inline(null, (DataType)SQLDataType.VARCHAR).as("schema"), (SelectField)DSL.trim(Tables.RDB$GENERATORS.RDB$GENERATOR_NAME).as(Tables.RDB$GENERATORS.RDB$GENERATOR_NAME), (SelectField)DSL.inline((String)"BIGINT").as("type_name"), (SelectField)DSL.inline(null, (DataType)SQLDataType.INTEGER).as("numeric_precision"), (SelectField)DSL.inline(null, (DataType)SQLDataType.INTEGER).as("numeric_scale"), (SelectField)(this.is30() ? DSL.nullif(Tables.RDB$GENERATORS.RDB$INITIAL_VALUE, (Field)DSL.inline((long)0L)) : DSL.inline((long)0L)).as(Tables.RDB$GENERATORS.RDB$INITIAL_VALUE), (SelectField)(this.is30() ? DSL.nullif(Tables.RDB$GENERATORS.RDB$GENERATOR_INCREMENT, (Field)DSL.inline((int)1)) : DSL.inline((int)1)).coerce(SQLDataType.BIGINT).as(Tables.RDB$GENERATORS.RDB$GENERATOR_INCREMENT), (SelectField)DSL.inline(null, (DataType)SQLDataType.NUMERIC).as("min_value"), (SelectField)DSL.inline(null, (DataType)SQLDataType.NUMERIC).as("max_value"), (SelectField)DSL.inline(null, (DataType)SQLDataType.BOOLEAN).as("cycle"), (SelectField)DSL.inline(null, (DataType)SQLDataType.BIGINT).as("cache")).from((TableLike)Tables.RDB$GENERATORS).where(this.getIncludeSystemSequences() || !this.is30() ? DSL.noCondition() : Tables.RDB$GENERATORS.RDB$GENERATOR_NAME.notIn((Select)DSL.select(Tables.RDB$RELATION_FIELDS.RDB$GENERATOR_NAME).from((TableLike)Tables.RDB$RELATION_FIELDS).where(Tables.RDB$RELATION_FIELDS.RDB$GENERATOR_NAME.isNotNull()).and(Tables.RDB$RELATION_FIELDS.RDB$IDENTITY_TYPE.eq((Field)DSL.inline((short)1))))).orderBy(Tables.RDB$GENERATORS.RDB$GENERATOR_NAME);
    }

    @Override
    protected List<SequenceDefinition> getSequences0() throws SQLException {
        ArrayList<SequenceDefinition> result = new ArrayList<SequenceDefinition>();
        for (Record record : this.sequences(this.getInputSchemata())) {
            SchemaDefinition schema = this.getSchemata().get(0);
            DefaultDataTypeDefinition type = new DefaultDataTypeDefinition(this, schema, FirebirdDataType.BIGINT.getTypeName());
            result.add(new DefaultSequenceDefinition(schema, (String)record.get(Tables.RDB$GENERATORS.RDB$GENERATOR_NAME), type, null, (Number)record.get(Tables.RDB$GENERATORS.RDB$INITIAL_VALUE), (Number)record.get(Tables.RDB$GENERATORS.RDB$GENERATOR_INCREMENT), null, null, false, null));
        }
        return result;
    }

    @Override
    protected List<TableDefinition> getTables0() throws SQLException {
        ArrayList<TableDefinition> result = new ArrayList<TableDefinition>();
        for (Record4 record : this.create().select((SelectField)Tables.RDB$RELATIONS.RDB$RELATION_NAME.trim(), (SelectField)Tables.RDB$RELATIONS.RDB$DESCRIPTION.trim(), (SelectField)DSL.when((Condition)Tables.RDB$RELATIONS.RDB$RELATION_TYPE.eq((Field)DSL.inline((short)1)), (Field)DSL.inline((String)TableOptions.TableType.VIEW.name())).else_((Field)DSL.inline((String)TableOptions.TableType.TABLE.name())).trim().as("table_type"), (SelectField)DSL.when((Condition)Tables.RDB$RELATIONS.RDB$VIEW_SOURCE.lower().like((Field)DSL.inline((String)"create%")), (Field)Tables.RDB$RELATIONS.RDB$VIEW_SOURCE.trim()).else_(DSL.inline((String)"create view \"").concat(new Field[]{Tables.RDB$RELATIONS.RDB$RELATION_NAME.trim()}).concat(new String[]{"\" as "}).concat(new Field[]{Tables.RDB$RELATIONS.RDB$VIEW_SOURCE})).as("view_source")).from((TableLike)Tables.RDB$RELATIONS).unionAll((Select)DSL.select((SelectField)Tables.RDB$PROCEDURES.RDB$PROCEDURE_NAME.trim(), (SelectField)DSL.inline((String)""), (SelectField)DSL.inline((String)TableOptions.TableType.FUNCTION.name()).trim(), (SelectField)DSL.inline((String)"")).from((TableLike)Tables.RDB$PROCEDURES).where(Tables.RDB$PROCEDURES.RDB$PROCEDURE_TYPE.eq((Object)1)).and((Condition)(this.tableValuedFunctions() ? DSL.noCondition() : DSL.falseCondition()))).orderBy(new int[]{1})) {
            TableOptions.TableType tableType = (TableOptions.TableType)record.get("table_type", TableOptions.TableType.class);
            if (TableOptions.TableType.FUNCTION == tableType) {
                result.add(new FirebirdTableValuedFunction(this.getSchemata().get(0), (String)record.value1(), ""));
                continue;
            }
            result.add(new FirebirdTableDefinition(this.getSchemata().get(0), (String)record.value1(), (String)record.value2(), tableType, (String)record.value4()));
        }
        return result;
    }

    @Override
    protected List<RoutineDefinition> getRoutines0() throws SQLException {
        Rdb$procedures p = Tables.RDB$PROCEDURES.as("p");
        Rdb$functions fu = Tables.RDB$FUNCTIONS.as("fu");
        Rdb$functionArguments fa = Tables.RDB$FUNCTION_ARGUMENTS.as("fa");
        Rdb$fields fi = Tables.RDB$FIELDS.as("fi");
        return (List)this.create().select((SelectField)p.RDB$PROCEDURE_NAME.trim(), (SelectField)DSL.inline(null, (DataType)SQLDataType.VARCHAR).as("t"), (SelectField)DSL.inline(null, (DataType)SQLDataType.SMALLINT).as("p"), (SelectField)DSL.inline(null, (DataType)SQLDataType.SMALLINT).as("s")).from((TableLike)p).where(p.RDB$PROCEDURE_TYPE.eq((Object)2)).union((Select)(this.is30() ? DSL.select((SelectField)fu.RDB$FUNCTION_NAME.trim(), (SelectField)FirebirdDatabase.FIELD_TYPE(fi).as("t"), (SelectField)DSL.coalesce(FirebirdDatabase.CHARACTER_LENGTH(fi), (Field[])new Field[]{fi.RDB$FIELD_PRECISION}).as("p"), (SelectField)FirebirdDatabase.FIELD_SCALE(fi).as("s")).from((TableLike)fu).leftAntiJoin((TableLike)p).on(fu.RDB$FUNCTION_NAME.eq(p.RDB$PROCEDURE_NAME)).join((TableLike)fa).on(fu.RDB$FUNCTION_NAME.eq(fa.RDB$FUNCTION_NAME)).leftOuterJoin((TableLike)fi).on(fa.RDB$FIELD_SOURCE.eq(fi.RDB$FIELD_NAME)).where(fa.RDB$ARGUMENT_POSITION.eq((Field)DSL.inline((short)0))) : DSL.select((SelectField)DSL.inline((String)""), (SelectField)DSL.inline((String)""), (SelectField)DSL.inline((short)0), (SelectField)DSL.inline((short)0)).where((Condition)DSL.falseCondition()))).orderBy(new int[]{1}).collect(Collectors.mapping(r -> new FirebirdRoutineDefinition(this.getSchemata().get(0), (String)r.get(0, String.class), (String)r.get(1, String.class), (Number)r.get(2, Integer.class), (Number)r.get(3, Integer.class)), Collectors.toList()));
    }

    @Override
    protected List<PackageDefinition> getPackages0() throws SQLException {
        ArrayList<PackageDefinition> result = new ArrayList<PackageDefinition>();
        return result;
    }

    @Override
    protected List<EnumDefinition> getEnums0() throws SQLException {
        ArrayList<EnumDefinition> result = new ArrayList<EnumDefinition>();
        return result;
    }

    @Override
    protected List<DomainDefinition> getDomains0() throws SQLException {
        ArrayList<DomainDefinition> result = new ArrayList<DomainDefinition>();
        Rdb$fields f = Tables.RDB$FIELDS;
        for (Record record : this.create().select((SelectField)DSL.trim(f.RDB$FIELD_NAME).as(f.RDB$FIELD_NAME), (SelectField)FirebirdDatabase.CHARACTER_LENGTH(f).as("CHAR_LEN"), f.RDB$FIELD_PRECISION, (SelectField)FirebirdDatabase.FIELD_SCALE(f).as("FIELD_SCALE"), (SelectField)FirebirdDatabase.FIELD_TYPE(f).as("FIELD_TYPE"), (SelectField)DSL.bitOr((Field)f.RDB$NULL_FLAG.nvl((Object)0), (Field)f.RDB$NULL_FLAG.nvl((Object)0)).as(f.RDB$NULL_FLAG), (SelectField)DSL.trim(f.RDB$VALIDATION_SOURCE).as(f.RDB$VALIDATION_SOURCE), (SelectField)DSL.trim(f.RDB$DEFAULT_SOURCE).as(f.RDB$DEFAULT_SOURCE)).from((TableLike)f).where((Condition)f.RDB$FIELD_NAME.notLike(DSL.any((Object[])new String[]{"RDB$%", "SEC$%", "MON$%"}))).orderBy(f.RDB$FIELD_NAME)) {
            SchemaDefinition schema = this.getSchemata().get(0);
            DefaultDataTypeDefinition baseType = new DefaultDataTypeDefinition((Database)this, schema, (String)record.get("FIELD_TYPE", String.class), (Number)record.get("CHAR_LEN", Short.TYPE), (Number)record.get(f.RDB$FIELD_PRECISION), (Number)record.get("FIELD_SCALE", Integer.class), (Boolean)((Short)record.get(f.RDB$NULL_FLAG) == 0 ? 1 : 0), record.get(f.RDB$DEFAULT_SOURCE) == null ? null : ((String)record.get(f.RDB$DEFAULT_SOURCE)).replaceAll("(?i:default )", ""));
            DefaultDomainDefinition domain = new DefaultDomainDefinition(schema, (String)record.get(f.RDB$FIELD_NAME), baseType);
            if (!StringUtils.isBlank((String)((String)record.get(f.RDB$VALIDATION_SOURCE)))) {
                domain.addCheckClause(((String)record.get(f.RDB$VALIDATION_SOURCE)).replaceAll("(?i:check )", ""));
            }
            result.add(domain);
        }
        return result;
    }

    @Override
    protected List<XMLSchemaCollectionDefinition> getXMLSchemaCollections0() throws SQLException {
        ArrayList<XMLSchemaCollectionDefinition> result = new ArrayList<XMLSchemaCollectionDefinition>();
        return result;
    }

    @Override
    protected List<UDTDefinition> getUDTs0() throws SQLException {
        ArrayList<UDTDefinition> result = new ArrayList<UDTDefinition>();
        return result;
    }

    @Override
    protected List<ArrayDefinition> getArrays0() throws SQLException {
        ArrayList<ArrayDefinition> result = new ArrayList<ArrayDefinition>();
        return result;
    }

    @Override
    protected DSLContext create0() {
        return DSL.using((Connection)this.getConnection(), (SQLDialect)SQLDialect.FIREBIRD);
    }

    static Field<String> FIELD_TYPE(Rdb$fields f) {
        return DSL.decode().value(f.RDB$FIELD_TYPE).when((Object)7, DSL.decode().when(f.RDB$FIELD_SUB_TYPE.eq((Object)1), (Object)"NUMERIC").when(f.RDB$FIELD_SUB_TYPE.eq((Object)0).and(f.RDB$FIELD_SCALE.lt((Object)0)), (Object)"NUMERIC").when(f.RDB$FIELD_SUB_TYPE.eq((Object)2), (Object)"DECIMAL").otherwise((Object)"SMALLINT")).when((Object)8, DSL.decode().when(f.RDB$FIELD_SUB_TYPE.eq((Object)1), (Object)"NUMERIC").when(f.RDB$FIELD_SUB_TYPE.eq((Object)0).and(f.RDB$FIELD_SCALE.lt((Object)0)), (Object)"NUMERIC").when(f.RDB$FIELD_SUB_TYPE.eq((Object)2), (Object)"DECIMAL").otherwise((Object)"INTEGER")).when((Object)9, (Object)"QUAD").when((Object)10, (Object)"FLOAT").when((Object)11, (Object)"D_FLOAT").when((Object)12, (Object)"DATE").when((Object)13, (Object)"TIME").when((Object)14, (Object)"CHAR").when((Object)16, DSL.decode().when(f.RDB$FIELD_SUB_TYPE.eq((Object)1), (Object)"NUMERIC").when(f.RDB$FIELD_SUB_TYPE.eq((Object)0).and(f.RDB$FIELD_SCALE.lt((Object)0)), (Object)"NUMERIC").when(f.RDB$FIELD_SUB_TYPE.eq((Object)2), (Object)"DECIMAL").otherwise((Object)"BIGINT")).when((Object)27, (Object)"DOUBLE").when((Object)35, (Object)"TIMESTAMP").when((Object)37, (Object)"VARCHAR").when((Object)40, (Object)"CSTRING").when((Object)261, DSL.decode().value(f.RDB$FIELD_SUB_TYPE).when((Object)0, (Object)"BLOB").when((Object)1, (Object)"BLOB SUB_TYPE TEXT").otherwise((Object)"BLOB")).otherwise((Object)"UNKNOWN");
    }

    static Field<Short> FIELD_SCALE(Rdb$fields f) {
        return f.RDB$FIELD_SCALE.neg();
    }

    static Field<Short> CHARACTER_LENGTH(Rdb$fields f) {
        return DSL.choose(f.RDB$FIELD_TYPE).when((Object)261, (Object)0).otherwise(f.RDB$CHARACTER_LENGTH);
    }

    boolean is30() {
        if (this.is30 == null) {
            this.is30 = this.configuredDialectIsNotFamilyAndSupports(Arrays.asList(SQLDialect.FIREBIRD), () -> this.exists(Tables.RDB$GENERATORS.RDB$INITIAL_VALUE));
        }
        return this.is30;
    }
}

