/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.meta.postgres;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jooq.CommonTableExpression;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.DataType;
import org.jooq.Field;
import org.jooq.Name;
import org.jooq.OrderField;
import org.jooq.QueryPart;
import org.jooq.Record;
import org.jooq.Record12;
import org.jooq.Record5;
import org.jooq.Record6;
import org.jooq.Records;
import org.jooq.Result;
import org.jooq.ResultQuery;
import org.jooq.Row1;
import org.jooq.Rows;
import org.jooq.SQLDialect;
import org.jooq.Select;
import org.jooq.SelectConditionStep;
import org.jooq.SelectField;
import org.jooq.SelectFieldOrAsterisk;
import org.jooq.SortOrder;
import org.jooq.Table;
import org.jooq.TableField;
import org.jooq.TableLike;
import org.jooq.TableOptions;
import org.jooq.WindowSpecification;
import org.jooq.conf.ParseUnknownFunctions;
import org.jooq.exception.DataAccessException;
import org.jooq.impl.DSL;
import org.jooq.impl.ParserException;
import org.jooq.impl.SQLDataType;
import org.jooq.meta.AbstractDatabase;
import org.jooq.meta.AbstractDefinition;
import org.jooq.meta.AbstractIndexDefinition;
import org.jooq.meta.ArrayDefinition;
import org.jooq.meta.CatalogDefinition;
import org.jooq.meta.ColumnDefinition;
import org.jooq.meta.Database;
import org.jooq.meta.DefaultCheckConstraintDefinition;
import org.jooq.meta.DefaultDataTypeDefinition;
import org.jooq.meta.DefaultDomainDefinition;
import org.jooq.meta.DefaultEnumDefinition;
import org.jooq.meta.DefaultIndexColumnDefinition;
import org.jooq.meta.DefaultRelations;
import org.jooq.meta.DefaultSequenceDefinition;
import org.jooq.meta.DomainDefinition;
import org.jooq.meta.EnumDefinition;
import org.jooq.meta.IndexColumnDefinition;
import org.jooq.meta.IndexDefinition;
import org.jooq.meta.PackageDefinition;
import org.jooq.meta.ResultQueryDatabase;
import org.jooq.meta.RoutineDefinition;
import org.jooq.meta.SchemaDefinition;
import org.jooq.meta.SequenceDefinition;
import org.jooq.meta.TableDefinition;
import org.jooq.meta.UDTDefinition;
import org.jooq.meta.postgres.PostgresMaterializedViewDefinition;
import org.jooq.meta.postgres.PostgresRoutineDefinition;
import org.jooq.meta.postgres.PostgresTableDefinition;
import org.jooq.meta.postgres.PostgresTableValuedFunction;
import org.jooq.meta.postgres.PostgresUDTDefinition;
import org.jooq.meta.postgres.information_schema.Tables;
import org.jooq.meta.postgres.information_schema.tables.CheckConstraints;
import org.jooq.meta.postgres.information_schema.tables.KeyColumnUsage;
import org.jooq.meta.postgres.information_schema.tables.Routines;
import org.jooq.meta.postgres.pg_catalog.tables.PgClass;
import org.jooq.meta.postgres.pg_catalog.tables.PgConstraint;
import org.jooq.meta.postgres.pg_catalog.tables.PgIndex;
import org.jooq.meta.postgres.pg_catalog.tables.PgInherits;
import org.jooq.meta.postgres.pg_catalog.tables.PgNamespace;
import org.jooq.meta.postgres.pg_catalog.tables.PgType;
import org.jooq.tools.JooqLogger;
import org.jooq.util.postgres.PostgresDSL;

public class PostgresDatabase
extends AbstractDatabase
implements ResultQueryDatabase {
    private static final JooqLogger log = JooqLogger.getLogger(PostgresDatabase.class);
    private Boolean is84;
    private Boolean is94;
    private Boolean is10;
    private Boolean is11;
    private Boolean is12;
    private Boolean canUseRoutines;
    private Boolean canCastToEnumType;
    private Boolean canCombineArrays;
    private Boolean canUseTupleInPredicates;

    @Override
    protected List<IndexDefinition> getIndexes0() throws SQLException {
        ArrayList<IndexDefinition> result = new ArrayList<IndexDefinition>();
        PgIndex i = org.jooq.meta.postgres.pg_catalog.Tables.PG_INDEX.as("i");
        PgClass trel = org.jooq.meta.postgres.pg_catalog.Tables.PG_CLASS.as("trel");
        PgConstraint c = org.jooq.meta.postgres.pg_catalog.Tables.PG_CONSTRAINT.as("c");
        block0: for (Record6 record : this.create().select(trel.pgNamespace().NSPNAME, trel.RELNAME, i.indexClass().RELNAME, i.INDISUNIQUE, (SelectField)DSL.array((Select)DSL.select((SelectField)DSL.field((String)"pg_get_indexdef({0}, k + 1, true)", String.class, (QueryPart[])new QueryPart[]{i.INDEXRELID})).from("generate_subscripts({0}, 1) as k", new QueryPart[]{i.INDKEY}).orderBy((OrderField)DSL.field((String)"k"))).as("columns"), (SelectField)DSL.field((String)"{0}::int[]", Integer[].class, (QueryPart[])new QueryPart[]{i.INDOPTION}).as("asc_or_desc")).from((TableLike)i).join((TableLike)trel).on(trel.OID.eq(i.INDRELID)).where(trel.pgNamespace().NSPNAME.in(this.getInputSchemata())).and(this.getIncludeSystemIndexes() ? DSL.noCondition() : DSL.row(trel.pgNamespace().NSPNAME, i.indexClass().RELNAME).notIn((Select)DSL.select(c.pgNamespace().NSPNAME, c.CONNAME).from((TableLike)c))).orderBy(new int[]{1, 2, 3})) {
            SchemaDefinition tableSchema = this.getSchema((String)record.get(trel.pgNamespace().NSPNAME));
            if (tableSchema == null) continue;
            String indexName = (String)record.get(i.indexClass().RELNAME);
            String tableName = (String)record.get(trel.RELNAME);
            final String[] columns = (String[])record.value5();
            final Integer[] options = (Integer[])record.value6();
            final TableDefinition table = this.getTable(tableSchema, tableName);
            if (table == null) continue;
            boolean unique = (Boolean)record.get(i.INDISUNIQUE);
            for (int k = 0; k < columns.length; ++k) {
                if (table.getColumn(columns[k]) == null && table.getColumn(columns[k] = this.tryParseColumnName(columns[k])) == null || k >= options.length) continue block0;
            }
            result.add(new AbstractIndexDefinition(tableSchema, indexName, table, unique){
                List<IndexColumnDefinition> indexColumns;
                {
                    super(schema, name, table2, unique);
                    this.indexColumns = new ArrayList<IndexColumnDefinition>();
                    for (int ordinal = 0; ordinal < columns.length; ++ordinal) {
                        ColumnDefinition column = table.getColumn(columns[ordinal]);
                        SortOrder order = (options[ordinal] & 1) == 1 ? SortOrder.DESC : SortOrder.ASC;
                        this.indexColumns.add(new DefaultIndexColumnDefinition(this, column, order, ordinal + 1));
                    }
                }

                @Override
                protected List<IndexColumnDefinition> getIndexColumns0() {
                    return this.indexColumns;
                }
            });
        }
        return result;
    }

    private String tryParseColumnName(String string) {
        try {
            return this.create().configuration().deriveSettings(s -> s.withParseUnknownFunctions(ParseUnknownFunctions.IGNORE)).dsl().parser().parseField(string).getName();
        }
        catch (ParserException e) {
            log.info((Object)"Parse error", (Object)("Error when parsing column name : " + string), (Throwable)e);
            return string;
        }
    }

    @Override
    protected void loadPrimaryKeys(DefaultRelations relations2) throws SQLException {
        for (Record record : this.primaryKeys(this.getInputSchemata())) {
            SchemaDefinition schema = this.getSchema((String)record.get(Tables.KEY_COLUMN_USAGE.TABLE_SCHEMA));
            String key = (String)record.get(Tables.KEY_COLUMN_USAGE.CONSTRAINT_NAME);
            String tableName = (String)record.get(Tables.KEY_COLUMN_USAGE.TABLE_NAME);
            String columnName = (String)record.get(Tables.KEY_COLUMN_USAGE.COLUMN_NAME);
            TableDefinition table = this.getTable(schema, tableName);
            if (table == null) continue;
            relations2.addPrimaryKey(key, table, table.getColumn(columnName));
        }
    }

    @Override
    protected void loadUniqueKeys(DefaultRelations relations2) throws SQLException {
        for (Record record : this.uniqueKeys(this.getInputSchemata())) {
            SchemaDefinition schema = this.getSchema((String)record.get(Tables.KEY_COLUMN_USAGE.TABLE_SCHEMA));
            String key = (String)record.get(Tables.KEY_COLUMN_USAGE.CONSTRAINT_NAME);
            String tableName = (String)record.get(Tables.KEY_COLUMN_USAGE.TABLE_NAME);
            String columnName = (String)record.get(Tables.KEY_COLUMN_USAGE.COLUMN_NAME);
            TableDefinition table = this.getTable(schema, tableName);
            if (table == null) continue;
            relations2.addUniqueKey(key, table, table.getColumn(columnName));
        }
    }

    @Override
    public ResultQuery<Record6<String, String, String, String, String, Integer>> primaryKeys(List<String> schemas) {
        return this.keys(schemas, (Field<String>)DSL.inline((String)"p"));
    }

    @Override
    public ResultQuery<Record6<String, String, String, String, String, Integer>> uniqueKeys(List<String> schemas) {
        return this.keys(schemas, (Field<String>)DSL.inline((String)"u"));
    }

    private ResultQuery<Record6<String, String, String, String, String, Integer>> keys(List<String> schemas, Field<String> constraintType) {
        KeyColumnUsage k = Tables.KEY_COLUMN_USAGE.as("k");
        PgConstraint c = org.jooq.meta.postgres.pg_catalog.Tables.PG_CONSTRAINT.as("c");
        return this.create().select(k.TABLE_CATALOG, k.TABLE_SCHEMA, k.TABLE_NAME, k.CONSTRAINT_NAME, k.COLUMN_NAME, k.ORDINAL_POSITION).from((TableLike)c).join((TableLike)k).on(k.TABLE_SCHEMA.eq(c.pgClass().pgNamespace().NSPNAME)).and(k.TABLE_NAME.eq(c.pgClass().RELNAME)).and(k.CONSTRAINT_SCHEMA.eq(c.pgNamespace().NSPNAME)).and(k.CONSTRAINT_NAME.eq(c.CONNAME)).where(c.CONTYPE.eq(constraintType)).and(c.pgNamespace().NSPNAME.in(schemas)).orderBy((OrderField)k.TABLE_SCHEMA.asc(), (OrderField)k.TABLE_NAME.asc(), (OrderField)k.CONSTRAINT_NAME.asc(), (OrderField)k.ORDINAL_POSITION.asc());
    }

    @Override
    protected void loadForeignKeys(DefaultRelations relations2) throws SQLException {
        Result result = this.create().fetch(this.getConnection().getMetaData().getExportedKeys(null, null, null)).sortAsc("key_seq").sortAsc("fk_name").sortAsc("fktable_name").sortAsc("fktable_schem");
        for (Record record : result) {
            SchemaDefinition foreignKeySchema = this.getSchema((String)record.get("fktable_schem", String.class));
            SchemaDefinition uniqueKeySchema = this.getSchema((String)record.get("pktable_schem", String.class));
            if (foreignKeySchema == null || uniqueKeySchema == null) continue;
            String foreignKey = (String)record.get("fk_name", String.class);
            String foreignKeyTableName = (String)record.get("fktable_name", String.class);
            String foreignKeyColumn = (String)record.get("fkcolumn_name", String.class);
            String uniqueKey = (String)record.get("pk_name", String.class);
            String uniqueKeyTableName = (String)record.get("pktable_name", String.class);
            String uniqueKeyColumn = (String)record.get("pkcolumn_name", String.class);
            TableDefinition foreignKeyTable = this.getTable(foreignKeySchema, foreignKeyTableName);
            TableDefinition uniqueKeyTable = this.getTable(uniqueKeySchema, uniqueKeyTableName);
            if (foreignKeyTable == null || uniqueKeyTable == null) continue;
            relations2.addForeignKey(foreignKey, foreignKeyTable, foreignKeyTable.getColumn(foreignKeyColumn), uniqueKey, uniqueKeyTable, uniqueKeyTable.getColumn(uniqueKeyColumn), true);
        }
    }

    @Override
    protected void loadCheckConstraints(DefaultRelations relations2) throws SQLException {
        CheckConstraints cc = Tables.CHECK_CONSTRAINTS.as("cc");
        PgConstraint pc = org.jooq.meta.postgres.pg_catalog.Tables.PG_CONSTRAINT.as("pc");
        for (Record record : this.create().select(pc.pgClass().pgNamespace().NSPNAME, pc.pgClass().RELNAME, (SelectField)pc.CONNAME.as(cc.CONSTRAINT_NAME), (SelectField)DSL.replace((Field)DSL.field((String)"pg_get_constraintdef({0}.oid)", (DataType)SQLDataType.VARCHAR, (QueryPart[])new QueryPart[]{pc}), (Field)DSL.inline((String)"CHECK "), (Field)DSL.inline((String)"")).as(cc.CHECK_CLAUSE)).from((TableLike)pc).where(pc.pgClass().pgNamespace().NSPNAME.in(this.getInputSchemata())).and(pc.CONTYPE.eq((Field)DSL.inline((String)"c"))).unionAll((Select)(this.getIncludeSystemCheckConstraints() ? DSL.select(pc.pgClass().pgNamespace().NSPNAME, pc.pgClass().RELNAME, cc.CONSTRAINT_NAME, cc.CHECK_CLAUSE).from((TableLike)pc).join((TableLike)cc).on(pc.CONNAME.eq(cc.CONSTRAINT_NAME)).and(pc.pgNamespace().NSPNAME.eq(cc.CONSTRAINT_NAME)).where(pc.pgNamespace().NSPNAME.in(this.getInputSchemata())).and(DSL.row(pc.pgClass().pgNamespace().NSPNAME, pc.pgClass().RELNAME, cc.CONSTRAINT_NAME).notIn((Select)DSL.select(pc.pgClass().pgNamespace().NSPNAME, pc.pgClass().RELNAME, pc.CONNAME).from((TableLike)pc).where(pc.CONTYPE.eq((Field)DSL.inline((String)"c"))))) : DSL.select((SelectField)DSL.inline((String)""), (SelectField)DSL.inline((String)""), (SelectField)DSL.inline((String)""), (SelectField)DSL.inline((String)"")).where((Condition)DSL.falseCondition()))).orderBy(new int[]{1, 2, 3})) {
            SchemaDefinition schema = this.getSchema((String)record.get(pc.pgClass().pgNamespace().NSPNAME));
            TableDefinition table = this.getTable(schema, (String)record.get(pc.pgClass().RELNAME));
            if (table == null) continue;
            relations2.addCheckConstraint(table, new DefaultCheckConstraintDefinition(schema, table, (String)record.get(cc.CONSTRAINT_NAME), (String)record.get(cc.CHECK_CLAUSE)));
        }
    }

    @Override
    protected List<TableDefinition> getTables0() throws SQLException {
        ArrayList<TableDefinition> result = new ArrayList<TableDefinition>();
        HashMap<Name, PostgresTableDefinition> map = new HashMap<Name, PostgresTableDefinition>();
        SelectConditionStep empty = DSL.select((SelectField)DSL.inline((String)""), (SelectField)DSL.inline((String)""), (SelectField)DSL.inline((String)""), (SelectField)DSL.inline((String)""), (SelectField)DSL.inline((String)""), (SelectField)DSL.inline((String)"")).where((Condition)DSL.falseCondition());
        block4: for (Record record : this.create().select(new SelectFieldOrAsterisk[0]).from((TableLike)DSL.select(Tables.TABLES.TABLE_SCHEMA, Tables.TABLES.TABLE_NAME, (SelectField)Tables.TABLES.TABLE_NAME.as("specific_name"), org.jooq.meta.postgres.pg_catalog.Tables.PG_DESCRIPTION.DESCRIPTION, (SelectField)DSL.when((Condition)Tables.TABLES.TABLE_TYPE.eq((Field)DSL.inline((String)"VIEW")), (Field)DSL.inline((String)TableOptions.TableType.VIEW.name())).else_((Field)DSL.inline((String)TableOptions.TableType.TABLE.name())).as("table_type"), Tables.VIEWS.VIEW_DEFINITION).from((TableLike)Tables.TABLES).join((TableLike)org.jooq.meta.postgres.pg_catalog.Tables.PG_NAMESPACE).on(Tables.TABLES.TABLE_SCHEMA.eq(org.jooq.meta.postgres.pg_catalog.Tables.PG_NAMESPACE.NSPNAME)).join((TableLike)org.jooq.meta.postgres.pg_catalog.Tables.PG_CLASS).on(org.jooq.meta.postgres.pg_catalog.Tables.PG_CLASS.RELNAME.eq(Tables.TABLES.TABLE_NAME)).and(org.jooq.meta.postgres.pg_catalog.Tables.PG_CLASS.RELNAMESPACE.eq(org.jooq.meta.postgres.pg_catalog.Tables.PG_NAMESPACE.OID)).leftJoin((TableLike)org.jooq.meta.postgres.pg_catalog.Tables.PG_DESCRIPTION).on(org.jooq.meta.postgres.pg_catalog.Tables.PG_DESCRIPTION.OBJOID.eq(org.jooq.meta.postgres.pg_catalog.Tables.PG_CLASS.OID)).and(org.jooq.meta.postgres.pg_catalog.Tables.PG_DESCRIPTION.OBJSUBID.eq((Object)0)).leftJoin((TableLike)Tables.VIEWS).on(Tables.TABLES.TABLE_SCHEMA.eq(Tables.VIEWS.TABLE_SCHEMA)).and(Tables.TABLES.TABLE_NAME.eq(Tables.VIEWS.TABLE_NAME)).where(Tables.TABLES.TABLE_SCHEMA.in(this.getInputSchemata())).and(this.canUseTupleInPredicates() ? DSL.row(Tables.TABLES.TABLE_SCHEMA, Tables.TABLES.TABLE_NAME).notIn((Select)DSL.select(org.jooq.meta.postgres.pg_catalog.Tables.PG_NAMESPACE.NSPNAME, org.jooq.meta.postgres.pg_catalog.Tables.PG_CLASS.RELNAME).from((TableLike)org.jooq.meta.postgres.pg_catalog.Tables.PG_CLASS).join((TableLike)org.jooq.meta.postgres.pg_catalog.Tables.PG_NAMESPACE).on(org.jooq.meta.postgres.pg_catalog.Tables.PG_CLASS.RELNAMESPACE.eq(org.jooq.meta.postgres.pg_catalog.Tables.PG_NAMESPACE.OID)).where(org.jooq.meta.postgres.pg_catalog.Tables.PG_CLASS.RELKIND.eq((Field)DSL.inline((String)"m")))) : DSL.noCondition()).unionAll((Select)DSL.select((SelectField)DSL.field((String)"{0}::varchar", (DataType)org.jooq.meta.postgres.pg_catalog.Tables.PG_NAMESPACE.NSPNAME.getDataType(), (QueryPart[])new QueryPart[]{org.jooq.meta.postgres.pg_catalog.Tables.PG_NAMESPACE.NSPNAME}), (SelectField)DSL.field((String)"{0}::varchar", (DataType)org.jooq.meta.postgres.pg_catalog.Tables.PG_CLASS.RELNAME.getDataType(), (QueryPart[])new QueryPart[]{org.jooq.meta.postgres.pg_catalog.Tables.PG_CLASS.RELNAME}), (SelectField)DSL.field((String)"{0}::varchar", (DataType)org.jooq.meta.postgres.pg_catalog.Tables.PG_CLASS.RELNAME.getDataType(), (QueryPart[])new QueryPart[]{org.jooq.meta.postgres.pg_catalog.Tables.PG_CLASS.RELNAME}), org.jooq.meta.postgres.pg_catalog.Tables.PG_DESCRIPTION.DESCRIPTION, (SelectField)DSL.inline((String)TableOptions.TableType.MATERIALIZED_VIEW.name()).as("table_type"), (SelectField)DSL.inline((String)"")).from((TableLike)org.jooq.meta.postgres.pg_catalog.Tables.PG_CLASS).join((TableLike)org.jooq.meta.postgres.pg_catalog.Tables.PG_NAMESPACE).on(org.jooq.meta.postgres.pg_catalog.Tables.PG_CLASS.RELNAMESPACE.eq(org.jooq.meta.postgres.pg_catalog.Tables.PG_NAMESPACE.OID)).leftOuterJoin((TableLike)org.jooq.meta.postgres.pg_catalog.Tables.PG_DESCRIPTION).on(org.jooq.meta.postgres.pg_catalog.Tables.PG_DESCRIPTION.OBJOID.eq(org.jooq.meta.postgres.pg_catalog.Tables.PG_CLASS.OID)).and(org.jooq.meta.postgres.pg_catalog.Tables.PG_DESCRIPTION.OBJSUBID.eq((Object)0)).where(org.jooq.meta.postgres.pg_catalog.Tables.PG_NAMESPACE.NSPNAME.in(this.getInputSchemata())).and(org.jooq.meta.postgres.pg_catalog.Tables.PG_CLASS.RELKIND.eq((Field)DSL.inline((String)"m")))).unionAll((Select)(this.tableValuedFunctions() ? DSL.select(Tables.ROUTINES.ROUTINE_SCHEMA, Tables.ROUTINES.ROUTINE_NAME, Tables.ROUTINES.SPECIFIC_NAME, (SelectField)DSL.inline((String)""), (SelectField)DSL.inline((String)TableOptions.TableType.FUNCTION.name()).as("table_type"), (SelectField)DSL.inline((String)"")).from((TableLike)Tables.ROUTINES).join((TableLike)org.jooq.meta.postgres.pg_catalog.Tables.PG_NAMESPACE).on(Tables.ROUTINES.SPECIFIC_SCHEMA.eq(org.jooq.meta.postgres.pg_catalog.Tables.PG_NAMESPACE.NSPNAME)).join((TableLike)org.jooq.meta.postgres.pg_catalog.Tables.PG_PROC).on(org.jooq.meta.postgres.pg_catalog.Tables.PG_PROC.PRONAMESPACE.eq(org.jooq.meta.postgres.pg_catalog.Tables.PG_NAMESPACE.OID)).and(org.jooq.meta.postgres.pg_catalog.Tables.PG_PROC.PRONAME.concat(new String[]{"_"}).concat(new Field[]{org.jooq.meta.postgres.pg_catalog.Tables.PG_PROC.OID}).eq(Tables.ROUTINES.SPECIFIC_NAME)).where(Tables.ROUTINES.ROUTINE_SCHEMA.in(this.getInputSchemata())).and(org.jooq.meta.postgres.pg_catalog.Tables.PG_PROC.PRORETSET) : empty)).asTable("tables")).orderBy(new int[]{1, 2}).fetch()) {
            SchemaDefinition schema = this.getSchema((String)record.get(Tables.TABLES.TABLE_SCHEMA));
            String name = (String)record.get(Tables.TABLES.TABLE_NAME);
            String comment = (String)record.get(org.jooq.meta.postgres.pg_catalog.Tables.PG_DESCRIPTION.DESCRIPTION, String.class);
            TableOptions.TableType tableType = (TableOptions.TableType)record.get("table_type", TableOptions.TableType.class);
            Object source = (String)record.get(Tables.VIEWS.VIEW_DEFINITION);
            if (source != null && !((String)source).toLowerCase().startsWith("create")) {
                source = "create view \"" + name + "\" as " + (String)source;
            }
            switch (tableType) {
                case FUNCTION: {
                    result.add(new PostgresTableValuedFunction(schema, name, (String)record.get(Tables.ROUTINES.SPECIFIC_NAME), comment));
                    continue block4;
                }
                case MATERIALIZED_VIEW: {
                    result.add(new PostgresMaterializedViewDefinition(schema, name, comment));
                    continue block4;
                }
            }
            PostgresTableDefinition t = new PostgresTableDefinition(schema, name, comment, tableType, (String)source);
            result.add(t);
            map.put(DSL.name((String[])new String[]{schema.getName(), name}), t);
        }
        PgClass ct = org.jooq.meta.postgres.pg_catalog.Tables.PG_CLASS.as("ct");
        PgNamespace cn = org.jooq.meta.postgres.pg_catalog.Tables.PG_NAMESPACE.as("cn");
        PgInherits i = org.jooq.meta.postgres.pg_catalog.Tables.PG_INHERITS.as("i");
        PgClass pt = org.jooq.meta.postgres.pg_catalog.Tables.PG_CLASS.as("pt");
        PgNamespace pn = org.jooq.meta.postgres.pg_catalog.Tables.PG_NAMESPACE.as("pn");
        if (this.is84()) {
            for (Record5 inheritance : this.create().select(cn.NSPNAME, ct.RELNAME, pn.NSPNAME, pt.RELNAME, (SelectField)DSL.max(i.INHSEQNO).over().partitionBy(new Field[]{i.INHRELID}).as("m")).from((TableLike)ct).join((TableLike)cn).on(ct.RELNAMESPACE.eq(cn.OID)).join((TableLike)i).on(i.INHRELID.eq(ct.OID)).join((TableLike)pt).on(i.INHPARENT.eq(pt.OID)).join((TableLike)pn).on(pt.RELNAMESPACE.eq(pn.OID)).where(cn.NSPNAME.in(this.getInputSchemata())).and(pn.NSPNAME.in(this.getInputSchemata())).fetch()) {
                Name child = DSL.name((String[])new String[]{(String)inheritance.value1(), (String)inheritance.value2()});
                Name parent = DSL.name((String[])new String[]{(String)inheritance.value3(), (String)inheritance.value4()});
                if ((Integer)inheritance.value5() > 1) {
                    log.info((Object)"Multiple inheritance", (Object)("Multiple inheritance is not supported by jOOQ: " + child + " inherits from " + parent));
                    continue;
                }
                PostgresTableDefinition childTable = (PostgresTableDefinition)map.get(child);
                PostgresTableDefinition parentTable = (PostgresTableDefinition)map.get(parent);
                if (childTable == null || parentTable == null) continue;
                childTable.setParentTable(parentTable);
                parentTable.getChildTables().add(childTable);
            }
        }
        return result;
    }

    @Override
    protected List<CatalogDefinition> getCatalogs0() throws SQLException {
        ArrayList<CatalogDefinition> result = new ArrayList<CatalogDefinition>();
        result.add(new CatalogDefinition((Database)this, "", ""));
        return result;
    }

    @Override
    protected List<SchemaDefinition> getSchemata0() throws SQLException {
        return (List)this.create().select(org.jooq.meta.postgres.pg_catalog.Tables.PG_NAMESPACE.NSPNAME).from((TableLike)org.jooq.meta.postgres.pg_catalog.Tables.PG_NAMESPACE).orderBy(org.jooq.meta.postgres.pg_catalog.Tables.PG_NAMESPACE.NSPNAME).collect(Collectors.mapping(r -> new SchemaDefinition((Database)this, (String)r.value1(), ""), Collectors.toList()));
    }

    @Override
    public ResultQuery<Record12<String, String, String, String, Integer, Integer, Long, Long, BigDecimal, BigDecimal, Boolean, Long>> sequences(List<String> schemas) {
        CommonTableExpression s = DSL.name((String)"schemas").fields("schema").as((ResultQuery)DSL.selectFrom((Table)DSL.values((Row1[])((Row1[])schemas.stream().collect(Rows.toRowArray(DSL::val))))));
        return this.create().with(new CommonTableExpression[]{s}).select((SelectField)DSL.inline(null, (DataType)SQLDataType.VARCHAR).as("catalog"), Tables.SEQUENCES.SEQUENCE_SCHEMA, Tables.SEQUENCES.SEQUENCE_NAME, Tables.SEQUENCES.DATA_TYPE, Tables.SEQUENCES.NUMERIC_PRECISION, Tables.SEQUENCES.NUMERIC_SCALE, (SelectField)DSL.nullif((Field)Tables.SEQUENCES.START_VALUE.cast(SQLDataType.BIGINT), (Field)DSL.inline((long)1L)).as(Tables.SEQUENCES.START_VALUE), (SelectField)DSL.nullif((Field)Tables.SEQUENCES.INCREMENT.cast(SQLDataType.BIGINT), (Field)DSL.inline((long)1L)).as(Tables.SEQUENCES.INCREMENT), (SelectField)DSL.nullif((Field)Tables.SEQUENCES.MINIMUM_VALUE.cast(SQLDataType.BIGINT), (Field)DSL.inline((long)1L)).coerce(SQLDataType.NUMERIC).as(Tables.SEQUENCES.MINIMUM_VALUE), (SelectField)DSL.nullif((Object)Tables.SEQUENCES.MAXIMUM_VALUE.cast(SQLDataType.DECIMAL_INTEGER), (Object)DSL.power((Field)DSL.cast((Field)DSL.inline((long)2L), (DataType)SQLDataType.DECIMAL_INTEGER), (Field)DSL.cast((Field)Tables.SEQUENCES.NUMERIC_PRECISION.minus((Field)DSL.inline((long)1L)), (DataType)SQLDataType.DECIMAL_INTEGER)).minus((Field)DSL.inline((long)1L))).coerce(SQLDataType.NUMERIC).as(Tables.SEQUENCES.MAXIMUM_VALUE), (SelectField)Tables.SEQUENCES.CYCLE_OPTION.cast(SQLDataType.BOOLEAN).as(Tables.SEQUENCES.CYCLE_OPTION), (SelectField)DSL.inline(null, (DataType)SQLDataType.BIGINT).as("cache")).from((TableLike)Tables.SEQUENCES).where(Tables.SEQUENCES.SEQUENCE_SCHEMA.in((Select)DSL.selectFrom((Table)s))).and(!this.getIncludeSystemSequences() ? DSL.row(Tables.SEQUENCES.SEQUENCE_SCHEMA, Tables.SEQUENCES.SEQUENCE_NAME).notIn((Select)DSL.select(Tables.COLUMNS.TABLE_SCHEMA, (SelectField)Tables.COLUMNS.TABLE_NAME.concat(new Field[]{DSL.inline((String)"_")}).concat(new Field[]{Tables.COLUMNS.COLUMN_NAME}).concat(new Field[]{DSL.inline((String)"_seq")})).from((TableLike)Tables.COLUMNS).where(Tables.COLUMNS.COLUMN_DEFAULT.eq(DSL.inline((String)"nextval('").concat(new Field[]{Tables.COLUMNS.TABLE_NAME.concat(new Field[]{DSL.inline((String)"_")}).concat(new Field[]{Tables.COLUMNS.COLUMN_NAME})}).concat(new Field[]{DSL.inline((String)"_seq'::regclass)")}))).or(Tables.COLUMNS.COLUMN_DEFAULT.eq(DSL.inline((String)"nextval('").concat(new Field[]{Tables.COLUMNS.TABLE_SCHEMA.concat(new Field[]{DSL.inline((String)".")}).concat(new Field[]{Tables.COLUMNS.TABLE_NAME}).concat(new Field[]{DSL.inline((String)"_")}).concat(new Field[]{Tables.COLUMNS.COLUMN_NAME})}).concat(new Field[]{DSL.inline((String)"_seq'::regclass)")})))) : DSL.noCondition()).unionAll((Select)(this.is10() && this.getIncludeSystemSequences() ? DSL.select((SelectField)DSL.inline(null, (DataType)SQLDataType.VARCHAR), org.jooq.meta.postgres.pg_catalog.Tables.PG_SEQUENCE.pgClass().pgNamespace().NSPNAME, org.jooq.meta.postgres.pg_catalog.Tables.PG_SEQUENCE.pgClass().RELNAME, org.jooq.meta.postgres.pg_catalog.Tables.PG_SEQUENCE.pgType().TYPNAME, (SelectField)DSL.field((String)"information_schema._pg_numeric_precision({0}, {1})", (DataType)SQLDataType.INTEGER, (QueryPart[])new QueryPart[]{org.jooq.meta.postgres.pg_catalog.Tables.PG_SEQUENCE.pgType().TYPBASETYPE, org.jooq.meta.postgres.pg_catalog.Tables.PG_SEQUENCE.pgType().TYPTYPMOD}), (SelectField)DSL.inline((int)0), org.jooq.meta.postgres.pg_catalog.Tables.PG_SEQUENCE.SEQSTART, org.jooq.meta.postgres.pg_catalog.Tables.PG_SEQUENCE.SEQINCREMENT, (SelectField)org.jooq.meta.postgres.pg_catalog.Tables.PG_SEQUENCE.SEQMIN.coerce(SQLDataType.NUMERIC), (SelectField)org.jooq.meta.postgres.pg_catalog.Tables.PG_SEQUENCE.SEQMAX.coerce(SQLDataType.NUMERIC), org.jooq.meta.postgres.pg_catalog.Tables.PG_SEQUENCE.SEQCYCLE, (SelectField)DSL.inline(null, (DataType)SQLDataType.BIGINT).as("cache")).from((TableLike)org.jooq.meta.postgres.pg_catalog.Tables.PG_SEQUENCE).where(org.jooq.meta.postgres.pg_catalog.Tables.PG_SEQUENCE.pgClass().pgNamespace().NSPNAME.in((Select)DSL.selectFrom((Table)s))).and(org.jooq.meta.postgres.pg_catalog.Tables.PG_SEQUENCE.pgClass().OID.in((Select)DSL.select(org.jooq.meta.postgres.pg_catalog.Tables.PG_DEPEND.OBJID).from((TableLike)org.jooq.meta.postgres.pg_catalog.Tables.PG_DEPEND).where(org.jooq.meta.postgres.pg_catalog.Tables.PG_DEPEND.DEPTYPE.eq((Field)DSL.inline((String)"i"))).and(org.jooq.meta.postgres.pg_catalog.Tables.PG_DEPEND.CLASSID.eq(DSL.field((String)"'pg_class'::regclass", (DataType)org.jooq.meta.postgres.pg_catalog.Tables.PG_DEPEND.CLASSID.getDataType()))))) : DSL.select((SelectField)DSL.inline((String)""), (SelectField)DSL.inline((String)""), (SelectField)DSL.inline((String)""), (SelectField)DSL.inline((String)""), (SelectField)DSL.inline((int)0), (SelectField)DSL.inline((int)0), (SelectField)DSL.inline((long)0L), (SelectField)DSL.inline((long)0L), (SelectField)DSL.inline((BigDecimal)BigDecimal.ZERO), (SelectField)DSL.inline((BigDecimal)BigDecimal.ZERO), (SelectField)DSL.inline((boolean)false), (SelectField)DSL.inline((long)0L)).where((Condition)DSL.falseCondition()))).orderBy(new int[]{2, 3});
    }

    @Override
    protected List<SequenceDefinition> getSequences0() throws SQLException {
        ArrayList<SequenceDefinition> result = new ArrayList<SequenceDefinition>();
        for (Record record : this.sequences(this.getInputSchemata())) {
            SchemaDefinition schema = this.getSchema((String)record.get(Tables.SEQUENCES.SEQUENCE_SCHEMA));
            DefaultDataTypeDefinition type = new DefaultDataTypeDefinition((Database)this, schema, (String)record.get(Tables.SEQUENCES.DATA_TYPE), (Number)0, (Number)record.get(Tables.SEQUENCES.NUMERIC_PRECISION), (Number)record.get(Tables.SEQUENCES.NUMERIC_SCALE), (Boolean)false, (String)null);
            result.add(new DefaultSequenceDefinition(schema, (String)record.get(Tables.SEQUENCES.SEQUENCE_NAME), type, null, (Number)record.get(Tables.SEQUENCES.START_VALUE, BigInteger.class), (Number)record.get(Tables.SEQUENCES.INCREMENT, BigInteger.class), (Number)record.get(Tables.SEQUENCES.MINIMUM_VALUE, BigInteger.class), (Number)record.get(Tables.SEQUENCES.MAXIMUM_VALUE, BigInteger.class), (Boolean)record.get(Tables.SEQUENCES.CYCLE_OPTION, Boolean.class), null));
        }
        return result;
    }

    @Override
    protected List<EnumDefinition> getEnums0() throws SQLException {
        ArrayList<EnumDefinition> result = new ArrayList<EnumDefinition>();
        if (this.exists((Table<?>)org.jooq.meta.postgres.pg_catalog.Tables.PG_ENUM)) {
            for (Identifier type : this.create().select(org.jooq.meta.postgres.pg_catalog.Tables.PG_TYPE.pgNamespace().NSPNAME, org.jooq.meta.postgres.pg_catalog.Tables.PG_TYPE.TYPNAME).from((TableLike)org.jooq.meta.postgres.pg_catalog.Tables.PG_TYPE).where(org.jooq.meta.postgres.pg_catalog.Tables.PG_TYPE.pgNamespace().NSPNAME.in(this.getInputSchemata())).and(org.jooq.meta.postgres.pg_catalog.Tables.PG_TYPE.OID.in((Select)DSL.select(org.jooq.meta.postgres.pg_catalog.Tables.PG_ENUM.ENUMTYPID).from((TableLike)org.jooq.meta.postgres.pg_catalog.Tables.PG_ENUM))).orderBy(org.jooq.meta.postgres.pg_catalog.Tables.PG_TYPE.pgNamespace().NSPNAME, org.jooq.meta.postgres.pg_catalog.Tables.PG_TYPE.TYPNAME).fetch(Records.mapping(Identifier::new))) {
                AbstractDefinition definition = null;
                for (String label : this.enumLabels(type.schema, type.name)) {
                    SchemaDefinition schema = this.getSchema(type.schema);
                    String typeName = String.valueOf(type.name);
                    if (definition == null || !definition.getName().equals(typeName)) {
                        definition = new DefaultEnumDefinition(schema, typeName, null);
                        result.add((EnumDefinition)((Object)definition));
                    }
                    ((DefaultEnumDefinition)definition).addLiteral(label);
                }
            }
        }
        return result;
    }

    @Override
    protected List<DomainDefinition> getDomains0() throws SQLException {
        ArrayList<DomainDefinition> result = new ArrayList<DomainDefinition>();
        if (this.existAll(new Table[]{org.jooq.meta.postgres.pg_catalog.Tables.PG_CONSTRAINT, org.jooq.meta.postgres.pg_catalog.Tables.PG_TYPE})) {
            PgNamespace n = org.jooq.meta.postgres.pg_catalog.Tables.PG_NAMESPACE.as("n");
            PgConstraint c = org.jooq.meta.postgres.pg_catalog.Tables.PG_CONSTRAINT.as("c");
            PgType d = org.jooq.meta.postgres.pg_catalog.Tables.PG_TYPE.as("d");
            PgType b = org.jooq.meta.postgres.pg_catalog.Tables.PG_TYPE.as("b");
            Field src = DSL.field((Name)DSL.name((String[])new String[]{"domains", "src"}), String[].class);
            Field constraintDef = DSL.field((String)"pg_get_constraintdef({0})", (DataType)SQLDataType.VARCHAR, (QueryPart[])new QueryPart[]{c.OID});
            for (Record record : this.create().withRecursive("domains", "domain_id", "base_id", "typbasetype", "src").as((ResultQuery)DSL.select(d.OID, d.OID, d.TYPBASETYPE, (SelectField)DSL.when((Condition)c.OID.isNotNull(), (Field)DSL.array((Field[])new Field[]{constraintDef}))).from((TableLike)d).join((TableLike)n).on(n.OID.eq(d.TYPNAMESPACE)).leftJoin((TableLike)c).on(d.OID.eq(c.CONTYPID)).where(d.TYPTYPE.eq((Object)"d")).and(n.NSPNAME.in(this.getInputSchemata())).unionAll((Select)DSL.select((SelectField)DSL.field((Name)DSL.name((String[])new String[]{"domains", "domain_id"}), Long.class), d.OID, d.TYPBASETYPE, (SelectField)DSL.decode().when(c.CONBIN.isNull(), src).otherwise(PostgresDSL.arrayAppend((Field)src, (Field)constraintDef))).from(DSL.name((String)"domains")).join((TableLike)d).on(DSL.field((Name)DSL.name((String[])new String[]{"domains", d.TYPBASETYPE.getName()})).eq(d.OID)).leftJoin((TableLike)c).on(d.OID.eq(c.CONTYPID)))).select(n.NSPNAME, d.TYPNAME, d.TYPNOTNULL, d.TYPDEFAULT, b.TYPNAME, (SelectField)DSL.field((String)"information_schema._pg_char_max_length({0}, {1})", (DataType)SQLDataType.INTEGER, (QueryPart[])new QueryPart[]{d.TYPBASETYPE, d.TYPTYPMOD}).as(Tables.DOMAINS.CHARACTER_MAXIMUM_LENGTH), (SelectField)DSL.field((String)"information_schema._pg_numeric_precision({0}, {1})", (DataType)SQLDataType.INTEGER, (QueryPart[])new QueryPart[]{d.TYPBASETYPE, d.TYPTYPMOD}).as(Tables.DOMAINS.NUMERIC_PRECISION), (SelectField)DSL.field((String)"information_schema._pg_numeric_scale({0}, {1})", (DataType)SQLDataType.INTEGER, (QueryPart[])new QueryPart[]{d.TYPBASETYPE, d.TYPTYPMOD}).as(Tables.DOMAINS.NUMERIC_SCALE), (SelectField)src).from((TableLike)d).join(DSL.name((String)"domains")).on(DSL.field((Name)DSL.name((String[])new String[]{"domains", "typbasetype"})).eq((Object)0)).and(DSL.field((Name)DSL.name((String[])new String[]{"domains", "domain_id"})).eq(d.OID)).join((TableLike)b).on(DSL.field((Name)DSL.name((String[])new String[]{"domains", "base_id"})).eq(b.OID)).join((TableLike)n).on(n.OID.eq(d.TYPNAMESPACE)).where(d.TYPTYPE.eq((Object)"d")).and(n.NSPNAME.in(this.getInputSchemata())).orderBy(n.NSPNAME, d.TYPNAME)) {
                SchemaDefinition schema = this.getSchema((String)record.get(n.NSPNAME));
                DefaultDataTypeDefinition baseType = new DefaultDataTypeDefinition((Database)this, schema, (String)record.get(b.TYPNAME), (Number)record.get(Tables.DOMAINS.CHARACTER_MAXIMUM_LENGTH), (Number)record.get(Tables.DOMAINS.NUMERIC_PRECISION), (Number)record.get(Tables.DOMAINS.NUMERIC_SCALE), (Boolean)((Boolean)record.get(d.TYPNOTNULL, Boolean.TYPE) == false ? 1 : 0), (String)record.get(d.TYPDEFAULT), DSL.name((String[])new String[]{(String)record.get(n.NSPNAME), (String)record.get(b.TYPNAME)}));
                DefaultDomainDefinition domain = new DefaultDomainDefinition(schema, (String)record.get(d.TYPNAME), baseType);
                domain.addCheckClause((String[])record.get(src));
                result.add(domain);
            }
        }
        return result;
    }

    @Override
    protected List<UDTDefinition> getUDTs0() throws SQLException {
        ArrayList<UDTDefinition> result = new ArrayList<UDTDefinition>();
        if (this.exists((Table<?>)Tables.ATTRIBUTES)) {
            for (Identifier udt : this.create().selectDistinct(Tables.ATTRIBUTES.UDT_SCHEMA, Tables.ATTRIBUTES.UDT_NAME).from((TableLike)Tables.ATTRIBUTES).where(Tables.ATTRIBUTES.UDT_SCHEMA.in(this.getInputSchemata())).orderBy(Tables.ATTRIBUTES.UDT_SCHEMA, Tables.ATTRIBUTES.UDT_NAME).fetch(Records.mapping(Identifier::new))) {
                SchemaDefinition schema = this.getSchema(udt.schema);
                if (schema == null) continue;
                result.add(new PostgresUDTDefinition(schema, udt.name, null));
            }
        }
        return result;
    }

    @Override
    protected List<ArrayDefinition> getArrays0() throws SQLException {
        ArrayList<ArrayDefinition> result = new ArrayList<ArrayDefinition>();
        return result;
    }

    @Override
    protected List<RoutineDefinition> getRoutines0() throws SQLException {
        ArrayList<RoutineDefinition> result = new ArrayList<RoutineDefinition>();
        if (!this.canUseRoutines()) {
            return result;
        }
        Routines r1 = Tables.ROUTINES.as("r1");
        Field isAgg = (this.is11() ? DSL.field((Condition)org.jooq.meta.postgres.pg_catalog.Tables.PG_PROC.PROKIND.eq((Field)DSL.inline((String)"a"))) : DSL.field((String)"{0}.proisagg", (DataType)SQLDataType.BOOLEAN, (QueryPart[])new QueryPart[]{org.jooq.meta.postgres.pg_catalog.Tables.PG_PROC})).as("is_agg");
        return (List)this.create().select(r1.ROUTINE_SCHEMA, r1.ROUTINE_NAME, r1.SPECIFIC_NAME, r1.ROUTINE_TYPE, (SelectField)DSL.when((Condition)r1.DATA_TYPE.eq((Field)DSL.inline((String)"USER-DEFINED")).and(r1.TYPE_UDT_NAME.eq((Field)DSL.inline((String)"geometry"))), (Field)DSL.inline((String)"geometry")).else_(this.canCombineArrays() ? DSL.when((Condition)DSL.condition((String)"{0} && ARRAY['o','b']::\"char\"[]", (QueryPart[])new QueryPart[]{org.jooq.meta.postgres.pg_catalog.Tables.PG_PROC.PROARGMODES}), (Field)DSL.inline((String)"void")).else_(r1.DATA_TYPE) : r1.DATA_TYPE).as("data_type"), r1.CHARACTER_MAXIMUM_LENGTH, (SelectField)DSL.when((Condition)r1.NUMERIC_PRECISION.isNull().and(r1.DATA_TYPE.in(new Field[]{DSL.inline((String)"time"), DSL.inline((String)"timetz"), DSL.inline((String)"time without time zone"), DSL.inline((String)"time with time zone"), DSL.inline((String)"timestamp"), DSL.inline((String)"timestamptz"), DSL.inline((String)"timestamp without time zone"), DSL.inline((String)"timestamp with time zone")})), (Field)DSL.inline((int)6)).else_(r1.NUMERIC_PRECISION).as(r1.NUMERIC_PRECISION), r1.NUMERIC_SCALE, r1.TYPE_UDT_SCHEMA, r1.TYPE_UDT_NAME, (SelectField)DSL.when((Condition)DSL.count().over((WindowSpecification)DSL.partitionBy((Field[])new Field[]{r1.ROUTINE_SCHEMA, r1.ROUTINE_NAME})).gt((Field)DSL.one()), (Field)DSL.rowNumber().over((WindowSpecification)DSL.partitionBy((Field[])new Field[]{r1.ROUTINE_SCHEMA, r1.ROUTINE_NAME}).orderBy(new OrderField[]{r1.SPECIFIC_NAME}))).as("overload"), (SelectField)isAgg).from((TableLike)r1).join((TableLike)org.jooq.meta.postgres.pg_catalog.Tables.PG_NAMESPACE).on(org.jooq.meta.postgres.pg_catalog.Tables.PG_NAMESPACE.NSPNAME.eq(r1.SPECIFIC_SCHEMA)).join((TableLike)org.jooq.meta.postgres.pg_catalog.Tables.PG_PROC).on(org.jooq.meta.postgres.pg_catalog.Tables.PG_PROC.PRONAMESPACE.eq(org.jooq.meta.postgres.pg_catalog.Tables.PG_NAMESPACE.OID)).and(this.nameconcatoid(r1)).where(r1.ROUTINE_SCHEMA.in(this.getInputSchemata())).and(this.tableValuedFunctions() ? DSL.condition((Field)DSL.not(org.jooq.meta.postgres.pg_catalog.Tables.PG_PROC.PRORETSET)) : DSL.noCondition()).and(!this.getIncludeTriggerRoutines() ? r1.DATA_TYPE.isDistinctFrom((Field)DSL.inline((String)"trigger")) : DSL.noCondition()).orderBy((OrderField)r1.ROUTINE_SCHEMA.asc(), (OrderField)r1.ROUTINE_NAME.asc(), (OrderField)DSL.field((Name)DSL.name((String)"overload")).asc()).collect(Collectors.mapping(r -> new PostgresRoutineDefinition(this, (Record)r), Collectors.toList()));
    }

    protected Condition nameconcatoid(Routines r1) {
        return this.is12() ? DSL.condition((String)"nameconcatoid({0}, {1}) = {2}", (QueryPart[])new QueryPart[]{org.jooq.meta.postgres.pg_catalog.Tables.PG_PROC.PRONAME, org.jooq.meta.postgres.pg_catalog.Tables.PG_PROC.OID, r1.SPECIFIC_NAME}) : org.jooq.meta.postgres.pg_catalog.Tables.PG_PROC.PRONAME.concat(new String[]{"_"}).concat(new Field[]{org.jooq.meta.postgres.pg_catalog.Tables.PG_PROC.OID}).eq(r1.SPECIFIC_NAME);
    }

    @Override
    protected List<PackageDefinition> getPackages0() throws SQLException {
        ArrayList<PackageDefinition> result = new ArrayList<PackageDefinition>();
        return result;
    }

    @Override
    protected DSLContext create0() {
        return DSL.using((Connection)this.getConnection(), (SQLDialect)SQLDialect.POSTGRES);
    }

    boolean is84() {
        if (this.is84 == null) {
            this.is84 = this.configuredDialectIsNotFamilyAndSupports(Arrays.asList(SQLDialect.POSTGRES), () -> {
                try {
                    this.create(true).select((SelectField)DSL.count().over()).fetch();
                    return true;
                }
                catch (DataAccessException e) {
                    return false;
                }
            });
        }
        return this.is84;
    }

    boolean is94() {
        if (this.is94 == null) {
            this.is94 = this.configuredDialectIsNotFamilyAndSupports(Arrays.asList(SQLDialect.POSTGRES), () -> this.exists(Tables.PARAMETERS.PARAMETER_DEFAULT));
        }
        return this.is94;
    }

    boolean is10() {
        if (this.is10 == null) {
            this.is10 = this.configuredDialectIsNotFamilyAndSupports(Arrays.asList(SQLDialect.POSTGRES), () -> this.exists(org.jooq.meta.postgres.pg_catalog.Tables.PG_SEQUENCE.SEQRELID));
        }
        return this.is10;
    }

    boolean is11() {
        if (this.is11 == null) {
            this.is11 = this.configuredDialectIsNotFamilyAndSupports(Arrays.asList(SQLDialect.POSTGRES), () -> this.exists(org.jooq.meta.postgres.pg_catalog.Tables.PG_PROC.PROKIND));
        }
        return this.is11;
    }

    boolean is12() {
        if (this.is12 == null) {
            this.is12 = this.configuredDialectIsNotFamilyAndSupports(Arrays.asList(SQLDialect.POSTGRES), () -> this.exists(DSL.table((String)"column_column_usage")));
        }
        return this.is12;
    }

    @Override
    protected boolean exists0(TableField<?, ?> field) {
        return this.exists1(field, Tables.COLUMNS, Tables.COLUMNS.TABLE_SCHEMA, Tables.COLUMNS.TABLE_NAME, Tables.COLUMNS.COLUMN_NAME);
    }

    @Override
    protected boolean exists0(Table<?> table) {
        return this.exists1(table, Tables.TABLES, Tables.TABLES.TABLE_SCHEMA, Tables.TABLES.TABLE_NAME);
    }

    boolean canCombineArrays() {
        if (this.canCombineArrays == null) {
            try {
                this.create(true).select((SelectField)DSL.field((String)"array[1, 2] && array[2, 3]")).fetch();
                this.canCombineArrays = true;
            }
            catch (DataAccessException e) {
                this.canCombineArrays = false;
            }
        }
        return this.canCombineArrays;
    }

    boolean canUseTupleInPredicates() {
        if (this.canUseTupleInPredicates == null) {
            try {
                this.create(true).select((SelectField)DSL.field((String)"(1, 2) in (select 1, 2)")).fetch();
                this.create(true).select((SelectField)DSL.field((String)"(1, 2) not in (select 1, 2)")).fetch();
                this.canUseTupleInPredicates = true;
            }
            catch (DataAccessException e) {
                this.canUseTupleInPredicates = false;
            }
        }
        return this.canUseTupleInPredicates;
    }

    boolean canUseRoutines() {
        if (this.canUseRoutines == null) {
            this.canUseRoutines = this.exists((Table<?>)Tables.ROUTINES);
        }
        return this.canUseRoutines;
    }

    private List<String> enumLabels(String nspname, String typname) {
        Field orderBy;
        Field field = orderBy = this.exists(org.jooq.meta.postgres.pg_catalog.Tables.PG_ENUM.ENUMSORTORDER) ? org.jooq.meta.postgres.pg_catalog.Tables.PG_ENUM.ENUMSORTORDER : DSL.field((String)"{0}::{1}", (QueryPart[])new QueryPart[]{org.jooq.meta.postgres.pg_catalog.Tables.PG_ENUM.ENUMLABEL, DSL.sql((String)("" + DSL.name((String[])new String[]{nspname, typname})))});
        if (this.canCastToEnumType == null) {
            try {
                this.canCastToEnumType = true;
                return this.enumLabels(nspname, typname, orderBy);
            }
            catch (DataAccessException e) {
                this.canCastToEnumType = false;
            }
        }
        return this.canCastToEnumType != false ? this.enumLabels(nspname, typname, orderBy) : this.enumLabels(nspname, typname, (Field<?>)org.jooq.meta.postgres.pg_catalog.Tables.PG_ENUM.ENUMLABEL);
    }

    private List<String> enumLabels(String nspname, String typname, Field<?> orderBy) {
        return (List)this.create().select(org.jooq.meta.postgres.pg_catalog.Tables.PG_ENUM.ENUMLABEL).from((TableLike)org.jooq.meta.postgres.pg_catalog.Tables.PG_ENUM).where(org.jooq.meta.postgres.pg_catalog.Tables.PG_ENUM.pgType().pgNamespace().NSPNAME.eq((Object)nspname)).and(org.jooq.meta.postgres.pg_catalog.Tables.PG_ENUM.pgType().TYPNAME.eq((Object)typname)).orderBy(orderBy).collect(Records.intoList());
    }

    static final class Identifier {
        private final String schema;
        private final String name;

        public Identifier(String schema, String name) {
            this.schema = schema;
            this.name = name;
        }

        public String schema() {
            return this.schema;
        }

        public String name() {
            return this.name;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Identifier)) {
                return false;
            }
            Identifier other = (Identifier)o;
            if (!Objects.equals(this.schema, other.schema)) {
                return false;
            }
            return Objects.equals(this.name, other.name);
        }

        public int hashCode() {
            return Objects.hash(this.schema, this.name);
        }

        public String toString() {
            return "Identifier[" + "schema=" + this.schema + ", name=" + this.name + "]";
        }
    }
}

