/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.util.vertabelo;

import java.io.File;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.JAXB;
import org.jooq.DSLContext;
import org.jooq.SQLDialect;
import org.jooq.impl.DSL;
import org.jooq.tools.JooqLogger;
import org.jooq.tools.StringUtils;
import org.jooq.util.AbstractDatabase;
import org.jooq.util.ArrayDefinition;
import org.jooq.util.CheckConstraintDefinition;
import org.jooq.util.ColumnDefinition;
import org.jooq.util.DataTypeDefinition;
import org.jooq.util.Database;
import org.jooq.util.DefaultCheckConstraintDefinition;
import org.jooq.util.DefaultDataTypeDefinition;
import org.jooq.util.DefaultRelations;
import org.jooq.util.DefaultSequenceDefinition;
import org.jooq.util.EnumDefinition;
import org.jooq.util.PackageDefinition;
import org.jooq.util.RoutineDefinition;
import org.jooq.util.SchemaDefinition;
import org.jooq.util.SequenceDefinition;
import org.jooq.util.TableDefinition;
import org.jooq.util.UDTDefinition;
import org.jooq.util.vertabelo.VertabeloXMLTableDefinition;
import org.jooq.util.vertabelo.jaxb.AlternateKey;
import org.jooq.util.vertabelo.jaxb.AlternateKeyColumn;
import org.jooq.util.vertabelo.jaxb.Column;
import org.jooq.util.vertabelo.jaxb.DatabaseModel;
import org.jooq.util.vertabelo.jaxb.Property;
import org.jooq.util.vertabelo.jaxb.Reference;
import org.jooq.util.vertabelo.jaxb.ReferenceColumn;
import org.jooq.util.vertabelo.jaxb.Sequence;
import org.jooq.util.vertabelo.jaxb.Table;
import org.jooq.util.vertabelo.jaxb.TableCheck;
import org.jooq.util.vertabelo.jaxb.View;

public class VertabeloXMLDatabase
extends AbstractDatabase {
    private static final JooqLogger log = JooqLogger.getLogger(VertabeloXMLDatabase.class);
    private static final String SCHEMA_ADDITIONAL_PROPERTY_NAME = "Schema";
    private static final String PK_ADDITIONAL_PROPERTY_NAME = "Primary key name";
    protected DatabaseModel databaseModel;

    protected DatabaseModel databaseModel() {
        if (this.databaseModel == null) {
            this.databaseModel = (DatabaseModel)JAXB.unmarshal((File)new File(this.getProperties().getProperty("xml-file")), DatabaseModel.class);
        }
        return this.databaseModel;
    }

    protected DSLContext create0() {
        SQLDialect dialect = SQLDialect.DEFAULT;
        try {
            dialect = SQLDialect.valueOf((String)this.getProperties().getProperty("dialect"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return DSL.using((SQLDialect)dialect);
    }

    protected void loadPrimaryKeys(final DefaultRelations relations) throws SQLException {
        this.filterTablesBySchema(this.databaseModel().getTables(), new TableOperation(){

            @Override
            public void invoke(Table table, String schemaName) {
                SchemaDefinition schema = VertabeloXMLDatabase.this.getSchema(schemaName);
                TableDefinition tableDefinition = VertabeloXMLDatabase.this.getTable(schema, table.getName());
                if (tableDefinition != null) {
                    String pkName = VertabeloXMLDatabase.this.getTablePkName(table);
                    for (Column column : table.getColumns()) {
                        if (!column.isPK()) continue;
                        relations.addPrimaryKey(pkName, tableDefinition.getColumn(column.getName()));
                    }
                }
            }
        });
    }

    private String getTablePkName(Table table) {
        Property pkAdditionalProperty = VertabeloXMLDatabase.findAdditionalProperty(PK_ADDITIONAL_PROPERTY_NAME, table.getProperties());
        String pkName = VertabeloXMLDatabase.getAdditionalPropertyValueOrEmpty(pkAdditionalProperty);
        if (StringUtils.isEmpty((String)pkName)) {
            pkName = table.getName().toUpperCase() + "_PK";
        }
        return pkName;
    }

    protected void loadUniqueKeys(final DefaultRelations relations) throws SQLException {
        this.filterTablesBySchema(this.databaseModel().getTables(), new TableOperation(){

            @Override
            public void invoke(Table table, String schemaName) {
                SchemaDefinition schema = VertabeloXMLDatabase.this.getSchema(schemaName);
                TableDefinition tableDefinition = VertabeloXMLDatabase.this.getTable(schema, table.getName());
                if (tableDefinition != null) {
                    for (AlternateKey alternateKey : table.getAlternateKeys()) {
                        for (AlternateKeyColumn alternateKeyColumn : alternateKey.getColumns()) {
                            Column column = (Column)alternateKeyColumn.getColumn();
                            relations.addUniqueKey(alternateKey.getName(), tableDefinition.getColumn(column.getName()));
                        }
                    }
                }
            }
        });
    }

    protected void loadForeignKeys(final DefaultRelations relations) throws SQLException {
        for (final Reference reference : this.databaseModel().getReferences()) {
            final Table pkTable = (Table)reference.getPKTable();
            final Table fkTable = (Table)reference.getFKTable();
            this.filterTablesBySchema(Arrays.asList(pkTable), new TableOperation(){

                @Override
                public void invoke(Table table, String schemaName) {
                    SchemaDefinition schema = VertabeloXMLDatabase.this.getSchema(schemaName);
                    TableDefinition pkTableDefinition = VertabeloXMLDatabase.this.getTable(schema, pkTable.getName());
                    TableDefinition fkTableDefinition = VertabeloXMLDatabase.this.getTable(schema, fkTable.getName());
                    String uniqueKeyName = VertabeloXMLDatabase.this.findUniqueConstraintNameForReference(reference);
                    if (uniqueKeyName == null) {
                        return;
                    }
                    for (ReferenceColumn referenceColumn : reference.getReferenceColumns()) {
                        Column fkColumn = (Column)referenceColumn.getFKColumn();
                        ColumnDefinition fkColumnDefinition = fkTableDefinition.getColumn(fkColumn.getName());
                        relations.addForeignKey(reference.getName(), uniqueKeyName, fkColumnDefinition, pkTableDefinition.getSchema());
                    }
                }
            });
        }
    }

    private String findUniqueConstraintNameForReference(Reference reference) {
        ArrayList<Column> uniqueKeyColumns = new ArrayList<Column>();
        for (ReferenceColumn referenceColumn : reference.getReferenceColumns()) {
            uniqueKeyColumns.add((Column)referenceColumn.getPKColumn());
        }
        Table pkTable = (Table)reference.getPKTable();
        ArrayList<Column> pkColumns = new ArrayList<Column>();
        for (Column column : pkTable.getColumns()) {
            if (!column.isPK()) continue;
            pkColumns.add(column);
        }
        if (uniqueKeyColumns.equals(pkColumns)) {
            log.info((Object)("Primary key constraint matches foreign key: " + reference.getName()));
            return this.getTablePkName((Table)reference.getPKTable());
        }
        for (AlternateKey alternateKey : pkTable.getAlternateKeys()) {
            ArrayList<Column> akColumns = new ArrayList<Column>();
            for (AlternateKeyColumn column : alternateKey.getColumns()) {
                akColumns.add((Column)column.getColumn());
            }
            if (!uniqueKeyColumns.equals(akColumns)) continue;
            log.info((Object)("Alternate key constraint matches foreign key: " + reference.getName()));
            return alternateKey.getName();
        }
        log.info((Object)("No matching unique constraint for foreign key: " + reference.getName()));
        return null;
    }

    protected void loadCheckConstraints(final DefaultRelations relations) throws SQLException {
        this.filterTablesBySchema(this.databaseModel().getTables(), new TableOperation(){

            @Override
            public void invoke(Table table, String schemaName) {
                SchemaDefinition schema = VertabeloXMLDatabase.this.getSchema(schemaName);
                TableDefinition tableDefinition = VertabeloXMLDatabase.this.getTable(schema, table.getName());
                if (tableDefinition != null) {
                    DefaultCheckConstraintDefinition checkConstraintDefinition;
                    for (TableCheck tableCheck : table.getTableChecks()) {
                        checkConstraintDefinition = new DefaultCheckConstraintDefinition(schema, tableDefinition, tableCheck.getName(), tableCheck.getCheckExpression());
                        relations.addCheckConstraint(tableDefinition, (CheckConstraintDefinition)checkConstraintDefinition);
                    }
                    for (Column column : table.getColumns()) {
                        if (StringUtils.isBlank((String)column.getCheckExpression())) continue;
                        checkConstraintDefinition = new DefaultCheckConstraintDefinition(schema, tableDefinition, table.getName() + "_" + column.getName() + "_check", column.getCheckExpression());
                        relations.addCheckConstraint(tableDefinition, (CheckConstraintDefinition)checkConstraintDefinition);
                    }
                }
            }
        });
    }

    protected List<SchemaDefinition> getSchemata0() throws SQLException {
        Property additionalProperty;
        ArrayList<SchemaDefinition> result = new ArrayList<SchemaDefinition>();
        ArrayList<String> schemaNames = new ArrayList<String>();
        for (Table table : this.databaseModel().getTables()) {
            additionalProperty = VertabeloXMLDatabase.findAdditionalProperty(SCHEMA_ADDITIONAL_PROPERTY_NAME, table.getProperties());
            this.addUniqueSchemaName(additionalProperty, schemaNames);
        }
        for (View view : this.databaseModel().getViews()) {
            additionalProperty = VertabeloXMLDatabase.findAdditionalProperty(SCHEMA_ADDITIONAL_PROPERTY_NAME, view.getProperties());
            this.addUniqueSchemaName(additionalProperty, schemaNames);
        }
        for (String schemaName : schemaNames) {
            result.add(new SchemaDefinition((Database)this, schemaName, null));
        }
        return result;
    }

    private void addUniqueSchemaName(Property additionalProperty, List<String> schemaNames) {
        String schemaName = "";
        if (additionalProperty != null) {
            schemaName = additionalProperty.getValue();
        }
        if (!schemaNames.contains(schemaName)) {
            schemaNames.add(schemaName);
        }
    }

    protected List<SequenceDefinition> getSequences0() throws SQLException {
        ArrayList<SequenceDefinition> result = new ArrayList<SequenceDefinition>();
        for (Sequence sequence : this.databaseModel().getSequences()) {
            Property additionalProperty = VertabeloXMLDatabase.findAdditionalProperty(SCHEMA_ADDITIONAL_PROPERTY_NAME, sequence.getProperties());
            String schemaName = VertabeloXMLDatabase.getAdditionalPropertyValueOrEmpty(additionalProperty);
            if (!this.getInputSchemata().contains(schemaName)) continue;
            SchemaDefinition schema = this.getSchema(schemaName);
            DefaultDataTypeDefinition type = new DefaultDataTypeDefinition((Database)this, schema, "BIGINT");
            result.add((SequenceDefinition)new DefaultSequenceDefinition(schema, sequence.getName(), (DataTypeDefinition)type));
        }
        return result;
    }

    protected List<TableDefinition> getTables0() throws SQLException {
        final ArrayList<TableDefinition> result = new ArrayList<TableDefinition>();
        this.filterTablesBySchema(this.databaseModel().getTables(), new TableOperation(){

            @Override
            public void invoke(Table table, String schemaName) {
                SchemaDefinition schema = VertabeloXMLDatabase.this.getSchema(schemaName);
                result.add(new VertabeloXMLTableDefinition(schema, table));
            }
        });
        this.filterViewsBySchema(this.databaseModel().getViews(), new ViewOperation(){

            @Override
            public void invoke(View view, String schemaName) {
                SchemaDefinition schema = VertabeloXMLDatabase.this.getSchema(schemaName);
                result.add(new VertabeloXMLTableDefinition(schema, view));
            }
        });
        return result;
    }

    protected List<EnumDefinition> getEnums0() {
        ArrayList<EnumDefinition> result = new ArrayList<EnumDefinition>();
        return result;
    }

    protected List<UDTDefinition> getUDTs0() {
        ArrayList<UDTDefinition> result = new ArrayList<UDTDefinition>();
        return result;
    }

    protected List<ArrayDefinition> getArrays0() {
        ArrayList<ArrayDefinition> result = new ArrayList<ArrayDefinition>();
        return result;
    }

    protected List<RoutineDefinition> getRoutines0() {
        ArrayList<RoutineDefinition> result = new ArrayList<RoutineDefinition>();
        return result;
    }

    protected List<PackageDefinition> getPackages0() {
        ArrayList<PackageDefinition> result = new ArrayList<PackageDefinition>();
        return result;
    }

    protected void filterTablesBySchema(List<Table> tables, TableOperation operation) {
        for (Table table : tables) {
            Property schemaAdditionalProperty = VertabeloXMLDatabase.findAdditionalProperty(SCHEMA_ADDITIONAL_PROPERTY_NAME, table.getProperties());
            String schemaName = VertabeloXMLDatabase.getAdditionalPropertyValueOrEmpty(schemaAdditionalProperty);
            if (!this.getInputSchemata().contains(schemaName)) continue;
            operation.invoke(table, schemaName);
        }
    }

    protected void filterViewsBySchema(List<View> views, ViewOperation operation) {
        for (View view : views) {
            Property schemaAdditionalProperty = VertabeloXMLDatabase.findAdditionalProperty(SCHEMA_ADDITIONAL_PROPERTY_NAME, view.getProperties());
            String schemaName = VertabeloXMLDatabase.getAdditionalPropertyValueOrEmpty(schemaAdditionalProperty);
            if (!this.getInputSchemata().contains(schemaName)) continue;
            operation.invoke(view, schemaName);
        }
    }

    public static Property findAdditionalProperty(String name, List<Property> properties) {
        for (Property property : properties) {
            if (!property.getName().equalsIgnoreCase(name)) continue;
            return property;
        }
        return null;
    }

    public static String getAdditionalPropertyValueOrEmpty(Property additionalProperty) {
        if (additionalProperty != null) {
            return additionalProperty.getValue();
        }
        return "";
    }

    static interface ViewOperation {
        public void invoke(View var1, String var2);
    }

    static interface TableOperation {
        public void invoke(Table var1, String var2);
    }
}

