/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.util.jpa;

import java.sql.Connection;
import java.sql.DriverManager;
import java.util.Properties;
import javax.persistence.Entity;
import org.hibernate.cfg.Configuration;
import org.hibernate.dialect.Dialect;
import org.hibernate.tool.hbm2ddl.SchemaExport;
import org.jooq.DSLContext;
import org.jooq.exception.DataAccessException;
import org.jooq.impl.DSL;
import org.jooq.tools.JooqLogger;
import org.jooq.tools.StringUtils;
import org.jooq.util.h2.H2Database;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;

public class JPADatabase
extends H2Database {
    private static final JooqLogger log = JooqLogger.getLogger(JPADatabase.class);
    private Connection connection;

    protected DSLContext create0() {
        if (this.connection == null) {
            String packages = this.getProperties().getProperty("packages");
            if (StringUtils.isBlank((String)packages)) {
                packages = "";
                log.warn((Object)"No packages defined", (Object)"It is highly recommended that you provide explicit packages to scan");
            }
            try {
                this.connection = DriverManager.getConnection("jdbc:h2:mem:jooq-meta-extensions", "sa", "");
                Configuration configuration = new Configuration().setProperty("hibernate.dialect", "org.hibernate.dialect.H2Dialect");
                ClassPathScanningCandidateComponentProvider scanner = new ClassPathScanningCandidateComponentProvider(true);
                scanner.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(Entity.class));
                for (String pkg : packages.split(",")) {
                    for (BeanDefinition def : scanner.findCandidateComponents(StringUtils.defaultIfBlank((String)pkg, (String)"").trim())) {
                        configuration.addAnnotatedClass(Class.forName(def.getBeanClassName()));
                    }
                }
                configuration.generateSchemaCreationScript(Dialect.getDialect((Properties)configuration.getProperties()));
                SchemaExport export = new SchemaExport(configuration, this.connection);
                export.create(true, true);
            }
            catch (Exception e) {
                throw new DataAccessException("Error while exporting schema", (Throwable)e);
            }
        }
        return DSL.using((Connection)this.connection);
    }
}

