/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.meta.extensions.ddl;

import java.io.File;
import java.sql.Connection;
import java.util.regex.Pattern;
import org.jooq.DSLContext;
import org.jooq.FilePattern;
import org.jooq.Name;
import org.jooq.QueryPart;
import org.jooq.Source;
import org.jooq.VisitContext;
import org.jooq.VisitListener;
import org.jooq.conf.ParseUnknownFunctions;
import org.jooq.conf.Settings;
import org.jooq.conf.SettingsTools;
import org.jooq.impl.DSL;
import org.jooq.impl.DefaultVisitListener;
import org.jooq.impl.ParserException;
import org.jooq.meta.extensions.AbstractInterpretingDatabase;
import org.jooq.tools.JooqLogger;
import org.jooq.tools.StringUtils;

public class DDLDatabase
extends AbstractInterpretingDatabase {
    private static final JooqLogger log = JooqLogger.getLogger(DDLDatabase.class);
    private static final Pattern P_NAME = Pattern.compile("(?s:.*?\"([^\"]*)\".*)");
    private boolean logExecutedQueries = true;
    private boolean logExecutionResults = true;

    @Override
    protected void export() throws Exception {
        Settings defaultSettings = new Settings();
        String scripts = this.getProperties().getProperty("scripts");
        String encoding = this.getProperties().getProperty("encoding", "UTF-8");
        String sort = this.getProperties().getProperty("sort", "semantic").toLowerCase();
        final String defaultNameCase = this.getProperties().getProperty("defaultNameCase", "as_is").toUpperCase();
        boolean parseIgnoreComments = !"false".equalsIgnoreCase(this.getProperties().getProperty("parseIgnoreComments"));
        String parseIgnoreCommentStart = this.getProperties().getProperty("parseIgnoreCommentStart", defaultSettings.getParseIgnoreCommentStart());
        String parseIgnoreCommentStop = this.getProperties().getProperty("parseIgnoreCommentStop", defaultSettings.getParseIgnoreCommentStop());
        this.logExecutedQueries = !"false".equalsIgnoreCase(this.getProperties().getProperty("logExecutedQueries"));
        boolean bl = this.logExecutionResults = !"false".equalsIgnoreCase(this.getProperties().getProperty("logExecutionResults"));
        if (StringUtils.isBlank((String)scripts)) {
            scripts = "";
            log.warn((Object)"No scripts defined", (Object)"It is recommended that you provide an explicit script directory to scan");
        }
        try {
            final DSLContext ctx = DSL.using((Connection)this.connection(), (Settings)new Settings().withParseIgnoreComments(Boolean.valueOf(parseIgnoreComments)).withParseIgnoreCommentStart(parseIgnoreCommentStart).withParseIgnoreCommentStop(parseIgnoreCommentStop).withParseUnknownFunctions(ParseUnknownFunctions.IGNORE));
            ctx.data((Object)"org.jooq.ddl.ignore-storage-clauses", (Object)true);
            ctx.data((Object)"org.jooq.ddl.parse-for-ddldatabase", (Object)true);
            if (!"AS_IS".equals(defaultNameCase)) {
                ctx.configuration().set(new VisitListener[]{new DefaultVisitListener(){

                    public void visitStart(VisitContext vc) {
                        if (vc.queryPart() instanceof Name) {
                            Name[] parts = ((Name)vc.queryPart()).parts();
                            boolean changed = false;
                            for (int i = 0; i < parts.length; ++i) {
                                if (parts[i].quoted() != Name.Quoted.UNQUOTED) continue;
                                parts[i] = DSL.quotedName((String)("UPPER".equals(defaultNameCase) ? parts[i].first().toUpperCase(SettingsTools.renderLocale((Settings)ctx.settings())) : parts[i].first().toLowerCase(SettingsTools.renderLocale((Settings)ctx.settings()))));
                                changed = true;
                            }
                            if (changed) {
                                vc.queryPart((QueryPart)DSL.name((Name[])parts));
                            }
                        }
                    }
                }});
            }
            new FilePattern().encoding(encoding).basedir(new File(this.getBasedir())).pattern(scripts).sort(FilePattern.Sort.of((String)sort)).load(source -> this.load(ctx, (Source)source));
        }
        catch (ParserException e) {
            log.error((Object)("An exception occurred while parsing script source : " + scripts + ". Please report this error to https://github.com/jOOQ/jOOQ/issues/new"), (Throwable)e);
            throw e;
        }
    }

    /*
     * Exception decompiling
     */
    private void load(DSLContext ctx, Source source) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

