/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.meta.extensions.ddl;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Scanner;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.h2.Driver;
import org.jooq.CreateSchemaFinalStep;
import org.jooq.DSLContext;
import org.jooq.Queries;
import org.jooq.Query;
import org.jooq.exception.DataAccessException;
import org.jooq.impl.DSL;
import org.jooq.impl.ParserException;
import org.jooq.meta.SchemaDefinition;
import org.jooq.meta.extensions.tools.FileComparator;
import org.jooq.meta.h2.H2Database;
import org.jooq.tools.JooqLogger;
import org.jooq.tools.StringUtils;
import org.jooq.tools.jdbc.JDBCUtils;

public class DDLDatabase
extends H2Database {
    private static final JooqLogger log = JooqLogger.getLogger(DDLDatabase.class);
    private static final Pattern P_NAME = Pattern.compile("(?s:.*?\"([^\"]*)\".*)");
    private Connection connection;
    private DSLContext ctx;
    private Comparator<File> fileComparator;

    protected DSLContext create0() {
        if (this.connection == null) {
            String scripts = this.getProperties().getProperty("scripts");
            String encoding = this.getProperties().getProperty("encoding", "UTF-8");
            String sort = this.getProperties().getProperty("sort", "semantic").toLowerCase();
            this.fileComparator = "alphanumeric".equals(sort) ? new Comparator<File>(){

                @Override
                public int compare(File o1, File o2) {
                    return o1.compareTo(o2);
                }
            } : ("none".equals(sort) ? null : FileComparator.INSTANCE);
            if (StringUtils.isBlank((String)scripts)) {
                scripts = "";
                log.warn((Object)"No scripts defined", (Object)"It is recommended that you provide an explicit script directory to scan");
            }
            try {
                Properties info = new Properties();
                info.put("user", "sa");
                info.put("password", "");
                this.connection = new Driver().connect("jdbc:h2:mem:jooq-meta-extensions-" + UUID.randomUUID(), info);
                this.ctx = DSL.using((Connection)this.connection);
                InputStream in = null;
                boolean loaded = false;
                in = DDLDatabase.class.getResourceAsStream(scripts);
                if (in != null) {
                    log.info((Object)("Reading from classpath: " + scripts));
                    this.load(encoding, in);
                    loaded = true;
                } else {
                    File file = new File(scripts);
                    if (file.exists()) {
                        this.load(encoding, file, null);
                        loaded = true;
                    } else if ((scripts.contains("*") || scripts.contains("?")) && (file = new File(scripts.replaceAll("[*?].*", ""))).exists()) {
                        Pattern pattern = Pattern.compile(scripts.replace("\\", "/").replace(".", "\\.").replace("?", ".").replace("**", ".+?").replace("*", "[^/]*"));
                        this.load(encoding, file, pattern);
                        loaded = true;
                    }
                }
                if (!loaded) {
                    log.error((Object)("Could not find script source : " + scripts));
                }
            }
            catch (ParserException e) {
                log.error((Object)("An exception occurred while parsing script source : " + scripts + ". Please report this error to https://github.com/jOOQ/jOOQ/issues/new"), (Throwable)e);
                throw e;
            }
            catch (Exception e) {
                throw new DataAccessException("Error while exporting schema", (Throwable)e);
            }
        }
        return this.ctx;
    }

    private void load(String encoding, File file, Pattern pattern) throws IOException {
        if (file.isFile()) {
            if (pattern == null || pattern.matcher(file.getCanonicalPath().replace("\\", "/")).matches()) {
                log.info((Object)("Reading from: " + file + " [*]"));
                this.load(encoding, new FileInputStream(file));
            }
        } else if (file.isDirectory()) {
            log.info((Object)("Reading from: " + file));
            File[] files = file.listFiles();
            if (files != null) {
                if (this.fileComparator != null) {
                    Arrays.sort(files, this.fileComparator);
                }
                for (File f : files) {
                    this.load(encoding, f, pattern);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void load(String encoding, InputStream in) {
        try {
            Scanner s = new Scanner(in, encoding).useDelimiter("\\A");
            Queries queries = this.ctx.parser().parse(s.hasNext() ? s.next() : "");
            Iterator iterator = queries.iterator();
            block9: while (iterator.hasNext()) {
                Query query = (Query)iterator.next();
                while (true) {
                    try {
                        query.execute();
                        log.info((Object)query);
                        continue block9;
                    }
                    catch (DataAccessException e) {
                        if (!Integer.toString(90079).equals(e.sqlState())) throw e;
                        SQLException cause = (SQLException)e.getCause(SQLException.class);
                        if (cause == null) throw e;
                        Matcher m = P_NAME.matcher(cause.getMessage());
                        if (!m.find()) throw e;
                        CreateSchemaFinalStep createSchema = this.ctx.createSchemaIfNotExists(DSL.name((String)m.group(1)));
                        createSchema.execute();
                        log.info((Object)createSchema);
                        continue;
                    }
                    break;
                }
            }
            return;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public void close() {
        JDBCUtils.safeClose((Connection)this.connection);
        this.connection = null;
        this.ctx = null;
        super.close();
    }

    protected List<SchemaDefinition> getSchemata0() throws SQLException {
        ArrayList<SchemaDefinition> result = new ArrayList<SchemaDefinition>(super.getSchemata0());
        Iterator it = result.iterator();
        while (it.hasNext()) {
            if (!"INFORMATION_SCHEMA".equals(((SchemaDefinition)it.next()).getName())) continue;
            it.remove();
        }
        return result;
    }
}

