/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.meta.extensions.jpa;

import jakarta.persistence.SharedCacheMode;
import jakarta.persistence.ValidationMode;
import jakarta.persistence.spi.ClassTransformer;
import jakarta.persistence.spi.PersistenceUnitInfo;
import jakarta.persistence.spi.PersistenceUnitTransactionType;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import javax.sql.DataSource;
import org.hibernate.jpa.HibernatePersistenceProvider;

final class PersistenceUnitInfoImpl
implements PersistenceUnitInfo {
    private final String persistenceUnitName;
    private PersistenceUnitTransactionType transactionType = PersistenceUnitTransactionType.RESOURCE_LOCAL;
    private final List<String> managedClassNames;
    private final List<String> mappingFileNames = new ArrayList<String>();
    private final Properties properties;
    private DataSource jtaDataSource;
    private DataSource nonJtaDataSource;

    PersistenceUnitInfoImpl(String persistenceUnitName, List<String> managedClassNames, Properties properties) {
        this.persistenceUnitName = persistenceUnitName;
        this.managedClassNames = managedClassNames;
        this.properties = properties;
    }

    public final String getPersistenceUnitName() {
        return this.persistenceUnitName;
    }

    public final String getPersistenceProviderClassName() {
        return HibernatePersistenceProvider.class.getName();
    }

    public final PersistenceUnitTransactionType getTransactionType() {
        return this.transactionType;
    }

    public final DataSource getJtaDataSource() {
        return this.jtaDataSource;
    }

    public final PersistenceUnitInfoImpl setJtaDataSource(DataSource jtaDataSource) {
        this.jtaDataSource = jtaDataSource;
        this.nonJtaDataSource = null;
        this.transactionType = PersistenceUnitTransactionType.JTA;
        return this;
    }

    public final DataSource getNonJtaDataSource() {
        return this.nonJtaDataSource;
    }

    public final PersistenceUnitInfoImpl setNonJtaDataSource(DataSource nonJtaDataSource) {
        this.nonJtaDataSource = nonJtaDataSource;
        this.jtaDataSource = null;
        this.transactionType = PersistenceUnitTransactionType.RESOURCE_LOCAL;
        return this;
    }

    public final List<String> getMappingFileNames() {
        return this.mappingFileNames;
    }

    public final List<URL> getJarFileUrls() {
        return Collections.emptyList();
    }

    public final URL getPersistenceUnitRootUrl() {
        return null;
    }

    public final List<String> getManagedClassNames() {
        return this.managedClassNames;
    }

    public final boolean excludeUnlistedClasses() {
        return false;
    }

    public final SharedCacheMode getSharedCacheMode() {
        return SharedCacheMode.UNSPECIFIED;
    }

    public final ValidationMode getValidationMode() {
        return ValidationMode.AUTO;
    }

    public final Properties getProperties() {
        return this.properties;
    }

    public final String getPersistenceXMLSchemaVersion() {
        return "2.1";
    }

    public final ClassLoader getClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    public final void addTransformer(ClassTransformer transformer) {
    }

    public final ClassLoader getNewTempClassLoader() {
        return null;
    }
}

